/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.com.amazon.dax;

import java.util.Arrays;
import software.amazon.dax.com.amazon.cbor.Utils;

public final class Frame {
    public static final int FRAME_HEADER_LENGTH = 8;
    private static final int LENGTH_OFFSET = 0;
    private static final int FLAG_OFFSET = 4;
    private int length;
    private boolean endOfMessage;

    private Frame() {
    }

    public static void castHeader(byte[] buffer, int offset, int length, boolean endOfMessage) {
        Arrays.fill(buffer, offset, offset + 8, (byte)0);
        Utils.encodeIntBE(buffer, offset + 0, length);
        if (endOfMessage) {
            int n = offset + 4;
            buffer[n] = (byte)(buffer[n] | 1);
        }
    }

    public static Frame createFrameHeader(byte[] buf, int offset) {
        boolean endOfMessage;
        int length = Utils.decodeIntBE(buf, offset + 0);
        boolean bl = endOfMessage = (buf[offset + 4] & 1) > 0;
        if (length < 0) {
            throw new IllegalArgumentException("Frame length should not be negative: " + length);
        }
        return new Frame().length(length).endOfMessage(endOfMessage);
    }

    public int length() {
        return this.length;
    }

    public boolean endOfMessage() {
        return this.endOfMessage;
    }

    private Frame length(int length) {
        this.length = length;
        return this;
    }

    private Frame endOfMessage(boolean endOfMessage) {
        this.endOfMessage = endOfMessage;
        return this;
    }
}

