/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.com.amazon.cbor;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import software.amazon.dax.com.amazon.cbor.Encoder;

public class CborOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final OutputStream mOut;
    private final OutputStream mInnerOut;

    public CborOutputStream() {
        this(new ByteArrayOutputStream());
    }

    public CborOutputStream(OutputStream output) {
        this(output, 8192);
    }

    public CborOutputStream(OutputStream output, int buffSize) {
        this.mInnerOut = output;
        if (buffSize > 0) {
            output = new BufferedOutputStream(output, buffSize);
        }
        this.mOut = output;
    }

    @Override
    public void flush() throws IOException {
        this.mOut.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.mOut.write(b);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.mOut.write(bytes, offset, length);
    }

    public void writeString(String s) throws IOException {
        byte[] bytes = Encoder.encodeUtf8(s);
        this.writeType(96, bytes.length);
        this.mOut.write(bytes);
    }

    public void writeString(byte[] utf8Bytes) throws IOException {
        this.writeType(96, utf8Bytes.length);
        this.write(utf8Bytes, 0, utf8Bytes.length);
    }

    public void writeBinary(ByteBuffer buff) throws IOException {
        buff.mark();
        byte[] bytes = new byte[buff.remaining()];
        buff.get(bytes, 0, bytes.length);
        buff.reset();
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
        this.writeType(64, length);
        this.write(bytes, offset, length);
    }

    public void writeRawBinary(ByteBuffer buff) throws IOException {
        if (buff.hasArray()) {
            this.mOut.write(buff.array(), buff.arrayOffset(), buff.limit());
        } else {
            buff.mark();
            byte[] bytes = new byte[buff.remaining()];
            buff.get(bytes, 0, bytes.length);
            buff.reset();
            this.write(bytes, 0, bytes.length);
        }
    }

    public void writeBoolean(boolean b) throws IOException {
        this.mOut.write(b ? 245 : 244);
    }

    public void writeNull() throws IOException {
        this.mOut.write(246);
    }

    public void writeLong(long v) throws IOException {
        long signum = v >> 63;
        this.writeType(0 | (int)signum & 0x20, v ^ signum);
    }

    public void writeFloat(float f) throws IOException {
        int value = Float.floatToRawIntBits(f);
        this.mOut.write(250);
        this.mOut.write(value >> 24);
        this.mOut.write(value >> 16);
        this.mOut.write(value >> 8);
        this.mOut.write(value);
    }

    public void writeDouble(double d) throws IOException {
        this.writeType64(251, Double.doubleToRawLongBits(d));
    }

    public void writeInt(int i) throws IOException {
        this.writeLong(i);
    }

    public void writeBigInteger(BigInteger bi) throws IOException {
        int signum = bi.signum() >> 1;
        int bits = bi.bitLength();
        if (bits < 64) {
            this.writeLong(bi.longValue());
            return;
        }
        if (bits == 64) {
            this.writeType64(0x1B | signum & 0x20, bi.longValue() ^ (long)signum);
            return;
        }
        this.doWriteBigInteger(bi, signum);
    }

    void doWriteBigInteger(BigInteger bi) throws IOException {
        this.doWriteBigInteger(bi, bi.signum() >> 1);
    }

    private void doWriteBigInteger(BigInteger bi, int signum) throws IOException {
        byte[] bytes = bi.toByteArray();
        this.mOut.write(0xC2 | signum & 1);
        this.writeType(64, bytes.length);
        if (bi.signum() < 0) {
            Encoder.flipCopy(bytes, 0, bytes, 0, bytes.length);
        }
        this.mOut.write(bytes);
    }

    public void writeBigDecimal(BigDecimal bd) throws IOException {
        this.mOut.write(196);
        this.writeArrayHeader(2);
        this.writeInt(-bd.scale());
        this.writeBigInteger(bd.unscaledValue());
    }

    public void writeNumber(String number) throws IOException {
        if (Encoder.isDecimal(number)) {
            this.writeBigDecimal(new BigDecimal(number));
        } else if (number.length() > 18) {
            this.writeBigInteger(new BigInteger(number));
        } else {
            this.writeLong(Long.parseLong(number));
        }
    }

    public void writeCollection(Collection<?> col) throws IOException {
        this.writeArrayHeader(col.size());
        for (Object obj : col) {
            this.writeObject(obj);
        }
    }

    private void writeObject(Object obj) throws IOException {
        if (obj == null) {
            this.writeNull();
            return;
        }
        if (obj instanceof byte[]) {
            this.writeBytes((byte[])obj);
            return;
        }
        if (obj instanceof String) {
            this.writeString((String)obj);
            return;
        }
        if (obj instanceof Integer) {
            this.writeInt((Integer)obj);
            return;
        }
        if (obj instanceof Long) {
            this.writeLong((Long)obj);
            return;
        }
        if (obj instanceof Double) {
            this.writeDouble((Double)obj);
            return;
        }
        if (obj instanceof Float) {
            this.writeFloat(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof BigDecimal) {
            this.writeBigDecimal((BigDecimal)obj);
            return;
        }
        if (obj instanceof BigInteger) {
            this.writeBigInteger((BigInteger)obj);
            return;
        }
        if (obj instanceof Boolean) {
            this.writeBoolean((Boolean)obj);
            return;
        }
        if (obj instanceof ByteBuffer) {
            this.writeBinary((ByteBuffer)obj);
            return;
        }
        throw new IllegalArgumentException("unsupported object: " + obj);
    }

    public void writeArrayHeader(int numElems) throws IOException {
        this.writeType(128, numElems);
    }

    public void writeMapHeader(int numPairs) throws IOException {
        this.writeType(160, numPairs);
    }

    public void writeStringStreamHeader() throws IOException {
        this.write(127);
    }

    public void writeBytesStreamHeader() throws IOException {
        this.write(95);
    }

    public void writeArrayStreamHeader() throws IOException {
        this.write(159);
    }

    public void writeMapStreamHeader() throws IOException {
        this.write(191);
    }

    public void writeStreamBreak() throws IOException {
        this.write(255);
    }

    public void writeTag(long tagType) throws IOException {
        if (tagType >= 0L) {
            this.writeType(192, tagType);
        } else {
            this.writeType64(219, tagType);
        }
    }

    protected void writeType(int majorType, long value) throws IOException {
        if (value < 24L) {
            this.mOut.write((byte)((long)majorType | value));
        } else {
            if (value < 256L) {
                this.mOut.write(majorType + 24);
            } else {
                if (Math.abs(value) < 65536L) {
                    this.mOut.write(majorType + 25);
                } else {
                    if (Math.abs(value) < 0x100000000L) {
                        this.mOut.write(majorType + 26);
                    } else {
                        this.mOut.write(majorType + 27);
                        this.mOut.write((byte)(value >> 56));
                        this.mOut.write((byte)(value >> 48));
                        this.mOut.write((byte)(value >> 40));
                        this.mOut.write((byte)(value >> 32));
                    }
                    this.mOut.write((byte)(value >> 24));
                    this.mOut.write((byte)(value >> 16));
                }
                this.mOut.write((byte)(value >> 8));
            }
            this.mOut.write((byte)value);
        }
    }

    protected void writeType64(int type, long value) throws IOException {
        this.mOut.write(type);
        this.mOut.write((byte)(value >> 56));
        this.mOut.write((byte)(value >> 48));
        this.mOut.write((byte)(value >> 40));
        this.mOut.write((byte)(value >> 32));
        this.mOut.write((byte)(value >> 24));
        this.mOut.write((byte)(value >> 16));
        this.mOut.write((byte)(value >> 8));
        this.mOut.write((byte)value);
    }

    protected OutputStream getWrappedOutput() {
        return this.mInnerOut;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.mOut.close();
    }

    public byte[] getBytesForTest() throws IOException {
        this.flush();
        ByteArrayOutputStream baout = (ByteArrayOutputStream)this.getWrappedOutput();
        byte[] bytes = baout.toByteArray();
        baout.reset();
        return bytes;
    }
}

