/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.retry;

import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.services.dynamodb.model.TransactionInProgressException;
import software.amazon.dax.retry.RetryContext;
import software.amazon.dax.utils.Utils;

public class WriteRetryContext
extends RetryContext {
    WriteRetryContext(BackoffStrategy backoffStrategy, int maxTries) {
        super(backoffStrategy, maxTries);
    }

    @Override
    protected boolean isRetryable(SdkException e) {
        if (Utils.isWriteFailureAmbiguous(e)) {
            return false;
        }
        if (e instanceof TransactionInProgressException) {
            return true;
        }
        return super.isRetryable(e);
    }
}

