/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.retry;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.dax.DaxAsyncClient;
import software.amazon.dax.exceptions.NoClusterEndpointsAvailableException;
import software.amazon.dax.retry.RetryContext;
import software.amazon.dax.retry.WriteRetryContext;
import software.amazon.dax.utils.CheckedFunction;

public class RetryHandler {
    private final int maxReadTries;
    private final int maxWriteTries;
    private final BackoffStrategy backoffStrategy;
    private final CheckedFunction<DaxAsyncClient, DaxAsyncClient, Exception> clientFactory;
    private final ScheduledExecutorService es;
    private final Executor executor;

    public RetryHandler(BackoffStrategy backoffStrategy, ScheduledExecutorService es, Executor executor, CheckedFunction<DaxAsyncClient, DaxAsyncClient, Exception> clientFactory, int maxReadTries, int maxWriteTries) {
        this.backoffStrategy = backoffStrategy;
        this.es = es;
        this.executor = executor;
        this.clientFactory = clientFactory;
        this.maxReadTries = maxReadTries;
        this.maxWriteTries = maxWriteTries;
    }

    public <R> CompletableFuture<R> makeWriteRequestWithRetries(Function<DaxAsyncClient, CompletableFuture<R>> task) {
        CompletableFuture future = new CompletableFuture();
        WriteRetryContext retryContext = new WriteRetryContext(this.backoffStrategy, this.maxWriteTries);
        this.retry(retryContext, task, null, future);
        return future;
    }

    public <R> CompletableFuture<R> makeReadRequestWithRetries(Function<DaxAsyncClient, CompletableFuture<R>> task) {
        CompletableFuture future = new CompletableFuture();
        RetryContext retryContext = new RetryContext(this.backoffStrategy, this.maxReadTries);
        this.retry(retryContext, task, null, future);
        return future;
    }

    private <R> void retry(RetryContext retryContext, Function<DaxAsyncClient, CompletableFuture<R>> task, DaxAsyncClient prev, CompletableFuture<R> future) {
        if (!retryContext.retry()) {
            future.completeExceptionally(retryContext.lastException());
            return;
        }
        try {
            DaxAsyncClient client = this.clientFactory.apply(prev);
            if (client != null) {
                task.apply(client).whenComplete((result, e) -> {
                    if (e != null) {
                        retryContext.onException(RetryHandler.toAce(e));
                        this.es.schedule(() -> this.executor.execute(() -> this.retry(retryContext, task, client, future)), retryContext.pauseBeforeRetry(), TimeUnit.MILLISECONDS);
                    } else {
                        future.complete(result);
                    }
                });
            } else {
                this.es.schedule(() -> this.executor.execute(() -> this.retry(retryContext, task, null, future)), retryContext.pauseBeforeRetry(), TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e2) {
            retryContext.onException(RetryHandler.toAce(e2));
            this.es.schedule(() -> this.executor.execute(() -> this.retry(retryContext, task, prev, future)), retryContext.pauseBeforeRetry(), TimeUnit.MILLISECONDS);
        }
    }

    static SdkException toAce(Throwable lastException) {
        if (lastException instanceof SdkException) {
            return (SdkException)lastException;
        }
        if (lastException != null) {
            return SdkClientException.create((String)("Unable to call cluster endpoint: " + lastException.getMessage()), (Throwable)lastException);
        }
        return new NoClusterEndpointsAvailableException();
    }
}

