/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.retry;

import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.exceptions.DaxServiceException;
import software.amazon.dax.retry.RetryHandler;

class RetryContext {
    private final int maxTries;
    private volatile int requestCount = 0;
    private SdkException lastException;
    private final BackoffStrategy backoffStrategy;

    RetryContext(BackoffStrategy backoffStrategy, int maxTries) {
        this.backoffStrategy = backoffStrategy;
        this.maxTries = maxTries;
    }

    void onException(SdkException e) {
        if (this.lastException != null) {
            if (this.lastException.getCause() != null) {
                e.addSuppressed(this.lastException.getCause());
            } else {
                e.addSuppressed((Throwable)this.lastException);
            }
        }
        this.lastException = e;
    }

    boolean retry() {
        return this.maxTries - this.requestCount++ > 0 && this.isRetryable(this.lastException);
    }

    boolean isRetryable(SdkException e) {
        if (e == null) {
            return true;
        }
        if (e instanceof DaxServiceException || e.getCause() instanceof DaxServiceException) {
            DaxServiceException dse = e instanceof DaxServiceException ? (DaxServiceException)((Object)e) : (DaxServiceException)((Object)e.getCause());
            return DynamoNumerals.ErrorCodes.THROTTLING_ERROR.mErrorCode.equals(dse.awsErrorDetails().errorCode()) || dse.statusCode() == 503 || dse.retryable();
        }
        if (e instanceof AwsServiceException) {
            AwsServiceException ase = (AwsServiceException)e;
            return ase instanceof InternalServerErrorException || ase instanceof LimitExceededException || ase instanceof ProvisionedThroughputExceededException || DynamoNumerals.ErrorCodes.THROTTLING_ERROR.mErrorCode.equals(ase.awsErrorDetails().errorCode()) || ase.statusCode() == 503;
        }
        return true;
    }

    long pauseBeforeRetry() {
        RetryPolicyContext retryPolicyContext = RetryPolicyContext.builder().exception(RetryHandler.toAce(this.lastException)).retriesAttempted(this.requestCount - 1).build();
        return this.backoffStrategy.computeDelayBeforeNextRetry(retryPolicyContext).toMillis();
    }

    SdkException lastException() {
        return this.lastException;
    }
}

