/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.dax.channel.RequestEncoder;
import software.amazon.dax.com.amazon.cbor.Encoder;
import software.amazon.dax.com.amazon.cbor.SegmentPool;
import software.amazon.dax.com.amazon.dax.Constants;
import software.amazon.dax.com.amazon.dax.bits.DaxCborOutputStream;
import software.amazon.dax.com.amazon.dax.bits.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.com.amazon.dax.bits.expr.ExpressionType;
import software.amazon.dax.com.amazon.dax.client.dynamodb.DaxRequestEncoder;
import software.amazon.dax.dynamodb.AttributeValueEncoder;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.DynamoDBExpressionInfo;
import software.amazon.dax.dynamodb.DynamoDBV1Converter;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.RequestValidator;
import software.amazon.dax.exceptions.ExceptionTranslator;
import software.amazon.dax.expr.ExpressionValidationModel;

public class ScanRequestEncoder
extends RequestEncoder<ScanRequest> {
    private final SegmentPool segmentPool;
    private final RefreshingCache<String, List<AttributeDefinition>> cache;
    private final AtomicReference<Map<Integer, DocumentPath>> projectionOrdinals;
    private final AtomicReference<String> indexName;

    public ScanRequestEncoder(SegmentPool segmentPool, RefreshingCache<String, List<AttributeDefinition>> cache, AtomicReference<Map<Integer, DocumentPath>> projectionOrdinals, AtomicReference<String> indexName) {
        this.segmentPool = segmentPool;
        this.cache = cache;
        this.projectionOrdinals = projectionOrdinals;
        this.indexName = indexName;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ScanRequest request, ChannelPromise promise) throws Exception {
        RequestValidator.validateTableName(request.tableName());
        RequestValidator.validateExpression(new ExpressionValidationModel().projectionExpression(request.projectionExpression()).filterExpression(request.filterExpression()).conditionalOperator(request.conditionalOperatorAsString()).attributesToGet(request.hasAttributesToGet() ? request.attributesToGet() : null).expressionAttributeNames(request.hasExpressionAttributeNames() ? request.expressionAttributeNames() : null).expressionAttributeValues(request.hasExpressionAttributeValues() ? request.expressionAttributeValues() : null).scanFilter(request.hasScanFilter() ? request.scanFilter() : null));
        this.cache.get(request.tableName()).whenComplete((keys, e) -> {
            if (e != null) {
                promise.setFailure(e);
            } else {
                try {
                    this.encodeAndWrite(ctx, request, (List<AttributeDefinition>)keys, promise);
                }
                catch (Exception exception) {
                    promise.setFailure((Throwable)exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeAndWrite(ChannelHandlerContext ctx, ScanRequest request, List<AttributeDefinition> keys, ChannelPromise promise) throws Exception {
        byte[] projection;
        byte[] filterExp;
        DynamoDBExpressionInfo exp = null;
        try {
            exp = DynamoDBV1Converter.isV1Request(request) ? DynamoDBV1Converter.convertV1RequestToV2(request) : new DynamoDBExpressionInfo(request);
            Map<ExpressionType, byte[]> exprs = AttributeValueEncoder.encodeExpressions(null, null, exp.getFilterExpression(), null, exp.getProjectionExpression(), exp.getExpressionAttributeNames(), exp.getExpressionAttributeValues());
            filterExp = exprs.get((Object)ExpressionType.Filter);
            projection = exprs.get((Object)ExpressionType.Projection);
            this.projectionOrdinals.compareAndSet(null, new HashMap());
            AttributeValueEncoder.prepareProjection(exp, this.projectionOrdinals.get());
        }
        catch (IllegalArgumentException e) {
            throw ExceptionTranslator.createValidationException(e.getMessage());
        }
        byte[] tableName = Encoder.encodeUtf8(request.tableName());
        String ix = request.indexName();
        this.indexName.compareAndSet(null, ix);
        byte[] ixName = ix == null ? null : Encoder.encodeUtf8(ix);
        DynamoNumerals.SelectValue select = DynamoNumerals.SelectValue.fromName(request.selectAsString());
        if (DynamoNumerals.SelectValue.ALL_PROJECTED_ATTRIBUTES.equals((Object)select) && ix == null) {
            throw ExceptionTranslator.createValidationException("ALL_PROJECTED_ATTRIBUTES can be used only when Querying using an IndexName");
        }
        byte[] startExclusiveKey = null;
        if (request.hasExclusiveStartKey()) {
            SegmentPool.Segment tail;
            SegmentPool.Segment head = tail = this.segmentPool.alloc();
            try {
                if (ixName == null) {
                    AttributeValueEncoder.encodeKey(this.segmentPool, tail, request.exclusiveStartKey(), keys);
                } else {
                    AttributeValueEncoder.encodeCompoundKey(this.segmentPool, tail, request.exclusiveStartKey());
                }
                startExclusiveKey = this.segmentPool.chainCopyAndTrim(head, 0);
            }
            finally {
                this.segmentPool.recycle(head);
            }
        }
        Integer limit = request.limit();
        Boolean consistentRead = request.consistentRead();
        DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.returnConsumedCapacityAsString());
        EnumMap<Constants.DaxDataRequestParam, Object> optionalArgs = new EnumMap<Constants.DaxDataRequestParam, Object>(Constants.DaxDataRequestParam.class);
        optionalArgs.put(Constants.DaxDataRequestParam.IndexName, ixName);
        optionalArgs.put(Constants.DaxDataRequestParam.FilterExpression, filterExp);
        optionalArgs.put(Constants.DaxDataRequestParam.ProjectionExpression, projection);
        if (request.select() != null) {
            optionalArgs.put(Constants.DaxDataRequestParam.Select, Integer.valueOf(select.mCode));
        }
        optionalArgs.put(Constants.DaxDataRequestParam.ExclusiveStartKey, startExclusiveKey);
        optionalArgs.put(Constants.DaxDataRequestParam.ReturnConsumedCapacity, Integer.valueOf(returnConsumedCapacity.mCode));
        optionalArgs.put(Constants.DaxDataRequestParam.ConsistentRead, Boolean.valueOf(consistentRead != null ? consistentRead : false));
        if (limit != null) {
            optionalArgs.put(Constants.DaxDataRequestParam.Limit, limit);
        }
        if (request.segment() != null) {
            optionalArgs.put(Constants.DaxDataRequestParam.Segment, request.segment());
        }
        if (request.totalSegments() != null) {
            optionalArgs.put(Constants.DaxDataRequestParam.TotalSegments, request.totalSegments());
        }
        byte[] optional = null;
        if (optionalArgs.size() > 0) {
            optional = DaxRequestEncoder.encodeOptionalArgs(optionalArgs, this.segmentPool);
        }
        ByteBuf buffer = ctx.alloc().buffer();
        try (DaxCborOutputStream out = new DaxCborOutputStream((OutputStream)new ByteBufOutputStream(buffer), 0);){
            out.writeInt(1);
            out.writeInt(-1875390620);
            out.writeBytes(tableName);
            if (optional == null) {
                out.writeNull();
            } else {
                out.write(optional);
            }
            out.flush();
            ctx.writeAndFlush((Object)buffer, promise);
        }
    }
}

