/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class DynamoDBExpressionInfo {
    private String mProjectionExpression = null;
    private String mConditionExpression = null;
    private String mUpdateExpression = null;
    private String mKeyConditionExpression = null;
    private String mFilterExpression = null;
    private Map<String, AttributeValue> mExpressionAttributeValues = null;
    private Map<String, String> mExpressionAttributeNames = null;

    public DynamoDBExpressionInfo(GetItemRequest request) {
        this.mProjectionExpression = request.projectionExpression();
        this.mExpressionAttributeNames = request.hasExpressionAttributeNames() ? request.expressionAttributeNames() : null;
    }

    public DynamoDBExpressionInfo(DeleteItemRequest request) {
        this.mConditionExpression = request.conditionExpression();
        this.mExpressionAttributeNames = request.hasExpressionAttributeNames() ? request.expressionAttributeNames() : null;
        this.mExpressionAttributeValues = request.hasExpressionAttributeValues() ? request.expressionAttributeValues() : null;
    }

    public DynamoDBExpressionInfo(UpdateItemRequest request) {
        this.mUpdateExpression = request.updateExpression();
        this.mConditionExpression = request.conditionExpression();
        this.mExpressionAttributeNames = request.hasExpressionAttributeNames() ? request.expressionAttributeNames() : null;
        this.mExpressionAttributeValues = request.hasExpressionAttributeValues() ? request.expressionAttributeValues() : null;
    }

    public DynamoDBExpressionInfo(QueryRequest request) {
        this.mKeyConditionExpression = request.keyConditionExpression();
        this.mFilterExpression = request.filterExpression();
        this.mProjectionExpression = request.projectionExpression();
        this.mExpressionAttributeNames = request.hasExpressionAttributeNames() ? request.expressionAttributeNames() : null;
        this.mExpressionAttributeValues = request.hasExpressionAttributeValues() ? request.expressionAttributeValues() : null;
    }

    public DynamoDBExpressionInfo(ScanRequest request) {
        this.mFilterExpression = request.filterExpression();
        this.mProjectionExpression = request.projectionExpression();
        this.mExpressionAttributeNames = request.hasExpressionAttributeNames() ? request.expressionAttributeNames() : null;
        this.mExpressionAttributeValues = request.hasExpressionAttributeValues() ? request.expressionAttributeValues() : null;
    }

    public DynamoDBExpressionInfo(PutItemRequest request) {
        this.mConditionExpression = request.conditionExpression();
        this.mExpressionAttributeNames = request.hasExpressionAttributeNames() ? request.expressionAttributeNames() : null;
        this.mExpressionAttributeValues = request.hasExpressionAttributeValues() ? request.expressionAttributeValues() : null;
    }

    public DynamoDBExpressionInfo(KeysAndAttributes request) {
        this.mProjectionExpression = request.projectionExpression();
        this.mExpressionAttributeNames = request.hasExpressionAttributeNames() ? request.expressionAttributeNames() : null;
    }

    public DynamoDBExpressionInfo(String projectionExpression, String conditionExpression, String updateExpression, String keyConditionExpression, String filterExpression, Map<String, AttributeValue> expressionAttributeValues, Map<String, String> expressionAttributeNames) {
        this.mProjectionExpression = projectionExpression;
        this.mConditionExpression = conditionExpression;
        this.mUpdateExpression = updateExpression;
        this.mKeyConditionExpression = keyConditionExpression;
        this.mFilterExpression = filterExpression;
        this.mExpressionAttributeValues = expressionAttributeValues;
        this.mExpressionAttributeNames = expressionAttributeNames;
    }

    public String getProjectionExpression() {
        return this.mProjectionExpression;
    }

    public String getConditionExpression() {
        return this.mConditionExpression;
    }

    public String getUpdateExpression() {
        return this.mUpdateExpression;
    }

    public String getKeyConditionExpression() {
        return this.mKeyConditionExpression;
    }

    public String getFilterExpression() {
        return this.mFilterExpression;
    }

    public Map<String, AttributeValue> getExpressionAttributeValues() {
        return this.mExpressionAttributeValues;
    }

    public Map<String, String> getExpressionAttributeNames() {
        return this.mExpressionAttributeNames;
    }

    public static class DynamoDBExpressionInfoBuilder {
        private String mProjectionExpression;
        private String mConditionExpression;
        private String mUpdateExpression;
        private String mKeyConditionExpression;
        private String mFilterExpression;
        private Map<String, AttributeValue> mExpressionAttributeValues;
        private Map<String, String> mExpressionAttributeNames;

        public DynamoDBExpressionInfoBuilder setProjectionExpression(String projectionExpression) {
            this.mProjectionExpression = projectionExpression;
            return this;
        }

        public DynamoDBExpressionInfoBuilder setConditionExpression(String conditionExpression) {
            this.mConditionExpression = conditionExpression;
            return this;
        }

        public DynamoDBExpressionInfoBuilder setUpdateExpression(String updateExpression) {
            this.mUpdateExpression = updateExpression;
            return this;
        }

        public DynamoDBExpressionInfoBuilder setKeyConditionExpression(String keyConditionExpression) {
            this.mKeyConditionExpression = keyConditionExpression;
            return this;
        }

        public DynamoDBExpressionInfoBuilder setFilterExpression(String filterExpression) {
            this.mFilterExpression = filterExpression;
            return this;
        }

        public DynamoDBExpressionInfoBuilder setExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            if (expressionAttributeValues != null) {
                this.mExpressionAttributeValues = expressionAttributeValues.isEmpty() ? null : expressionAttributeValues;
            }
            return this;
        }

        public DynamoDBExpressionInfoBuilder setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            if (expressionAttributeNames != null) {
                this.mExpressionAttributeNames = expressionAttributeNames.isEmpty() ? null : expressionAttributeNames;
            }
            return this;
        }

        public DynamoDBExpressionInfo createDynamoDBExpressionInfo() {
            return new DynamoDBExpressionInfo(this.mProjectionExpression, this.mConditionExpression, this.mUpdateExpression, this.mKeyConditionExpression, this.mFilterExpression, this.mExpressionAttributeValues, this.mExpressionAttributeNames);
        }
    }
}

