/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.OutputStream;
import java.util.List;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.dax.channel.RequestEncoder;
import software.amazon.dax.com.amazon.cbor.Encoder;
import software.amazon.dax.com.amazon.cbor.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.DaxCborOutputStream;
import software.amazon.dax.com.amazon.dax.bits.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.com.amazon.dax.client.dynamodb.DaxRequestEncoder;
import software.amazon.dax.dynamodb.AttributeValueEncoder;
import software.amazon.dax.dynamodb.DynamoDBExpressionInfo;
import software.amazon.dax.dynamodb.DynamoDBV1Converter;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.RequestValidator;
import software.amazon.dax.expr.ExpressionValidationModel;

public class DeleteItemRequestEncoder
extends RequestEncoder<DeleteItemRequest> {
    final SegmentPool segmentPool;
    final RefreshingCache<String, List<AttributeDefinition>> cache;

    public DeleteItemRequestEncoder(SegmentPool segmentPool, RefreshingCache<String, List<AttributeDefinition>> cache) {
        this.segmentPool = segmentPool;
        this.cache = cache;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, DeleteItemRequest request, ChannelPromise promise) throws Exception {
        RequestValidator.validateTableName(request.tableName());
        RequestValidator.validateExpression(new ExpressionValidationModel().conditionExpression(request.conditionExpression()).conditionalOperator(request.conditionalOperatorAsString()).expected(request.hasExpected() ? request.expected() : null).expressionAttributeNames(request.hasExpressionAttributeNames() ? request.expressionAttributeNames() : null).expressionAttributeValues(request.hasExpressionAttributeValues() ? request.expressionAttributeValues() : null));
        this.cache.get(request.tableName()).whenComplete((keys, e) -> {
            if (e != null) {
                promise.setFailure(e);
            } else {
                try {
                    this.encodeAndWrite(ctx, request, (List<AttributeDefinition>)keys, promise);
                }
                catch (Exception exception) {
                    promise.setFailure((Throwable)exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeAndWrite(ChannelHandlerContext ctx, DeleteItemRequest request, List<AttributeDefinition> keys, ChannelPromise promise) throws Exception {
        byte[] cborKey;
        SegmentPool.Segment headSegment = this.segmentPool.alloc();
        byte[] tableName = Encoder.encodeUtf8(request.tableName());
        try {
            AttributeValueEncoder.validateAndEncodeKey(this.segmentPool, headSegment, request.key(), keys);
            cborKey = this.segmentPool.chainCopyAndTrim(headSegment, 0);
        }
        finally {
            this.segmentPool.recycle(headSegment);
        }
        DynamoDBExpressionInfo exp = null;
        exp = DynamoDBV1Converter.isV1Request(request) ? DynamoDBV1Converter.convertV1RequestToV2(request) : new DynamoDBExpressionInfo(request);
        DynamoNumerals.ReturnValue returnValue = DynamoNumerals.ReturnValue.fromName(request.returnValuesAsString());
        DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.returnConsumedCapacityAsString());
        DynamoNumerals.ReturnItemCollectionMetrics returnItemCollectionMetrics = DynamoNumerals.ReturnItemCollectionMetrics.fromName(request.returnItemCollectionMetricsAsString());
        byte[] optional = DaxRequestEncoder.encodeItemOperationsOptionalParams(returnValue.mCode, returnConsumedCapacity.mCode, returnItemCollectionMetrics.mCode, AttributeValueEncoder.encodeConditionalExp(exp), null, null, this.segmentPool);
        ByteBuf buffer = ctx.alloc().buffer();
        try (DaxCborOutputStream out = new DaxCborOutputStream((OutputStream)new ByteBufOutputStream(buffer), 0);){
            out.writeInt(1);
            out.writeInt(1013539361);
            out.writeBytes(tableName);
            out.writeBytes(cborKey);
            if (optional == null) {
                out.writeNull();
            } else {
                out.write(optional);
            }
            out.flush();
            ctx.writeAndFlush((Object)buffer, promise);
        }
    }
}

