/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Capacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.dax.com.amazon.cbor.CborInputStream;
import software.amazon.dax.com.amazon.cbor.NonInputStream;
import software.amazon.dax.com.amazon.dax.Constants;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.dynamodb.AttributeValueDecoder;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.exceptions.DecoderException;

public final class DaxResponseDecoder {
    private static final Constants.DaxResponseParam[] RESPONSE_PARAMS = Constants.DaxResponseParam.values();

    private DaxResponseDecoder() {
    }

    public static CompletableFuture<Map<Constants.DaxResponseParam, Object>> decodeResponse(DaxCborInputStream input, List<AttributeDefinition> keys, SimpleCache<Long, List<String>> attrListIdCache, Map<Constants.DaxResponseParam, Object> response) throws IOException {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        CompletableFuture<Map<Constants.DaxResponseParam, Object>> responseFuture = new CompletableFuture<Map<Constants.DaxResponseParam, Object>>();
        if (input.tryReadNull()) {
            return CompletableFuture.completedFuture(response);
        }
        if (input.fieldType() == 191) {
            input.consumeField();
            CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
            block6: while (input.fieldType() != 255) {
                int key = input.readInt();
                switch (RESPONSE_PARAMS[key]) {
                    case Attributes: {
                        input.beginStream();
                        wrapper.init(input);
                        futures.add(AttributeValueDecoder.decodeStreamItem(wrapper, attrListIdCache, null).thenApply(item -> {
                            response.put(Constants.DaxResponseParam.Attributes, item);
                            return null;
                        }));
                        input.endStream();
                        continue block6;
                    }
                    case Item: {
                        input.beginStream();
                        wrapper.init(input);
                        futures.add(AttributeValueDecoder.decodeStreamItem(wrapper, attrListIdCache, null).thenApply(item -> {
                            response.put(Constants.DaxResponseParam.Item, item);
                            return null;
                        }));
                        input.endStream();
                        continue block6;
                    }
                    case ConsumedCapacity: {
                        response.put(Constants.DaxResponseParam.ConsumedCapacity, DaxResponseDecoder.decodeConsumedCapacity(input));
                        continue block6;
                    }
                    case ItemCollectionMetrics: {
                        response.put(Constants.DaxResponseParam.ItemCollectionMetrics, DaxResponseDecoder.decodeItemCollectionMetrics(input, keys));
                        continue block6;
                    }
                }
                throw new DecoderException("Unknown value type: " + key);
            }
            input.consumeField();
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).whenComplete((placeholder, e) -> {
            if (e != null) {
                responseFuture.completeExceptionally((Throwable)e);
            } else {
                responseFuture.complete(response);
            }
        });
        return responseFuture;
    }

    public static ConsumedCapacity decodeConsumedCapacity(DaxCborInputStream input) throws IOException {
        if (input.tryReadNull()) {
            return null;
        }
        input.readBytesLength();
        ConsumedCapacity.Builder consumedCapacity = ConsumedCapacity.builder();
        consumedCapacity.tableName((String)input.readObject());
        consumedCapacity.capacityUnits(Double.valueOf(input.readDouble()));
        if (input.fieldType() == 246) {
            input.consumeField();
        } else {
            Capacity.Builder table = Capacity.builder();
            table.capacityUnits(Double.valueOf(input.readDouble()));
            consumedCapacity.table((Capacity)table.build());
        }
        consumedCapacity.globalSecondaryIndexes(DaxResponseDecoder.decodeIndexConsumedCapacity(input));
        consumedCapacity.localSecondaryIndexes(DaxResponseDecoder.decodeIndexConsumedCapacity(input));
        return (ConsumedCapacity)consumedCapacity.build();
    }

    public static ConsumedCapacity decodeConsumedCapacityExtended(DaxCborInputStream input) throws IOException {
        if (input.tryReadNull()) {
            return null;
        }
        ConsumedCapacity.Builder consumedCapacity = ConsumedCapacity.builder();
        if (input.fieldType() == 191) {
            input.consumeField();
            block9: while (input.fieldType() != 255) {
                int key = input.readInt();
                switch (DynamoNumerals.ConsumedCapacity.fromInt(key)) {
                    case TableName: {
                        consumedCapacity.tableName((String)input.readObject());
                        continue block9;
                    }
                    case CapacityUnits: {
                        consumedCapacity.capacityUnits(Double.valueOf(input.readDouble()));
                        continue block9;
                    }
                    case ReadCapacityUnits: {
                        consumedCapacity.readCapacityUnits(Double.valueOf(input.readDouble()));
                        continue block9;
                    }
                    case WriteCapacityUnits: {
                        consumedCapacity.writeCapacityUnits(Double.valueOf(input.readDouble()));
                        continue block9;
                    }
                    case Table: {
                        consumedCapacity.table(DaxResponseDecoder.decodeCapacity(input));
                        continue block9;
                    }
                    case LocalSecondaryIndexes: {
                        consumedCapacity.localSecondaryIndexes(DaxResponseDecoder.decodeIndexConsumedCapacity(input, true));
                        continue block9;
                    }
                    case GlobalSecondaryIndexes: {
                        consumedCapacity.globalSecondaryIndexes(DaxResponseDecoder.decodeIndexConsumedCapacity(input, true));
                        continue block9;
                    }
                }
                throw new DecoderException("Unknown object type " + key);
            }
            input.consumeField();
            return (ConsumedCapacity)consumedCapacity.build();
        }
        return null;
    }

    private static Capacity decodeCapacity(DaxCborInputStream input) throws IOException {
        Map capacityMap = (Map)input.readObject();
        Capacity.Builder capacity = null;
        if (capacityMap != null) {
            capacity = Capacity.builder().capacityUnits((Double)capacityMap.get(DynamoNumerals.ConsumedCapacity.CapacityUnits.mCode)).readCapacityUnits((Double)capacityMap.get(DynamoNumerals.ConsumedCapacity.ReadCapacityUnits.mCode)).writeCapacityUnits((Double)capacityMap.get(DynamoNumerals.ConsumedCapacity.WriteCapacityUnits.mCode));
            return (Capacity)capacity.build();
        }
        return null;
    }

    public static ItemCollectionMetrics decodeItemCollectionMetrics(DaxCborInputStream input, List<AttributeDefinition> keys) throws IOException {
        if (input.tryReadNull()) {
            return null;
        }
        input.readBytesLength();
        ItemCollectionMetrics.Builder itemCollectionMetrics = ItemCollectionMetrics.builder();
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        AttributeValueDecoder.decodeNamedItem(input, keys, item);
        itemCollectionMetrics.itemCollectionKey(item);
        ArrayList<Double> sizeRange = new ArrayList<Double>(2);
        sizeRange.add(input.readDouble());
        sizeRange.add(input.readDouble());
        itemCollectionMetrics.sizeEstimateRangeGB(sizeRange);
        return (ItemCollectionMetrics)itemCollectionMetrics.build();
    }

    public static ConsumedCapacity newZeroConsumedCapacity(String tableName) {
        return (ConsumedCapacity)ConsumedCapacity.builder().tableName(tableName).capacityUnits(Double.valueOf(0.0)).build();
    }

    private static Map<String, Capacity> decodeIndexConsumedCapacity(DaxCborInputStream input) throws IOException {
        return DaxResponseDecoder.decodeIndexConsumedCapacity(input, false);
    }

    private static Map<String, Capacity> decodeIndexConsumedCapacity(DaxCborInputStream input, boolean extended) throws IOException {
        int fieldType = input.fieldType();
        if (input.tryReadNull()) {
            return null;
        }
        if ((fieldType & 0xE0) == 160) {
            HashMap<String, Capacity> index = new HashMap<String, Capacity>();
            int size = input.readMapLength();
            for (int i = 0; i < size; ++i) {
                String indexName = (String)input.readObject();
                Capacity capacity = extended ? DaxResponseDecoder.decodeCapacity(input) : (Capacity)Capacity.builder().capacityUnits(Double.valueOf(input.readDouble())).build();
                index.put(indexName, capacity);
            }
            return index;
        }
        throw new DecoderException("Unknown object type: " + fieldType);
    }

    public static List<ConsumedCapacity> verifyBatchConsumedCapacity(List<ConsumedCapacity> consumedCapacityByTable, Set<String> tables) {
        HashSet<String> tablesWithConsumedCapacity = new HashSet<String>();
        if (consumedCapacityByTable == null) {
            consumedCapacityByTable = new ArrayList<ConsumedCapacity>();
        }
        for (ConsumedCapacity capacity : consumedCapacityByTable) {
            if (capacity == null) continue;
            tablesWithConsumedCapacity.add(capacity.tableName());
        }
        for (String table : tables) {
            if (tablesWithConsumedCapacity.contains(table)) continue;
            ConsumedCapacity consumedCapacity = (ConsumedCapacity)ConsumedCapacity.builder().tableName(table).capacityUnits(Double.valueOf(0.0)).build();
            consumedCapacityByTable.add(consumedCapacity);
        }
        return consumedCapacityByTable;
    }
}

