/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.dax.channel.ResponseHandler;
import software.amazon.dax.com.amazon.cbor.CborInputStream;
import software.amazon.dax.com.amazon.cbor.NonInputStream;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.dynamodb.AttributeValueDecoder;
import software.amazon.dax.dynamodb.DaxResponseDecoder;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.exceptions.DecoderException;

public class BatchGetItemResponseHandler
extends ResponseHandler<BatchGetItemResponse> {
    private final SimpleCache<Long, List<String>> attrListCache;
    private final AtomicReference<Map<String, Map<Integer, DocumentPath>>> tableProjOrdinals;
    private final AtomicReference<Map<String, List<AttributeDefinition>>> keysPerTable;
    private final BatchGetItemRequest request;

    public BatchGetItemResponseHandler(CompletableFuture<BatchGetItemResponse> completableFuture, SimpleCache<Long, List<String>> attrListCache, AtomicReference<Map<String, Map<Integer, DocumentPath>>> tableProjOrdinals, AtomicReference<Map<String, List<AttributeDefinition>>> keysPerTable, BatchGetItemRequest request) {
        super(completableFuture);
        this.attrListCache = attrListCache;
        this.tableProjOrdinals = tableProjOrdinals;
        this.keysPerTable = keysPerTable;
        this.request = request;
    }

    @Override
    public void decode(DaxCborInputStream in, CompletableFuture<BatchGetItemResponse> completableFuture) throws Exception {
        int arrayLen = in.readArrayLength();
        if (arrayLen != 2) {
            throw new UnsupportedEncodingException("BatchGetResponse needs to have two elements, instead had: " + arrayLen);
        }
        int responseMapLen = in.readMapLength();
        HashMap<String, List<Map<String, AttributeValue>>> responses = new HashMap<String, List<Map<String, AttributeValue>>>(responseMapLen);
        String[] tableNames = new String[responseMapLen];
        List[] attributeListIds = new List[responseMapLen];
        List[] anonymousItems = new List[responseMapLen];
        CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
        int anonIndex = 0;
        for (int i = 0; i < responseMapLen; ++i) {
            HashMap<String, AttributeValue> item;
            ArrayList<List<AttributeValue>> anonymousItem;
            int numItems;
            ArrayList<Long> attrListIds;
            String tableName = (String)in.readObject();
            Map<Integer, DocumentPath> projOrdinals = this.tableProjOrdinals.get().get(tableName);
            ArrayList<Map<String, AttributeValue>> tableItems = new ArrayList<Map<String, AttributeValue>>();
            responses.put(tableName, tableItems);
            tableNames[anonIndex] = tableName;
            attributeListIds[anonIndex] = attrListIds = new ArrayList<Long>(numItems);
            anonymousItems[anonIndex] = anonymousItem = new ArrayList<List<AttributeValue>>(numItems);
            if (projOrdinals != null) {
                block6: for (numItems = in.readArrayLength(); numItems > 0; --numItems) {
                    int type = in.fieldType() & 0xE0;
                    switch (type) {
                        case 160: {
                            tableItems.add(AttributeValueDecoder.decodeProjection(in, projOrdinals, null));
                            attrListIds.add(-1L);
                            anonymousItem.add(null);
                            continue block6;
                        }
                        case 64: {
                            item = new HashMap<String, AttributeValue>();
                            tableItems.add(item);
                            in.beginStream();
                            wrapper.init(in);
                            attrListIds.add(wrapper.readLong());
                            anonymousItem.add(AttributeValueDecoder.decodeAnonymousStreamedItem(wrapper, new ArrayList<AttributeValue>()));
                            in.endStream();
                            continue block6;
                        }
                        case 224: {
                            if (in.fieldType() == 246) {
                                in.consumeField();
                                continue block6;
                            }
                        }
                        default: {
                            throw new DecoderException("Value must be map or array, given cbor type: " + type);
                        }
                    }
                }
            } else {
                List<AttributeDefinition> tableKeys = this.keysPerTable.get().get(tableName);
                while (numItems > 0) {
                    item = new HashMap();
                    tableItems.add(item);
                    AttributeValueDecoder.decodeKey(in, tableKeys, item);
                    in.beginStream();
                    wrapper.init(in);
                    attrListIds.add(wrapper.readLong());
                    anonymousItem.add(AttributeValueDecoder.decodeAnonymousStreamedItem(wrapper, new ArrayList<AttributeValue>()));
                    in.endStream();
                    numItems -= 2;
                }
            }
            ++anonIndex;
        }
        this.deanonymizeAndBuildResponse(in, tableNames, responses, anonymousItems, attributeListIds, anonIndex, completableFuture);
    }

    private void deanonymizeAndBuildResponse(DaxCborInputStream in, String[] tableNames, Map<String, List<Map<String, AttributeValue>>> responses, List<List<AttributeValue>>[] anonymousItems, List<Long>[] attributeListIds, int anonIndex, CompletableFuture<BatchGetItemResponse> completableFuture) throws IOException {
        List<Map<String, AttributeValue>> tableItems;
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        int unprocessedKeysMapLen = in.readMapLength();
        HashMap<String, KeysAndAttributes> unprocessedKeys = null;
        Map requestByTable = this.request.requestItems();
        if (unprocessedKeysMapLen > 0) {
            unprocessedKeys = new HashMap<String, KeysAndAttributes>(unprocessedKeysMapLen);
            while (unprocessedKeysMapLen-- > 0) {
                String tableName = (String)in.readObject();
                int keyCount = in.readArrayLength();
                if (keyCount == 0) continue;
                List<AttributeDefinition> tableKeys = this.keysPerTable.get().get(tableName);
                tableItems = new ArrayList<Map<String, AttributeValue>>(keyCount);
                while (keyCount-- > 0) {
                    HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
                    AttributeValueDecoder.decodeKey(in, tableKeys, item);
                    tableItems.add(item);
                }
                KeysAndAttributes kaasIn = (KeysAndAttributes)requestByTable.get(tableName);
                KeysAndAttributes.Builder kaasOut = KeysAndAttributes.builder().keys(tableItems).projectionExpression(kaasIn.projectionExpression()).consistentRead(kaasIn.consistentRead());
                kaasOut = kaasIn.hasAttributesToGet() ? kaasOut.attributesToGet((Collection)kaasIn.attributesToGet()) : kaasOut;
                kaasOut = kaasIn.hasExpressionAttributeNames() ? kaasOut.expressionAttributeNames(kaasIn.expressionAttributeNames()) : kaasOut;
                unprocessedKeys.put(tableName, (KeysAndAttributes)kaasOut.build());
            }
        }
        int consumedCapacityArrayLen = in.readArrayLength();
        ArrayList<ConsumedCapacity> consumedCapacities = null;
        if (consumedCapacityArrayLen > 0) {
            consumedCapacities = new ArrayList<ConsumedCapacity>(consumedCapacityArrayLen);
            while (consumedCapacityArrayLen-- > 0) {
                consumedCapacities.add(DaxResponseDecoder.decodeConsumedCapacity(in));
            }
        }
        for (int t = 0; t < anonIndex; ++t) {
            tableItems = responses.get(tableNames[t]);
            List<Long> attrListIds = attributeListIds[t];
            List<List<AttributeValue>> anonymousItem = anonymousItems[t];
            for (int i = 0; i < tableItems.size(); ++i) {
                List<AttributeValue> anonValues = anonymousItem.get(i);
                long attrListId = attrListIds.get(i);
                Map<String, AttributeValue> singleTableItem = tableItems.get(i);
                if (anonValues == null) continue;
                futures.add(this.attrListCache.get(attrListId).thenApply(attrNames -> {
                    try {
                        AttributeValueDecoder.deanonymizeAttributeValues(singleTableItem, attrNames, anonValues);
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                    return null;
                }));
            }
        }
        BatchGetItemResponse.Builder response = BatchGetItemResponse.builder().consumedCapacity(consumedCapacities).unprocessedKeys(unprocessedKeys);
        if (DynamoNumerals.ReturnConsumedCapacity.fromName(this.request.returnConsumedCapacityAsString()) != DynamoNumerals.ReturnConsumedCapacity.NONE) {
            response.consumedCapacity(DaxResponseDecoder.verifyBatchConsumedCapacity(consumedCapacities, requestByTable.keySet()));
        }
        CompletableFuture[] futuresArray = futures.toArray(new CompletableFuture[0]);
        CompletableFuture.allOf(futuresArray).whenComplete((placeholder, ex) -> {
            if (ex != null) {
                completableFuture.completeExceptionally((Throwable)ex);
            } else {
                completableFuture.complete((BatchGetItemResponse)response.responses(responses).build());
            }
        });
    }
}

