/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import software.amazon.dax.channel.ChannelAttributeKey;

@ChannelHandler.Sharable
public final class UnusedChannelExceptionHandler
extends ChannelInboundHandlerAdapter {
    private static final UnusedChannelExceptionHandler INSTANCE = new UnusedChannelExceptionHandler();

    private UnusedChannelExceptionHandler() {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        boolean channelInUse = (Boolean)ctx.channel().attr(ChannelAttributeKey.IN_USE).get();
        if (channelInUse) {
            ctx.fireExceptionCaught(cause);
        } else {
            ctx.channel().close();
        }
    }

    public static UnusedChannelExceptionHandler getInstance() {
        return INSTANCE;
    }
}

