/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax;

import java.io.InputStream;
import java.util.Properties;

public class InternalConfiguration {
    private static final String USER_AGENT_PREFIX = "DaxJavaV2Client-";
    private static final String CLIENT_VERSION_UNKNOWN = "unknown";
    public static final String USER_AGENT = "DaxJavaV2Client-" + InternalConfiguration.readClientVersion();
    private boolean needAuth = true;
    private boolean needFrame = true;
    private boolean needInit = true;
    private boolean needStatusCode = true;
    private boolean needCertValidation = true;
    private String dns;

    public InternalConfiguration() {
    }

    public InternalConfiguration(InternalConfiguration other) {
        this.needAuth(other.needAuth);
        this.needFrame(other.needFrame);
        this.needInit(other.needInit);
        this.needStatusCode(other.needStatusCode);
        this.needCertValidation(other.needCertValidation);
        this.dns(other.dns);
    }

    public boolean needAuth() {
        return this.needAuth;
    }

    public boolean needFrame() {
        return this.needFrame;
    }

    public boolean needInit() {
        return this.needInit;
    }

    public boolean needStatusCode() {
        return this.needStatusCode;
    }

    public boolean needCertValidation() {
        return this.needCertValidation;
    }

    public String userAgent() {
        return USER_AGENT;
    }

    public String dns() {
        return this.dns;
    }

    public InternalConfiguration needAuth(boolean needAuth) {
        this.needAuth = needAuth;
        return this;
    }

    public InternalConfiguration needFrame(boolean needFrame) {
        this.needFrame = needFrame;
        return this;
    }

    public InternalConfiguration needInit(boolean needInit) {
        this.needInit = needInit;
        return this;
    }

    public InternalConfiguration needStatusCode(boolean needStatusCode) {
        this.needStatusCode = needStatusCode;
        return this;
    }

    public InternalConfiguration needCertValidation(boolean needCertValidation) {
        this.needCertValidation = needCertValidation;
        return this;
    }

    public InternalConfiguration dns(String dns) {
        this.dns = dns;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readClientVersion() {
        try (InputStream in = InternalConfiguration.class.getResourceAsStream("client.properties");){
            Properties props = new Properties();
            props.load(in);
            String version = props.getProperty("version");
            if (version == null) return CLIENT_VERSION_UNKNOWN;
            String string = version;
            return string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return CLIENT_VERSION_UNKNOWN;
    }
}

