/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.dax.channel.ResponseHandler;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.com.amazon.dax.bits.disco.ServiceEndpoint;

public class EndpointsResponseHandler
extends ResponseHandler<List<ServiceEndpoint>> {
    public EndpointsResponseHandler(CompletableFuture<List<ServiceEndpoint>> completableFuture) {
        super(completableFuture);
    }

    @Override
    public void decode(DaxCborInputStream in, CompletableFuture<List<ServiceEndpoint>> completableFuture) throws IOException {
        int count = in.readArrayLength();
        if (count <= 0) {
            completableFuture.complete(Collections.emptyList());
            return;
        }
        ArrayList<ServiceEndpoint> eps = new ArrayList<ServiceEndpoint>(count);
        while (count-- > 0) {
            ServiceEndpoint se = ServiceEndpoint.readFrom(in);
            eps.add(se);
        }
        completableFuture.complete(eps);
    }
}

