/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteId;

public class InitializeEncryptionMaterialsInput {
    private final AlgorithmSuiteId algorithmSuiteId;
    private final Map<String, String> encryptionContext;
    private final List<String> requiredEncryptionContextKeys;
    private final ByteBuffer signingKey;
    private final ByteBuffer verificationKey;

    protected InitializeEncryptionMaterialsInput(BuilderImpl builder) {
        this.algorithmSuiteId = builder.algorithmSuiteId();
        this.encryptionContext = builder.encryptionContext();
        this.requiredEncryptionContextKeys = builder.requiredEncryptionContextKeys();
        this.signingKey = builder.signingKey();
        this.verificationKey = builder.verificationKey();
    }

    public AlgorithmSuiteId algorithmSuiteId() {
        return this.algorithmSuiteId;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public List<String> requiredEncryptionContextKeys() {
        return this.requiredEncryptionContextKeys;
    }

    public ByteBuffer signingKey() {
        return this.signingKey;
    }

    public ByteBuffer verificationKey() {
        return this.verificationKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected AlgorithmSuiteId algorithmSuiteId;
        protected Map<String, String> encryptionContext;
        protected List<String> requiredEncryptionContextKeys;
        protected ByteBuffer signingKey;
        protected ByteBuffer verificationKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(InitializeEncryptionMaterialsInput model) {
            this.algorithmSuiteId = model.algorithmSuiteId();
            this.encryptionContext = model.encryptionContext();
            this.requiredEncryptionContextKeys = model.requiredEncryptionContextKeys();
            this.signingKey = model.signingKey();
            this.verificationKey = model.verificationKey();
        }

        @Override
        public Builder algorithmSuiteId(AlgorithmSuiteId algorithmSuiteId) {
            this.algorithmSuiteId = algorithmSuiteId;
            return this;
        }

        @Override
        public AlgorithmSuiteId algorithmSuiteId() {
            return this.algorithmSuiteId;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public Builder requiredEncryptionContextKeys(List<String> requiredEncryptionContextKeys) {
            this.requiredEncryptionContextKeys = requiredEncryptionContextKeys;
            return this;
        }

        @Override
        public List<String> requiredEncryptionContextKeys() {
            return this.requiredEncryptionContextKeys;
        }

        @Override
        public Builder signingKey(ByteBuffer signingKey) {
            this.signingKey = signingKey;
            return this;
        }

        @Override
        public ByteBuffer signingKey() {
            return this.signingKey;
        }

        @Override
        public Builder verificationKey(ByteBuffer verificationKey) {
            this.verificationKey = verificationKey;
            return this;
        }

        @Override
        public ByteBuffer verificationKey() {
            return this.verificationKey;
        }

        @Override
        public InitializeEncryptionMaterialsInput build() {
            if (Objects.isNull(this.algorithmSuiteId())) {
                throw new IllegalArgumentException("Missing value for required field `algorithmSuiteId`");
            }
            if (Objects.isNull(this.encryptionContext())) {
                throw new IllegalArgumentException("Missing value for required field `encryptionContext`");
            }
            if (Objects.isNull(this.requiredEncryptionContextKeys())) {
                throw new IllegalArgumentException("Missing value for required field `requiredEncryptionContextKeys`");
            }
            return new InitializeEncryptionMaterialsInput(this);
        }
    }

    public static interface Builder {
        public Builder algorithmSuiteId(AlgorithmSuiteId var1);

        public AlgorithmSuiteId algorithmSuiteId();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public Builder requiredEncryptionContextKeys(List<String> var1);

        public List<String> requiredEncryptionContextKeys();

        public Builder signingKey(ByteBuffer var1);

        public ByteBuffer signingKey();

        public Builder verificationKey(ByteBuffer var1);

        public ByteBuffer verificationKey();

        public InitializeEncryptionMaterialsInput build();
    }
}

