/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.internaldafny;

import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsArn;
import AwsCryptographyKeyStoreOperations_Compile.Config;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.keystore.internaldafny.KeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient;
import software.amazon.cryptography.services.dynamodb.internaldafny.types._Companion_IDynamoDBClient;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.__default;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types._Companion_IKMSClient;

public abstract class _ExternBase___default {
    public static KeyStoreConfig DefaultKeyStoreConfig() {
        return KeyStoreConfig.create((DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), KMSConfiguration.create_kmsKeyArn((DafnySequence<? extends Character>)DafnySequence.asString((String)"arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab")), (DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), Option.create_None(), Option.create_None(), Option.create_None(), Option.create_None());
    }

    public static Result<KeyStoreClient, Error> KeyStore(KeyStoreConfig config) {
        Result<KeyStoreClient, Error> res = null;
        IKMSClient _333_kmsClient = null;
        IDynamoDBClient _334_ddbClient = null;
        Option<Object> _335_inferredRegion = Option.create_None();
        if (KMSKeystoreOperations_Compile.__default.HasKeyId(config.dtor_kmsConfiguration())) {
            Result<AwsArn, Error> _337_valueOrError0 = null;
            _337_valueOrError0 = KmsArn_Compile.__default.IsValidKeyArn(KMSKeystoreOperations_Compile.__default.GetKeyId(config.dtor_kmsConfiguration()));
            if (_337_valueOrError0.IsFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor())) {
                res = _337_valueOrError0.PropagateFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            AwsArn _336_parsedArn = _337_valueOrError0.Extract(AwsKmsArn._typeDescriptor(), Error._typeDescriptor());
            _335_inferredRegion = Option.create_Some(_336_parsedArn.dtor_region());
        } else if (config.dtor_kmsConfiguration().is_mrDiscovery()) {
            _335_inferredRegion = Option.create_Some(config.dtor_kmsConfiguration().dtor_mrDiscovery().dtor_region());
        }
        Result<DafnySequence<? extends DafnySequence<? extends Character>>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _338_grantTokens = AwsKmsUtils_Compile.__default.GetValidGrantTokens(config.dtor_grantTokens());
        Outcome<Object> _339_valueOrError1 = Outcome.Default();
        _339_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _338_grantTokens.is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Grant Tokens passed to Key Store configuration are invalid.")));
        if (_339_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _339_valueOrError1.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        DafnySequence _340_keyStoreId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        if (config.dtor_id().is_Some()) {
            _340_keyStoreId = config.dtor_id().dtor_value();
        } else {
            DafnySequence _342_uuid;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _out45;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _341_maybeUuid = _out45 = UUID.__default.GenerateUUID();
            Result<Object, Object> _343_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _343_valueOrError2 = _341_maybeUuid.MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _344_e_boxed0 -> {
                DafnySequence _344_e = _344_e_boxed0;
                return Error.create_KeyStoreException((DafnySequence<? extends Character>)_344_e);
            });
            if (_343_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _343_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _340_keyStoreId = _342_uuid = (DafnySequence)_343_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        }
        if (config.dtor_kmsClient().is_Some()) {
            _333_kmsClient = config.dtor_kmsClient().dtor_value();
        } else if (config.dtor_kmsClient().is_None() && _335_inferredRegion.is_Some()) {
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out46;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _345_maybeKmsClient = _out46 = software.amazon.cryptography.services.kms.internaldafny.__default.KMSClientForRegion((DafnySequence<? extends Character>)((DafnySequence)_335_inferredRegion.dtor_value()));
            Result<IKMSClient, Error> _346_valueOrError3 = null;
            _346_valueOrError3 = _345_maybeKmsClient.MapFailure(_Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _347_e_boxed0 -> {
                software.amazon.cryptography.services.kms.internaldafny.types.Error _347_e = _347_e_boxed0;
                return Error.create_ComAmazonawsKms(_347_e);
            });
            if (_346_valueOrError3.IsFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _346_valueOrError3.PropagateFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _333_kmsClient = _346_valueOrError3.Extract(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out47;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _348_maybeKmsClient = _out47 = software.amazon.cryptography.services.kms.internaldafny.__default.KMSClient();
            Result<IKMSClient, Error> _349_valueOrError4 = null;
            _349_valueOrError4 = _348_maybeKmsClient.MapFailure(_Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _350_e_boxed0 -> {
                software.amazon.cryptography.services.kms.internaldafny.types.Error _350_e = _350_e_boxed0;
                return Error.create_ComAmazonawsKms(_350_e);
            });
            if (_349_valueOrError4.IsFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _349_valueOrError4.PropagateFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _333_kmsClient = _349_valueOrError4.Extract(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor());
        }
        if (config.dtor_ddbClient().is_Some()) {
            _334_ddbClient = config.dtor_ddbClient().dtor_value();
        } else if (config.dtor_ddbClient().is_None() && _335_inferredRegion.is_Some()) {
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _out48;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _351_maybeDdbClient = _out48 = software.amazon.cryptography.services.dynamodb.internaldafny.__default.DDBClientForRegion((DafnySequence<? extends Character>)((DafnySequence)_335_inferredRegion.dtor_value()));
            Result<IDynamoDBClient, Error> _352_valueOrError5 = null;
            _352_valueOrError5 = _351_maybeDdbClient.MapFailure(_Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _353_e_boxed0 -> {
                software.amazon.cryptography.services.dynamodb.internaldafny.types.Error _353_e = _353_e_boxed0;
                return Error.create_ComAmazonawsDynamodb(_353_e);
            });
            if (_352_valueOrError5.IsFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _352_valueOrError5.PropagateFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _334_ddbClient = _352_valueOrError5.Extract(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _out49;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _354_maybeDdbClient = _out49 = software.amazon.cryptography.services.dynamodb.internaldafny.__default.DynamoDBClient();
            Result<IDynamoDBClient, Error> _355_valueOrError6 = null;
            _355_valueOrError6 = _354_maybeDdbClient.MapFailure(_Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _356_e_boxed0 -> {
                software.amazon.cryptography.services.dynamodb.internaldafny.types.Error _356_e = _356_e_boxed0;
                return Error.create_ComAmazonawsDynamodb(_356_e);
            });
            if (_355_valueOrError6.IsFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _355_valueOrError6.PropagateFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _334_ddbClient = _355_valueOrError6.Extract(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor());
        }
        Outcome<Object> _357_valueOrError7 = Outcome.Default();
        _357_valueOrError7 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.IsValid__TableName(config.dtor_ddbTableName()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Amazon DynamoDB Table Name")));
        if (_357_valueOrError7.IsFailure(Error._typeDescriptor())) {
            res = _357_valueOrError7.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        KeyStoreClient _nw0 = new KeyStoreClient();
        _nw0.__ctor(Config.create((DafnySequence<? extends Character>)_340_keyStoreId, config.dtor_ddbTableName(), config.dtor_logicalKeyStoreName(), config.dtor_kmsConfiguration(), _338_grantTokens.dtor_value(), _333_kmsClient, _334_ddbClient));
        KeyStoreClient _358_client = _nw0;
        res = Result.create_Success(_358_client);
        return res;
    }

    public static Result<IKeyStoreClient, Error> CreateSuccessOfClient(IKeyStoreClient client) {
        return Result.create_Success(client);
    }

    public static Result<IKeyStoreClient, Error> CreateFailureOfError(Error error) {
        return Result.create_Failure(error);
    }

    public String toString() {
        return "KeyStore._default";
    }
}

