/*
 * Decompiled with CFR 0.152.
 */
package KdfCtr_Compile;

import BoundedInts_Compile.uint8;
import HMAC.HMac;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyEuclidean;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.KdfCtrInput;

public class __default {
    public static Result<DafnySequence<? extends Byte>, Error> KdfCounterMode(KdfCtrInput input) {
        Result<DafnySequence<? extends Byte>, Error> output = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _71_valueOrError0 = Outcome.Default();
        _71_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !(!Objects.equals(input.dtor_digestAlgorithm(), DigestAlgorithm.create_SHA__256()) && !Objects.equals(input.dtor_digestAlgorithm(), DigestAlgorithm.create_SHA__384()) || !Objects.equals(BigInteger.valueOf(input.dtor_ikm().length()), BigInteger.valueOf(32L)) && !Objects.equals(BigInteger.valueOf(input.dtor_ikm().length()), BigInteger.valueOf(48L)) && !Objects.equals(BigInteger.valueOf(input.dtor_ikm().length()), BigInteger.valueOf(66L)) || !input.dtor_nonce().is_Some() || !Objects.equals(BigInteger.valueOf(input.dtor_nonce().dtor_value().length()), BigInteger.valueOf(16L)) && !Objects.equals(BigInteger.valueOf(input.dtor_nonce().dtor_value().length()), BigInteger.valueOf(32L)) || input.dtor_expectedLength() != 32 && input.dtor_expectedLength() != 64 || BigInteger.valueOf(input.dtor_expectedLength()).multiply(BigInteger.valueOf(8L)).signum() != 1 || BigInteger.valueOf(input.dtor_expectedLength()).multiply(BigInteger.valueOf(8L)).compareTo(StandardLibrary_mUInt_Compile.__default.INT32__MAX__LIMIT()) >= 0), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Kdf in Counter Mode input is invalid.")));
        if (_71_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _71_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        DafnySequence<? extends Byte> _72_ikm = input.dtor_ikm();
        DafnySequence<? extends Byte> _73_label__ = input.dtor_purpose().UnwrapOr((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
        DafnySequence<? extends Byte> _74_info = input.dtor_nonce().UnwrapOr((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
        DafnySequence _75_okm = DafnySequence.empty(uint8._typeDescriptor());
        int _76_internalLength = BigInteger.valueOf(4L).add(BigInteger.valueOf(__default.SEPARATION__INDICATOR().length())).add(BigInteger.valueOf(4L)).intValue();
        Outcome<Object> _77_valueOrError1 = Outcome.Default();
        _77_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(Integer.toUnsignedLong(_76_internalLength)).add(BigInteger.valueOf(_73_label__.length())).add(BigInteger.valueOf(_74_info.length())).compareTo(StandardLibrary_mUInt_Compile.__default.INT32__MAX__LIMIT()) < 0, Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Input Length exceeds INT32_MAX_LIMIT")));
        if (_77_valueOrError1.IsFailure(Error._typeDescriptor())) {
            output = _77_valueOrError1.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        DafnySequence<? extends Byte> _78_lengthBits = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(input.dtor_expectedLength() * 8);
        DafnySequence _79_explicitInfo = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_73_label__, __default.SEPARATION__INDICATOR()), _74_info), _78_lengthBits);
        Outcome<Object> _80_valueOrError2 = Outcome.Default();
        _80_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(4L).add(BigInteger.valueOf(_79_explicitInfo.length())).compareTo(StandardLibrary_mUInt_Compile.__default.INT32__MAX__LIMIT()) < 0, Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"PRF input length exceeds INT32_MAX_LIMIT.")));
        if (_80_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _80_valueOrError2.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        Result<Object, Object> _81_valueOrError3 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out15 = __default.RawDerive(_72_ikm, (DafnySequence<? extends Byte>)_79_explicitInfo, input.dtor_expectedLength(), 0, input.dtor_digestAlgorithm());
        _81_valueOrError3 = _out15;
        if (_81_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            output = _81_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        _75_okm = (DafnySequence)_81_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        output = Result.create_Success(_75_okm);
        return output;
    }

    public static Result<DafnySequence<? extends Byte>, Error> RawDerive(DafnySequence<? extends Byte> ikm, DafnySequence<? extends Byte> explicitInfo, int length, int offset, DigestAlgorithm digestAlgorithm) {
        Result<DafnySequence<? extends Byte>, Error> output = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<HMac, Error> _83_valueOrError0 = null;
        Result<HMac, Error> _out16 = HMac.Build(digestAlgorithm);
        _83_valueOrError0 = _out16;
        if (_83_valueOrError0.IsFailure(HMac._typeDescriptor(), Error._typeDescriptor())) {
            output = _83_valueOrError0.PropagateFailure(HMac._typeDescriptor(), Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        HMac _82_hmac = _83_valueOrError0.Extract(HMac._typeDescriptor(), Error._typeDescriptor());
        _82_hmac.Init(ikm);
        int _84_macLengthBytes = Digest_Compile.__default.Length(digestAlgorithm).intValue();
        int _85_iterations = DafnyEuclidean.EuclideanDivision((int)(length + _84_macLengthBytes - 1), (int)_84_macLengthBytes);
        DafnySequence _86_buffer = DafnySequence.empty(uint8._typeDescriptor());
        DafnySequence _87_i = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(__default.COUNTER__START__VALUE());
        int _hi0 = _85_iterations + 1;
        for (int _88_iteration = 1; _88_iteration < _hi0; ++_88_iteration) {
            DafnySequence<? extends Byte> _out17;
            _82_hmac.BlockUpdate(_87_i);
            _82_hmac.BlockUpdate(explicitInfo);
            DafnySequence<? extends Byte> _89_tmp = _out17 = _82_hmac.GetResult();
            _86_buffer = DafnySequence.concatenate((DafnySequence)_86_buffer, _89_tmp);
            Result<Object, Object> _90_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
            _90_valueOrError1 = __default.Increment(_87_i);
            if (_90_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
                output = _90_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
                return output;
            }
            _87_i = (DafnySequence)_90_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        }
        Outcome<Object> _91_valueOrError2 = Outcome.Default();
        _91_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_86_buffer.length()).compareTo(BigInteger.valueOf(length)) >= 0, Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Failed to derive key of requested length")));
        if (_91_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _91_valueOrError2.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        output = Result.create_Success(_86_buffer.take(length));
        return output;
    }

    public static Result<DafnySequence<? extends Byte>, Error> Increment(DafnySequence<? extends Byte> x) {
        if (Integer.compareUnsigned(((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L)))).byteValue(), -1) < 0) {
            return Result.create_Success(DafnySequence.of((byte[])new byte[]{(Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), (Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ONE)), (Byte)x.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L))), (byte)((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L))) + 1)}));
        }
        if (Integer.compareUnsigned(((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))).byteValue(), -1) < 0) {
            return Result.create_Success(DafnySequence.of((byte[])new byte[]{(Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), (Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ONE)), (byte)((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L))) + 1), 0}));
        }
        if (Integer.compareUnsigned(((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ONE))).byteValue(), -1) < 0) {
            return Result.create_Success(DafnySequence.of((byte[])new byte[]{(Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), (byte)((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ONE)) + 1), 0, 0}));
        }
        if (Integer.compareUnsigned(((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).byteValue(), -1) < 0) {
            return Result.create_Success(DafnySequence.of((byte[])new byte[]{(byte)((Byte)x.select(Helpers.toInt((BigInteger)BigInteger.ZERO)) + 1), 0, 0, 0}));
        }
        return Result.create_Failure(Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to derive key material; may have exceeded limit.")));
    }

    public static DafnySequence<? extends Byte> SEPARATION__INDICATOR() {
        return DafnySequence.of((byte[])new byte[]{0});
    }

    public static int COUNTER__START__VALUE() {
        return 1;
    }

    public String toString() {
        return "KdfCtr._default";
    }
}

