/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;

public class RSAPublicKey {
    public int _lengthBits;
    public DafnySequence<? extends Byte> _pem;
    private static final RSAPublicKey theDefault = RSAPublicKey.create(0, (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
    private static final TypeDescriptor<RSAPublicKey> _TYPE = TypeDescriptor.referenceWithInitializer(RSAPublicKey.class, () -> RSAPublicKey.Default());

    public RSAPublicKey(int lengthBits, DafnySequence<? extends Byte> pem) {
        this._lengthBits = lengthBits;
        this._pem = pem;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        RSAPublicKey o = (RSAPublicKey)other;
        return this._lengthBits == o._lengthBits && Objects.equals(this._pem, o._pem);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._lengthBits);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._pem);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyPrimitivesTypes.RSAPublicKey.RSAPublicKey");
        s.append("(");
        s.append(this._lengthBits);
        s.append(", ");
        s.append(Helpers.toString(this._pem));
        s.append(")");
        return s.toString();
    }

    public static RSAPublicKey Default() {
        return theDefault;
    }

    public static TypeDescriptor<RSAPublicKey> _typeDescriptor() {
        return _TYPE;
    }

    public static RSAPublicKey create(int lengthBits, DafnySequence<? extends Byte> pem) {
        return new RSAPublicKey(lengthBits, pem);
    }

    public static RSAPublicKey create_RSAPublicKey(int lengthBits, DafnySequence<? extends Byte> pem) {
        return RSAPublicKey.create(lengthBits, pem);
    }

    public boolean is_RSAPublicKey() {
        return true;
    }

    public int dtor_lengthBits() {
        return this._lengthBits;
    }

    public DafnySequence<? extends Byte> dtor_pem() {
        return this._pem;
    }
}

