/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsRsaKeyring_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsKmsRsaKeyring_Compile.DecryptSingleAWSRSAEncryptedDataKey;
import AwsKmsRsaKeyring_Compile.KmsRsaGenerateAndWrapKeyMaterial;
import AwsKmsRsaKeyring_Compile.KmsRsaWrapInfo;
import AwsKmsRsaKeyring_Compile.KmsRsaWrapKeyMaterial;
import AwsKmsRsaKeyring_Compile.__default;
import AwsKmsUtils_Compile.OnDecryptMrkAwareEncryptedDataKeyFilter;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsRsaKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public Option<IKMSClient> _client = Option.Default();
    public EncryptionAlgorithmSpec _paddingScheme = EncryptionAlgorithmSpec.Default();
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public Option<DafnySequence<? extends Byte>> _publicKey = Option.Default();
    public AwsKmsIdentifier _awsKmsArn = null;
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<AwsKmsRsaKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsRsaKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out184 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out184;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out185 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out185;
    }

    public void __ctor(Option<DafnySequence<? extends Byte>> publicKey, DafnySequence<? extends Character> awsKmsKey, EncryptionAlgorithmSpec paddingScheme, Option<IKMSClient> client, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _1086_parsedAwsKmsId = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(awsKmsKey);
        this._publicKey = publicKey;
        this._awsKmsKey = awsKmsKey;
        this._awsKmsArn = _1086_parsedAwsKmsId.dtor_value();
        this._paddingScheme = paddingScheme;
        this._client = client;
        this._cryptoPrimitives = cryptoPrimitives;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        Outcome<Object> _1087_valueOrError0 = Outcome.Default();
        _1087_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.publicKey().is_Some() && BigInteger.valueOf(this.publicKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())).length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A AwsKmsRsaKeyring without a public key cannot provide OnEncrypt")));
        if (_1087_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1087_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Object> _1088_valueOrError1 = Outcome.Default();
        _1088_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_algorithmSuite().dtor_signature().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"AwsKmsRsaKeyring cannot be used with an Algorithm Suite with asymmetric signing."), (DafnySequence)DafnySequence.asString((String)" Please specify an algorithm suite without asymmetric signing."))));
        if (_1088_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _1088_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        KmsRsaWrapKeyMaterial _nw39 = new KmsRsaWrapKeyMaterial();
        _nw39.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        KmsRsaWrapKeyMaterial _1089_wrap = _nw39;
        KmsRsaGenerateAndWrapKeyMaterial _nw40 = new KmsRsaGenerateAndWrapKeyMaterial();
        _nw40.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        KmsRsaGenerateAndWrapKeyMaterial _1090_generateAndWrap = _nw40;
        Result<WrapEdkMaterialOutput<KmsRsaWrapInfo>, Object> _1092_valueOrError2 = Result.Default(WrapEdkMaterialOutput.Default(KmsRsaWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<KmsRsaWrapInfo>, Error> _out186 = EdkWrapping_Compile.__default.WrapEdkMaterial(KmsRsaWrapInfo._typeDescriptor(), input.dtor_materials(), _1089_wrap, _1090_generateAndWrap);
        _1092_valueOrError2 = _out186;
        if (_1092_valueOrError2.IsFailure(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _1092_valueOrError2.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<KmsRsaWrapInfo> _1091_wrapOutput = _1092_valueOrError2.Extract(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _1093_symmetricSigningKeyList = _1091_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_1091_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _1094_edk = EncryptedDataKey.create(Constants_Compile.__default.RSA__PROVIDER__ID(), UTF8.__default.Encode(this.awsKmsKey()).dtor_value(), _1091_wrapOutput.dtor_wrappedMaterial());
        EncryptionMaterials _1095_returnMaterials = null;
        if (_1091_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1096_valueOrError3 = null;
            _1096_valueOrError3 = Materials_Compile.__default.EncryptionMaterialAddDataKey(input.dtor_materials(), _1091_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1094_edk}), _1093_symmetricSigningKeyList);
            if (_1096_valueOrError3.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _1096_valueOrError3.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _1095_returnMaterials = _1096_valueOrError3.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        } else if (_1091_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1097_valueOrError4 = null;
            _1097_valueOrError4 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(input.dtor_materials(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1094_edk}), _1093_symmetricSigningKeyList);
            if (_1097_valueOrError4.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _1097_valueOrError4.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _1095_returnMaterials = _1097_valueOrError4.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        }
        res = Result.create_Success(OnEncryptOutput.create(_1095_returnMaterials));
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out189;
        Result<OnDecryptOutput, Error> res = null;
        Outcome<Object> _1098_valueOrError0 = Outcome.Default();
        _1098_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.client().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"An AwsKmsRsaKeyring without an AWS KMS client cannot provide OnDecrypt")));
        if (_1098_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1098_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _1099_materials = input.dtor_materials();
        Outcome<Object> _1100_valueOrError1 = Outcome.Default();
        _1100_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_1099_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_1100_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _1100_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Object> _1101_valueOrError2 = Outcome.Default();
        _1101_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_algorithmSuite().dtor_signature().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"AwsKmsRsaKeyring cannot be used with an Algorithm Suite with asymmetric signing."), (DafnySequence)DafnySequence.asString((String)" Please specify an algorithm suite without asymmetric signing."))));
        if (_1101_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _1101_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        OnDecryptMrkAwareEncryptedDataKeyFilter _nw41 = new OnDecryptMrkAwareEncryptedDataKeyFilter();
        _nw41.__ctor(this.awsKmsArn(), Constants_Compile.__default.RSA__PROVIDER__ID());
        OnDecryptMrkAwareEncryptedDataKeyFilter _1102_filter = _nw41;
        Result<Object, Object> _1104_valueOrError3 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out187 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _1102_filter, input.dtor_encryptedDataKeys());
        _1104_valueOrError3 = _out187;
        if (_1104_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _1104_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _1103_edksToAttempt = (DafnySequence)_1104_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_1103_edksToAttempt.length()).signum() == 0) {
            Result<Object, Object> _1106_valueOrError4 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _1106_valueOrError4 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_1106_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _1106_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _1105_errorMessage = (DafnySequence)_1106_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_1105_errorMessage));
            return res;
        }
        Result<Object, Object> _1108_valueOrError5 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out188 = __default.EncryptionContextDigest(this.cryptoPrimitives(), _1099_materials.dtor_encryptionContext());
        _1108_valueOrError5 = _out188;
        if (_1108_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1108_valueOrError5.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _1107_encryptionContextDigest = (DafnySequence)_1108_valueOrError5.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        DecryptSingleAWSRSAEncryptedDataKey _nw42 = new DecryptSingleAWSRSAEncryptedDataKey();
        _nw42.__ctor(_1099_materials, this.client().dtor_value(), this.awsKmsKey(), this.paddingScheme(), (DafnySequence<? extends Byte>)_1107_encryptionContextDigest, this.grantTokens());
        DecryptSingleAWSRSAEncryptedDataKey _1109_decryptClosure = _nw42;
        Result<DecryptionMaterials, DafnySequence<Error>> _1110_outcome = _out189 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _1109_decryptClosure, _1103_edksToAttempt);
        Result<DecryptionMaterials, Error> _1112_valueOrError6 = null;
        _1112_valueOrError6 = _1110_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _1113_errors_boxed0 -> {
            DafnySequence _1113_errors = _1113_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_1113_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_1112_valueOrError6.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _1112_valueOrError6.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _1111_SealedDecryptionMaterials = _1112_valueOrError6.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_1111_SealedDecryptionMaterials));
        return res;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public Option<IKMSClient> client() {
        return this._client;
    }

    public EncryptionAlgorithmSpec paddingScheme() {
        return this._paddingScheme;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public Option<DafnySequence<? extends Byte>> publicKey() {
        return this._publicKey;
    }

    public AwsKmsIdentifier awsKmsArn() {
        return this._awsKmsArn;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<AwsKmsRsaKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsRsaKeyring.AwsKmsRsaKeyring";
    }
}

