/*
 * Decompiled with CFR 0.152.
 */
package AwsArnParsing_Compile;

import AwsArnParsing_Compile.AmazonDynamodbResource;
import AwsArnParsing_Compile.AmazonDynamodbTableArn;
import AwsArnParsing_Compile.AmazonDynamodbTableName;
import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsArn;
import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsArnParsing_Compile.AwsKmsIdentifier_AwsKmsArnIdentifier;
import AwsArnParsing_Compile.AwsKmsIdentifier_AwsKmsRawResourceIdentifier;
import AwsArnParsing_Compile.AwsKmsResource;
import AwsArnParsing_Compile.AwsResource;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.Tuple2;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.TableName;

public class __default {
    public static boolean ValidAwsKmsResource(AwsResource resource) {
        return resource.Valid() && (resource.dtor_resourceType().equals((Object)DafnySequence.asString((String)"key")) || resource.dtor_resourceType().equals((Object)DafnySequence.asString((String)"alias")));
    }

    public static boolean ValidAwsKmsArn(AwsArn arn) {
        return arn.Valid() && arn.dtor_service().equals((Object)DafnySequence.asString((String)"kms")) && __default.ValidAwsKmsResource(arn.dtor_resource());
    }

    public static Result<AwsResource, DafnySequence<? extends Character>> ParseAwsKmsRawResources(DafnySequence<? extends Character> identifier) {
        DafnySequence<DafnySequence<Character>> _0_info = StandardLibrary_Compile.__default.Split(TypeDescriptor.CHAR, identifier, Character.valueOf('/'));
        Outcome<DafnySequence> _1_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), !((DafnySequence)_0_info.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).equals((Object)DafnySequence.asString((String)"key")), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed raw key id: "), identifier));
        if (_1_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _1_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsResource._typeDescriptor());
        }
        if (Objects.equals(BigInteger.valueOf(_0_info.length()), BigInteger.ONE)) {
            return __default.ParseAwsKmsResources((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"key/"), identifier));
        }
        return __default.ParseAwsKmsResources(identifier);
    }

    public static Result<AwsResource, DafnySequence<? extends Character>> ParseAwsKmsResources(DafnySequence<? extends Character> identifier) {
        DafnySequence<DafnySequence<Character>> _2_info = StandardLibrary_Compile.__default.Split(TypeDescriptor.CHAR, identifier, Character.valueOf('/'));
        Outcome<DafnySequence> _3_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), BigInteger.valueOf(_2_info.length()).compareTo(BigInteger.ONE) > 0, DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed resource: "), identifier));
        if (_3_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _3_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        DafnySequence _4_resourceType = (DafnySequence)_2_info.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        DafnySequence _5_value = StandardLibrary_Compile.__default.Join(TypeDescriptor.CHAR, _2_info.drop(BigInteger.ONE), DafnySequence.asString((String)"/"));
        AwsResource _6_resource = AwsResource.create((DafnySequence<? extends Character>)_4_resourceType, _5_value);
        Outcome<DafnySequence> _7_valueOrError1 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.ValidAwsKmsResource(_6_resource), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed resource: "), identifier));
        if (_7_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _7_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        return Result.create_Success(_6_resource);
    }

    public static boolean ValidAmazonDynamodbResource(AwsResource resource) {
        return resource.Valid() && resource.dtor_resourceType().equals((Object)DafnySequence.asString((String)"table"));
    }

    public static boolean ValidAmazonDynamodbArn(AwsArn arn) {
        return arn.Valid() && arn.dtor_service().equals((Object)DafnySequence.asString((String)"dynamodb")) && __default.ValidAmazonDynamodbResource(arn.dtor_resource());
    }

    public static Result<AwsResource, DafnySequence<? extends Character>> ParseAmazonDynamodbResources(DafnySequence<? extends Character> identifier) {
        Option<Tuple2<DafnySequence<Character>, DafnySequence<Character>>> _8_info = StandardLibrary_Compile.__default.SplitOnce_q(TypeDescriptor.CHAR, identifier, Character.valueOf('/'));
        Outcome<DafnySequence> _9_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _8_info.is_Some(), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed resource: "), identifier));
        if (_9_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _9_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        DafnySequence _10_resourceType = (DafnySequence)_8_info.dtor_value().dtor__0();
        DafnySequence _11_value = (DafnySequence)_8_info.dtor_value().dtor__1();
        Outcome<DafnySequence> _12_valueOrError1 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__TableName((DafnySequence<? extends Character>)_11_value), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Table Name invalid: "), identifier));
        if (_12_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _12_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        AwsResource _13_resource = AwsResource.create((DafnySequence<? extends Character>)_10_resourceType, (DafnySequence<? extends Character>)_11_value);
        Outcome<DafnySequence> _14_valueOrError2 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.ValidAmazonDynamodbResource(_13_resource), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed resource: "), identifier));
        if (_14_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _14_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        return Result.create_Success(_13_resource);
    }

    public static Result<AwsArn, DafnySequence<? extends Character>> ParseAwsKmsArn(DafnySequence<? extends Character> identifier) {
        DafnySequence<DafnySequence<Character>> _15_components = StandardLibrary_Compile.__default.Split(TypeDescriptor.CHAR, identifier, Character.valueOf(':'));
        Outcome<DafnySequence> _16_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Objects.equals(BigInteger.valueOf(6L), BigInteger.valueOf(_15_components.length())), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed arn: "), identifier));
        if (_16_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _16_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        Result<AwsResource, DafnySequence<? extends Character>> _17_valueOrError1 = __default.ParseAwsKmsResources((DafnySequence<? extends Character>)((DafnySequence)_15_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(5L)))));
        if (_17_valueOrError1.IsFailure(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _17_valueOrError1.PropagateFailure(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        AwsResource _18_resource = _17_valueOrError1.Extract(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        AwsArn _19_arn = AwsArn.create((DafnySequence<? extends Character>)((DafnySequence)_15_components.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), (DafnySequence<? extends Character>)((DafnySequence)_15_components.select(Helpers.toInt((BigInteger)BigInteger.ONE))), (DafnySequence<? extends Character>)((DafnySequence)_15_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))), (DafnySequence<? extends Character>)((DafnySequence)_15_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L)))), (DafnySequence<? extends Character>)((DafnySequence)_15_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(4L)))), _18_resource);
        Outcome<DafnySequence> _20_valueOrError2 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.ValidAwsKmsArn(_19_arn), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed Arn:"), identifier));
        if (_20_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _20_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        return Result.create_Success(_19_arn);
    }

    public static Result<AwsArn, DafnySequence<? extends Character>> ParseAmazonDynamodbTableArn(DafnySequence<? extends Character> identifier) {
        DafnySequence<DafnySequence<Character>> _21_components = StandardLibrary_Compile.__default.Split(TypeDescriptor.CHAR, identifier, Character.valueOf(':'));
        Outcome<DafnySequence> _22_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Objects.equals(BigInteger.valueOf(6L), BigInteger.valueOf(_21_components.length())), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed arn: "), identifier));
        if (_22_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _22_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        Result<AwsResource, DafnySequence<? extends Character>> _23_valueOrError1 = __default.ParseAmazonDynamodbResources((DafnySequence<? extends Character>)((DafnySequence)_21_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(5L)))));
        if (_23_valueOrError1.IsFailure(AmazonDynamodbResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _23_valueOrError1.PropagateFailure(AmazonDynamodbResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        AwsResource _24_resource = _23_valueOrError1.Extract(AmazonDynamodbResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        AwsArn _25_arn = AwsArn.create((DafnySequence<? extends Character>)((DafnySequence)_21_components.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), (DafnySequence<? extends Character>)((DafnySequence)_21_components.select(Helpers.toInt((BigInteger)BigInteger.ONE))), (DafnySequence<? extends Character>)((DafnySequence)_21_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))), (DafnySequence<? extends Character>)((DafnySequence)_21_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L)))), (DafnySequence<? extends Character>)((DafnySequence)_21_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(4L)))), _24_resource);
        Outcome<DafnySequence> _26_valueOrError2 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.ValidAmazonDynamodbArn(_25_arn), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed Arn:"), identifier));
        if (_26_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _26_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        return Result.create_Success(_25_arn);
    }

    public static Result<AwsKmsIdentifier, DafnySequence<? extends Character>> ParseAwsKmsIdentifier(DafnySequence<? extends Character> identifier) {
        if (DafnySequence.asString((String)"arn:").isPrefixOf(identifier)) {
            Result<AwsArn, DafnySequence<? extends Character>> _27_valueOrError0 = __default.ParseAwsKmsArn(identifier);
            if (_27_valueOrError0.IsFailure(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _27_valueOrError0.PropagateFailure(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
            }
            AwsArn _28_arn = _27_valueOrError0.Extract(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            return Result.create_Success(AwsKmsIdentifier.create_AwsKmsArnIdentifier(_28_arn));
        }
        Result<AwsResource, DafnySequence<? extends Character>> _29_valueOrError1 = __default.ParseAwsKmsRawResources(identifier);
        if (_29_valueOrError1.IsFailure(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _29_valueOrError1.PropagateFailure(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
        }
        AwsResource _30_r = _29_valueOrError1.Extract(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        return Result.create_Success(AwsKmsIdentifier.create_AwsKmsRawResourceIdentifier(_30_r));
    }

    public static Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> ParseAmazonDynamodbTableName(DafnySequence<? extends Character> identifier) {
        Result<AwsArn, DafnySequence<? extends Character>> _31_valueOrError0 = __default.ParseAmazonDynamodbTableArn(identifier);
        if (_31_valueOrError0.IsFailure(AmazonDynamodbTableArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _31_valueOrError0.PropagateFailure(AmazonDynamodbTableArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        AwsArn _32_arn = _31_valueOrError0.Extract(AmazonDynamodbTableArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        AmazonDynamodbTableName _33_tableArn = AmazonDynamodbTableName.create(_32_arn);
        DafnySequence<? extends Character> _34_tableName = _33_tableArn.GetTableName();
        return Result.create_Success(_34_tableName);
    }

    public static boolean IsMultiRegionAwsKmsArn(AwsArn arn) {
        return __default.IsMultiRegionAwsKmsResource(arn.dtor_resource());
    }

    public static boolean IsMultiRegionAwsKmsIdentifier(AwsKmsIdentifier identifier) {
        AwsResource _37___mcc_h1;
        AwsKmsIdentifier _source0 = identifier;
        if (_source0.is_AwsKmsArnIdentifier()) {
            AwsArn _35___mcc_h0;
            AwsArn _36_arn = _35___mcc_h0 = ((AwsKmsIdentifier_AwsKmsArnIdentifier)_source0)._a;
            return __default.IsMultiRegionAwsKmsArn(_36_arn);
        }
        AwsResource _38_r = _37___mcc_h1 = ((AwsKmsIdentifier_AwsKmsRawResourceIdentifier)_source0)._r;
        return __default.IsMultiRegionAwsKmsResource(_38_r);
    }

    public static boolean IsMultiRegionAwsKmsResource(AwsResource resource) {
        return resource.dtor_resourceType().equals((Object)DafnySequence.asString((String)"key")) && DafnySequence.asString((String)"mrk-").isPrefixOf(resource.dtor_value());
    }

    public static Option<DafnySequence<? extends Character>> GetRegion(AwsKmsIdentifier identifier) {
        AwsKmsIdentifier _source1 = identifier;
        if (_source1.is_AwsKmsArnIdentifier()) {
            AwsArn _39___mcc_h0;
            AwsArn _40_a = _39___mcc_h0 = ((AwsKmsIdentifier_AwsKmsArnIdentifier)_source1)._a;
            return Option.create_Some(_40_a.dtor_region());
        }
        AwsResource _41___mcc_h1 = ((AwsKmsIdentifier_AwsKmsRawResourceIdentifier)_source1)._r;
        return Option.create_None();
    }

    public static Result<AwsKmsIdentifier, DafnySequence<? extends Character>> IsAwsKmsIdentifierString(DafnySequence<? extends Character> s) {
        Outcome<DafnySequence> _42_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), UTF8.__default.IsASCIIString(s), DafnySequence.asString((String)"Not a valid ASCII string."));
        if (_42_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _42_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
        }
        Outcome<DafnySequence> _43_valueOrError1 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), BigInteger.valueOf(s.length()).signum() == 1 && BigInteger.valueOf(s.length()).compareTo(__default.MAX__AWS__KMS__IDENTIFIER__LENGTH()) <= 0, DafnySequence.asString((String)"Identifier exceeds maximum length."));
        if (_43_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _43_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
        }
        return __default.ParseAwsKmsIdentifier(s);
    }

    public static Error Error(DafnySequence<? extends Character> s) {
        return Error.create_AwsCryptographicMaterialProvidersException(s);
    }

    public static Result<Tuple0, Error> ValidateDdbTableArn(DafnySequence<? extends Character> tableArn) {
        Result<DafnySequence<? extends Character>, Error> _44_valueOrError0 = __default.ParseAmazonDynamodbTableName(tableArn).MapFailure(TableName._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::Error);
        if (_44_valueOrError0.IsFailure(TableName._typeDescriptor(), Error._typeDescriptor())) {
            return _44_valueOrError0.PropagateFailure(TableName._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        DafnySequence<? extends Character> _45___v1 = _44_valueOrError0.Extract(TableName._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _46_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), UTF8.__default.IsASCIIString(tableArn), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Table Arn is not ASCII")));
        if (_46_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _46_valueOrError1.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        Outcome<Error> _47_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__TableName(__default.ParseAmazonDynamodbTableName(tableArn).dtor_value()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Table Name is too long")));
        if (_47_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _47_valueOrError2.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        return Result.create_Success(Tuple0.create());
    }

    public static BigInteger MAX__AWS__KMS__IDENTIFIER__LENGTH() {
        return BigInteger.valueOf(2048L);
    }

    public String toString() {
        return "AwsArnParsing._default";
    }
}

