/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.services.kms.internaldafny;

import StandardLibraryInterop_Compile.WrappersInterop;
import Wrappers_Compile.Option;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.cryptography.services.kms.internaldafny.Shim;
import software.amazon.cryptography.services.kms.internaldafny._ExternBase___default;
import software.amazon.cryptography.services.kms.internaldafny.types.Error;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.smithy.dafny.conversion.ToDafny;
import software.amazon.smithy.dafny.conversion.ToNative;

public class __default
extends _ExternBase___default {
    public static Result<IKMSClient, Error> KMSClient() {
        try {
            KmsClientBuilder builder = KmsClient.builder();
            DefaultAwsRegionProviderChain regionProvider = DefaultAwsRegionProviderChain.builder().build();
            String region = regionProvider.getRegion().toString();
            KmsClient client = (KmsClient)((KmsClientBuilder)builder.overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)__default.UserAgentSuffix()).build())).build();
            Shim shim = new Shim(client, region);
            return __default.CreateSuccessOfClient(shim);
        }
        catch (Exception e) {
            Error dafny_error = Error.create_KMSInternalException(WrappersInterop.CreateStringSome((DafnySequence<? extends Character>)ToDafny.Simple.CharacterSequence((String)e.getMessage())));
            return __default.CreateFailureOfError(dafny_error);
        }
    }

    public static Result<IKMSClient, Error> KMSClientForRegion(DafnySequence<? extends Character> region) {
        try {
            char[] inputRegion = (char[])region.toArray().unwrap();
            if (inputRegion.length == 0) {
                return __default.KMSClient();
            }
            String regionString = new String(inputRegion);
            KmsClientBuilder builder = KmsClient.builder();
            KmsClient client = (KmsClient)((KmsClientBuilder)((KmsClientBuilder)builder.region(Region.of((String)regionString))).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)__default.UserAgentSuffix()).build())).build();
            Shim shim = new Shim(client, regionString);
            return __default.CreateSuccessOfClient(shim);
        }
        catch (Exception e) {
            Error dafny_error = Error.create_KMSInternalException(WrappersInterop.CreateStringSome((DafnySequence<? extends Character>)ToDafny.Simple.CharacterSequence((String)e.getMessage())));
            return __default.CreateFailureOfError(dafny_error);
        }
    }

    public static Option<Boolean> RegionMatch(IKMSClient client, DafnySequence<? extends Character> region) {
        Shim shim = (Shim)client;
        if (shim.region() == null) {
            return WrappersInterop.CreateBooleanNone();
        }
        String shimRegion = shim.region();
        String regionStr = ToNative.Simple.String(region);
        return WrappersInterop.CreateBooleanSome(regionStr.equals(shimRegion));
    }

    private static String UserAgentSuffix() {
        DafnySequence runtime = ToDafny.Simple.CharacterSequence((String)"Java");
        return new String((char[])__default.DafnyUserAgentSuffix((DafnySequence<? extends Character>)runtime).toArray().unwrap());
    }
}

