/*
 * Decompiled with CFR 0.152.
 */
package LocalCMC_Compile;

import BoundedInts_Compile.uint8;
import DafnyLibraries.MutableMap;
import LocalCMC_Compile.CacheEntry;
import LocalCMC_Compile.DoublyLinkedCacheEntryList;
import LocalCMC_Compile.__default;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.PositiveInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.UpdateUsageMetadataInput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsCache;

public class LocalCMC
implements ICryptographicMaterialsCache {
    public DoublyLinkedCacheEntryList queue = null;
    public MutableMap<DafnySequence<? extends Byte>, CacheEntry> cache = null;
    public BigInteger _entryCapacity = BigInteger.ZERO;
    public BigInteger _entryPruningTailSize = BigInteger.ZERO;
    private static final TypeDescriptor<LocalCMC> _TYPE = TypeDescriptor.referenceWithInitializer(LocalCMC.class, () -> null);

    @Override
    public Result<Tuple0, Error> PutCacheEntry(PutCacheEntryInput input) {
        Result<Tuple0, Error> _out115 = _Companion_ICryptographicMaterialsCache.PutCacheEntry(this, input);
        return _out115;
    }

    @Override
    public Result<Tuple0, Error> UpdateUsageMetadata(UpdateUsageMetadataInput input) {
        Result<Tuple0, Error> _out116 = _Companion_ICryptographicMaterialsCache.UpdateUsageMetadata(this, input);
        return _out116;
    }

    @Override
    public Result<GetCacheEntryOutput, Error> GetCacheEntry(GetCacheEntryInput input) {
        Result<GetCacheEntryOutput, Error> _out117 = _Companion_ICryptographicMaterialsCache.GetCacheEntry(this, input);
        return _out117;
    }

    @Override
    public Result<Tuple0, Error> DeleteCacheEntry(DeleteCacheEntryInput input) {
        Result<Tuple0, Error> _out118 = _Companion_ICryptographicMaterialsCache.DeleteCacheEntry(this, input);
        return _out118;
    }

    public void __ctor(BigInteger entryCapacity_k, BigInteger entryPruningTailSize_k) {
        this._entryCapacity = entryCapacity_k;
        this._entryPruningTailSize = entryPruningTailSize_k;
        MutableMap _nw28 = new MutableMap(DafnySequence._typeDescriptor(uint8._typeDescriptor()), CacheEntry._typeDescriptor());
        this.cache = _nw28;
        DoublyLinkedCacheEntryList _nw29 = new DoublyLinkedCacheEntryList();
        _nw29.__ctor();
        this.queue = _nw29;
    }

    @Override
    public Result<GetCacheEntryOutput, Error> GetCacheEntry_k(GetCacheEntryInput input) {
        Result<GetCacheEntryOutput, Error> _out120;
        long _out119;
        Result<GetCacheEntryOutput, Error> output = null;
        long _855_now = _out119 = Time.__default.CurrentRelativeTime().longValue();
        output = _out120 = this.GetCacheEntryWithTime(input, _855_now);
        return output;
    }

    public Result<GetCacheEntryOutput, Error> GetCacheEntryWithTime(GetCacheEntryInput input, long now) {
        Result<GetCacheEntryOutput, Error> output = null;
        if (this.cache.HasKey(input.dtor_identifier())) {
            CacheEntry _856_entry = this.cache.Select(input.dtor_identifier());
            if (now <= _856_entry.expiryTime()) {
                this.queue.moveToFront(_856_entry);
                output = Result.create_Success(GetCacheEntryOutput.create(_856_entry.materials(), _856_entry.creationTime(), _856_entry.expiryTime(), _856_entry.messagesUsed, _856_entry.bytesUsed));
                Result<Tuple0, Object> _858_valueOrError0 = Result.Default(Tuple0.Default());
                Result<Tuple0, Error> _out121 = this.pruning(now);
                _858_valueOrError0 = _out121;
                if (_858_valueOrError0.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                    output = _858_valueOrError0.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), GetCacheEntryOutput._typeDescriptor());
                    return output;
                }
                Tuple0 tuple0 = _858_valueOrError0.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            } else {
                Result<Tuple0, Object> _860_valueOrError1 = Result.Default(Tuple0.Default());
                Result<Tuple0, Error> _out122 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(input.dtor_identifier()));
                _860_valueOrError1 = _out122;
                if (_860_valueOrError1.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                    output = _860_valueOrError1.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), GetCacheEntryOutput._typeDescriptor());
                    return output;
                }
                Tuple0 _859___v1 = _860_valueOrError1.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
                output = Result.create_Failure(Error.create_EntryDoesNotExist((DafnySequence<? extends Character>)DafnySequence.asString((String)"Entry past TTL")));
            }
        } else {
            output = Result.create_Failure(Error.create_EntryDoesNotExist((DafnySequence<? extends Character>)DafnySequence.asString((String)"Entry does not exist")));
        }
        return output;
    }

    @Override
    public Result<Tuple0, Error> PutCacheEntry_k(PutCacheEntryInput input) {
        Tuple0 tuple0;
        Result<Object, Error> output = Result.Default(Tuple0.Default());
        if (this.entryCapacity().signum() == 0) {
            output = Result.create_Success(Tuple0.create());
            return output;
        }
        if (this.cache.HasKey(input.dtor_identifier())) {
            Result<Tuple0, Object> _862_valueOrError0 = Result.Default(Tuple0.Default());
            Result<Tuple0, Error> _out123 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(input.dtor_identifier()));
            _862_valueOrError0 = _out123;
            if (_862_valueOrError0.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                output = _862_valueOrError0.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
                return output;
            }
            tuple0 = _862_valueOrError0.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
        }
        if (Objects.equals(this.entryCapacity(), this.cache.Size())) {
            Result<Tuple0, Object> _864_valueOrError1 = Result.Default(Tuple0.Default());
            Result<Tuple0, Error> _out124 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(this.queue.tail.dtor_deref().identifier()));
            _864_valueOrError1 = _out124;
            if (_864_valueOrError1.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                output = _864_valueOrError1.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
                return output;
            }
            tuple0 = _864_valueOrError1.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
        }
        CacheEntry _nw30 = new CacheEntry();
        _nw30.__ctor(input.dtor_materials(), input.dtor_identifier(), input.dtor_creationTime(), input.dtor_expiryTime(), input.dtor_messagesUsed().UnwrapOr(PositiveInteger._typeDescriptor(), 0), input.dtor_bytesUsed().UnwrapOr(PositiveInteger._typeDescriptor(), 0));
        CacheEntry _865_cell = _nw30;
        this.queue.pushCell(_865_cell);
        this.cache.Put(input.dtor_identifier(), _865_cell);
        output = Result.create_Success(Tuple0.create());
        return output;
    }

    @Override
    public Result<Tuple0, Error> DeleteCacheEntry_k(DeleteCacheEntryInput input) {
        Result<Tuple0, Error> output = Result.Default(Tuple0.Default());
        if (this.cache.HasKey(input.dtor_identifier())) {
            CacheEntry _866_cell = this.cache.Select(input.dtor_identifier());
            this.cache.Remove(input.dtor_identifier());
            this.queue.remove(_866_cell);
        }
        output = Result.create_Success(Tuple0.create());
        return output;
    }

    @Override
    public Result<Tuple0, Error> UpdateUsageMetadata_k(UpdateUsageMetadataInput input) {
        Result<Object, Error> output = Result.Default(Tuple0.Default());
        if (this.cache.HasKey(input.dtor_identifier())) {
            CacheEntry _867_cell = this.cache.Select(input.dtor_identifier());
            if (_867_cell.messagesUsed <= __default.INT32__MAX__VALUE() - 1 && _867_cell.bytesUsed <= __default.INT32__MAX__VALUE() - input.dtor_bytesUsed()) {
                int _rhs0 = _867_cell.messagesUsed + 1;
                int _rhs1 = _867_cell.bytesUsed + input.dtor_bytesUsed();
                CacheEntry _lhs0 = _867_cell;
                CacheEntry _lhs1 = _867_cell;
                _lhs0.messagesUsed = _rhs0;
                _lhs1.bytesUsed = _rhs1;
            } else {
                Result<Tuple0, Object> _869_valueOrError0 = Result.Default(Tuple0.Default());
                Result<Tuple0, Error> _out125 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(input.dtor_identifier()));
                _869_valueOrError0 = _out125;
                if (_869_valueOrError0.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                    output = _869_valueOrError0.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
                    return output;
                }
                Tuple0 tuple0 = _869_valueOrError0.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            }
        }
        output = Result.create_Success(Tuple0.create());
        return output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result<Tuple0, Error> pruning(long now) {
        Result result = Result.Default(Tuple0.Default());
        BigInteger _hi6 = this.entryPruningTailSize();
        BigInteger _870_i = BigInteger.ZERO;
        while (_870_i.compareTo(_hi6) < 0) {
            if (!this.queue.tail.is_Ptr()) return Result.create_Success(Tuple0.create());
            if (this.queue.tail.dtor_deref().expiryTime() >= now) return Result.create_Success(Tuple0.create());
            Result<Tuple0, Object> _872_valueOrError0 = Result.Default(Tuple0.Default());
            Result<Tuple0, Error> _out126 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(this.queue.tail.dtor_deref().identifier()));
            _872_valueOrError0 = _out126;
            if (_872_valueOrError0.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                return _872_valueOrError0.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
            }
            Tuple0 tuple0 = _872_valueOrError0.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            _870_i = _870_i.add(BigInteger.ONE);
        }
        return Result.create_Success(Tuple0.create());
    }

    public BigInteger entryCapacity() {
        return this._entryCapacity;
    }

    public BigInteger entryPruningTailSize() {
        return this._entryPruningTailSize;
    }

    public static TypeDescriptor<LocalCMC> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "LocalCMC.LocalCMC";
    }
}

