/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsRsaKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsRsaKeyring_Compile.KmsRsaUnwrapInfo;
import BoundedInts_Compile.uint8;
import MaterialWrapping_Compile.UnwrapInput;
import MaterialWrapping_Compile.UnwrapMaterial;
import MaterialWrapping_Compile.UnwrapOutput;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class KmsRsaUnwrapKeyMaterial
implements UnwrapMaterial<KmsRsaUnwrapInfo>,
ActionWithResult<UnwrapInput, UnwrapOutput<KmsRsaUnwrapInfo>, Error>,
Action<UnwrapInput, Result<UnwrapOutput<KmsRsaUnwrapInfo>, Error>> {
    public IKMSClient _client = null;
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public EncryptionAlgorithmSpec _paddingScheme = EncryptionAlgorithmSpec.Default();
    public DafnySequence<? extends Byte> _encryptionContextDigest = DafnySequence.empty(uint8._typeDescriptor());
    private static final TypeDescriptor<KmsRsaUnwrapKeyMaterial> _TYPE = TypeDescriptor.referenceWithInitializer(KmsRsaUnwrapKeyMaterial.class, () -> null);

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, EncryptionAlgorithmSpec paddingScheme, DafnySequence<? extends Byte> encryptionContextDigest, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._paddingScheme = paddingScheme;
        this._encryptionContextDigest = encryptionContextDigest;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<UnwrapOutput<KmsRsaUnwrapInfo>, Error> Invoke(UnwrapInput input) {
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out194;
        Result<UnwrapOutput<KmsRsaUnwrapInfo>, Error> res = Result.Default(UnwrapOutput.Default(KmsRsaUnwrapInfo.Default()));
        Outcome<Object> _1128_valueOrError0 = Outcome.Default();
        _1128_valueOrError0 = __default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(input.dtor_wrappedMaterial()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Ciphertext length invalid")));
        if (_1128_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1128_valueOrError0.PropagateFailure(Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsRsaUnwrapInfo._typeDescriptor()));
            return res;
        }
        DecryptRequest _1129_decryptRequest = DecryptRequest.create(input.dtor_wrappedMaterial(), Option.create_None(), Option.create_Some(this.grantTokens()), Option.create_Some(this.awsKmsKey()), Option.create_Some(this.paddingScheme()));
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _1130_maybeDecryptResponse = _out194 = this.client().Decrypt(_1129_decryptRequest);
        Result<DecryptResponse, Object> _1132_valueOrError1 = Result.Default(DecryptResponse.Default());
        _1132_valueOrError1 = _1130_maybeDecryptResponse.MapFailure(DecryptResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _1133_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _1133_e = _1133_e_boxed0;
            return Error.create_ComAmazonawsKms(_1133_e);
        });
        if (_1132_valueOrError1.IsFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _1132_valueOrError1.PropagateFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsRsaUnwrapInfo._typeDescriptor()));
            return res;
        }
        DecryptResponse _1131_decryptResponse = _1132_valueOrError1.Extract(DecryptResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _1134_valueOrError2 = Outcome.Default();
        _1134_valueOrError2 = __default.Need(Error._typeDescriptor(), _1131_decryptResponse.dtor_KeyId().is_Some() && _1131_decryptResponse.dtor_KeyId().dtor_value().equals(this.awsKmsKey()) && _1131_decryptResponse.dtor_Plaintext().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS Decrypt")));
        if (_1134_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _1134_valueOrError2.PropagateFailure(Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsRsaUnwrapInfo._typeDescriptor()));
            return res;
        }
        Outcome<Object> _1135_valueOrError3 = Outcome.Default();
        _1135_valueOrError3 = __default.Need(Error._typeDescriptor(), this.encryptionContextDigest().isPrefixOf(_1131_decryptResponse.dtor_Plaintext().dtor_value()) && Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(input.dtor_algorithmSuite())).add(BigInteger.valueOf(this.encryptionContextDigest().length())), BigInteger.valueOf(_1131_decryptResponse.dtor_Plaintext().dtor_value().length())), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption context digest does not match expected value.")));
        if (_1135_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _1135_valueOrError3.PropagateFailure(Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsRsaUnwrapInfo._typeDescriptor()));
            return res;
        }
        UnwrapOutput<KmsRsaUnwrapInfo> _1136_output = UnwrapOutput.create((DafnySequence<? extends Byte>)_1131_decryptResponse.dtor_Plaintext().dtor_value().drop(BigInteger.valueOf(this.encryptionContextDigest().length())), KmsRsaUnwrapInfo.create());
        res = Result.create_Success(_1136_output);
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public EncryptionAlgorithmSpec paddingScheme() {
        return this._paddingScheme;
    }

    public DafnySequence<? extends Byte> encryptionContextDigest() {
        return this._encryptionContextDigest;
    }

    public static TypeDescriptor<KmsRsaUnwrapKeyMaterial> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsRsaKeyring.KmsRsaUnwrapKeyMaterial";
    }
}

