/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsHierarchicalKeyring_Compile;

import AwsKmsHierarchicalKeyring_Compile.DecryptSingleEncryptedDataKey;
import AwsKmsHierarchicalKeyring_Compile.HierarchyWrapInfo;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyGenerateAndWrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyWrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.OnDecryptHierarchyEncryptedDataKeyFilter;
import AwsKmsHierarchicalKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.IBranchKeyIdSupplier;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;

public class AwsKmsHierarchicalKeyring
implements VerifiableInterface,
IKeyring {
    public IKeyStoreClient _keyStore = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public Option<IBranchKeyIdSupplier> _branchKeyIdSupplier = Option.Default();
    public Option<DafnySequence<? extends Character>> _branchKeyId = Option.Default();
    public long _ttlSeconds = 0L;
    public ICryptographicMaterialsCache _cache = null;
    private static final TypeDescriptor<AwsKmsHierarchicalKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsHierarchicalKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out150 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out150;
    }

    @Override
    public Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out151 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out151;
    }

    public void __ctor(IKeyStoreClient keyStore, Option<DafnySequence<? extends Character>> branchKeyId, Option<IBranchKeyIdSupplier> branchKeyIdSupplier, long ttlSeconds, ICryptographicMaterialsCache cmc, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyStore = keyStore;
        this._branchKeyId = branchKeyId;
        this._branchKeyIdSupplier = branchKeyIdSupplier;
        this._ttlSeconds = ttlSeconds;
        this._cryptoPrimitives = cryptoPrimitives;
        this._cache = cmc;
    }

    public Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetBranchKeyId(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> context) {
        Result<Object, software.amazon.cryptography.materialproviders.internaldafny.types.Error> ret = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        if (this.branchKeyId().is_Some()) {
            ret = Result.create_Success(this.branchKeyId().dtor_value());
            return ret;
        }
        Result<GetBranchKeyIdOutput, Object> _892_valueOrError0 = Result.Default(GetBranchKeyIdOutput.Default());
        Result<GetBranchKeyIdOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out152 = this.branchKeyIdSupplier().dtor_value().GetBranchKeyId(GetBranchKeyIdInput.create(context));
        _892_valueOrError0 = _out152;
        if (_892_valueOrError0.IsFailure(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            ret = _892_valueOrError0.PropagateFailure(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            return ret;
        }
        GetBranchKeyIdOutput _891_GetBranchKeyIdOut = _892_valueOrError0.Extract(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        ret = Result.create_Success(_891_GetBranchKeyIdOut.dtor_branchKeyId());
        return ret;
    }

    @Override
    public Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        EncryptionMaterials _893_materials = input.dtor_materials();
        AlgorithmSuiteInfo _894_suite = _893_materials.dtor_algorithmSuite();
        Result<Object, Object> _896_valueOrError0 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out153 = this.GetBranchKeyId(_893_materials.dtor_encryptionContext());
        _896_valueOrError0 = _out153;
        if (_896_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _896_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _895_branchKeyIdForEncrypt = (DafnySequence)_896_valueOrError0.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence<? extends Byte>, Object> _898_valueOrError1 = Result.Default(ValidUTF8Bytes.defaultValue());
        _898_valueOrError1 = UTF8.__default.Encode((DafnySequence<? extends Character>)_895_branchKeyIdForEncrypt).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_898_valueOrError1.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _898_valueOrError1.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _897_branchKeyIdUtf8 = _898_valueOrError1.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _900_valueOrError2 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out154 = this.GetActiveCacheId((DafnySequence<? extends Character>)_895_branchKeyIdForEncrypt, _897_branchKeyIdUtf8, this.cryptoPrimitives());
        _900_valueOrError2 = _out154;
        if (_900_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _900_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _899_cacheId = (DafnySequence)_900_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<BranchKeyMaterials, Object> _902_valueOrError3 = Result.Default(BranchKeyMaterials.Default());
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out155 = this.GetActiveHierarchicalMaterials((DafnySequence<? extends Character>)_895_branchKeyIdForEncrypt, (DafnySequence<? extends Byte>)_899_cacheId, this.keyStore());
        _902_valueOrError3 = _out155;
        if (_902_valueOrError3.IsFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _902_valueOrError3.PropagateFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        BranchKeyMaterials _901_hierarchicalMaterials = _902_valueOrError3.Extract(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Byte> _903_branchKey = _901_hierarchicalMaterials.dtor_branchKey();
        DafnySequence<? extends Byte> _904_branchKeyVersion = _901_hierarchicalMaterials.dtor_branchKeyVersion();
        Result<Object, Object> _906_valueOrError4 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _906_valueOrError4 = UTF8.__default.Decode(_904_branchKeyVersion).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_906_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _906_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _905_branchKeyVersionAsString = (DafnySequence)_906_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _908_valueOrError5 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _908_valueOrError5 = UUID.__default.ToByteArray((DafnySequence<? extends Character>)_905_branchKeyVersionAsString).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_908_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _908_valueOrError5.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _907_branchKeyVersionAsBytes = (DafnySequence)_908_valueOrError5.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        KmsHierarchyGenerateAndWrapKeyMaterial _nw33 = new KmsHierarchyGenerateAndWrapKeyMaterial();
        _nw33.__ctor(_901_hierarchicalMaterials.dtor_branchKey(), _897_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_907_branchKeyVersionAsBytes, this.cryptoPrimitives());
        KmsHierarchyGenerateAndWrapKeyMaterial _909_kmsHierarchyGenerateAndWrap = _nw33;
        KmsHierarchyWrapKeyMaterial _nw34 = new KmsHierarchyWrapKeyMaterial();
        _nw34.__ctor(_901_hierarchicalMaterials.dtor_branchKey(), _897_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_907_branchKeyVersionAsBytes, this.cryptoPrimitives());
        KmsHierarchyWrapKeyMaterial _910_kmsHierarchyWrap = _nw34;
        Result<WrapEdkMaterialOutput<HierarchyWrapInfo>, Object> _912_valueOrError6 = Result.Default(WrapEdkMaterialOutput.Default(HierarchyWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<HierarchyWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out156 = EdkWrapping_Compile.__default.WrapEdkMaterial(HierarchyWrapInfo._typeDescriptor(), _893_materials, _910_kmsHierarchyWrap, _909_kmsHierarchyGenerateAndWrap);
        _912_valueOrError6 = _out156;
        if (_912_valueOrError6.IsFailure(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _912_valueOrError6.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<HierarchyWrapInfo> _911_wrapOutput = _912_valueOrError6.Extract(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _913_symmetricSigningKeyList = _911_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_911_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _914_edk = EncryptedDataKey.create(Constants_Compile.__default.PROVIDER__ID__HIERARCHY(), _897_branchKeyIdUtf8, _911_wrapOutput.dtor_wrappedMaterial());
        if (_911_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _916_valueOrError7 = null;
            _916_valueOrError7 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_893_materials, _911_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_914_edk}), _913_symmetricSigningKeyList);
            if (_916_valueOrError7.IsFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                res = _916_valueOrError7.PropagateFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _915_result = _916_valueOrError7.Extract(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_915_result));
            return res;
        }
        if (_911_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _918_valueOrError8 = null;
            _918_valueOrError8 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_893_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_914_edk}), _913_symmetricSigningKeyList);
            if (_918_valueOrError8.IsFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                res = _918_valueOrError8.PropagateFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _917_result = _918_valueOrError8.Extract(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_917_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>> _out159;
        Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        DecryptionMaterials _919_materials = input.dtor_materials();
        AlgorithmSuiteInfo _920_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _921_valueOrError0 = Outcome.Default();
        _921_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_919_materials), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_921_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _921_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Result<Object, Object> _923_valueOrError1 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out157 = this.GetBranchKeyId(_919_materials.dtor_encryptionContext());
        _923_valueOrError1 = _out157;
        if (_923_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _923_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _922_branchKeyIdForDecrypt = (DafnySequence)_923_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        OnDecryptHierarchyEncryptedDataKeyFilter _nw35 = new OnDecryptHierarchyEncryptedDataKeyFilter();
        _nw35.__ctor((DafnySequence<? extends Character>)_922_branchKeyIdForDecrypt);
        OnDecryptHierarchyEncryptedDataKeyFilter _924_filter = _nw35;
        Result<Object, Object> _926_valueOrError2 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out158 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _924_filter, input.dtor_encryptedDataKeys());
        _926_valueOrError2 = _out158;
        if (_926_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _926_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _925_edksToAttempt = (DafnySequence)_926_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        if (BigInteger.valueOf(_925_edksToAttempt.length()).signum() == 0) {
            Result<Object, Object> _928_valueOrError3 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _928_valueOrError3 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_928_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                res = _928_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _927_errorMessage = (DafnySequence)_928_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            res = Result.create_Failure(software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_927_errorMessage));
            return res;
        }
        DecryptSingleEncryptedDataKey _nw36 = new DecryptSingleEncryptedDataKey();
        _nw36.__ctor(_919_materials, this.keyStore(), this.cryptoPrimitives(), (DafnySequence<? extends Character>)_922_branchKeyIdForDecrypt, this.ttlSeconds(), this.cache());
        DecryptSingleEncryptedDataKey _929_decryptClosure = _nw36;
        Result<DecryptionMaterials, DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>> _930_outcome = _out159 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _929_decryptClosure, _925_edksToAttempt);
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _932_valueOrError4 = null;
        _932_valueOrError4 = _930_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>>)DafnySequence._typeDescriptor(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _933_errors_boxed0 -> {
            DafnySequence _933_errors = _933_errors_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_CollectionOfErrors((DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.Error>)_933_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_932_valueOrError4.IsFailure(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _932_valueOrError4.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _931_SealedDecryptionMaterials = _932_valueOrError4.Extract(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_931_SealedDecryptionMaterials));
        return res;
    }

    public Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetActiveCacheId(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> branchKeyIdUtf8, AtomicPrimitivesClient cryptoPrimitives) {
        Result<DafnySequence<? extends Byte>, Error> _out161;
        Result<DafnySequence<? extends Byte>, Error> _out160;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> cacheId = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _934_valueOrError0 = Outcome.Default();
        _934_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).is_Success() && (Boolean)Helpers.Let(UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).dtor_value(), boxed40 -> {
            DafnySequence _pat_let20_0 = boxed40;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let20_0, boxed41 -> {
                DafnySequence _935_branchKeyId = boxed41;
                return BigInteger.valueOf(_935_branchKeyId.length()).signum() != -1 && BigInteger.valueOf(_935_branchKeyId.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT32__LIMIT()) < 0;
            }));
        }) != false, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Branch Key ID Length")));
        if (_934_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _934_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Character> _936_branchKeyId = UTF8.__default.Decode(branchKeyIdUtf8).dtor_value();
        DafnySequence<? extends Byte> _937_lenBranchKey = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(_936_branchKeyId.cardinalityInt());
        DigestAlgorithm _938_hashAlgorithm = DigestAlgorithm.create_SHA__512();
        Result<DafnySequence<? extends Byte>, Error> _939_maybeBranchKeyDigest = _out160 = cryptoPrimitives.Digest(DigestInput.create(_938_hashAlgorithm, branchKeyIdUtf8));
        Result<Object, Object> _941_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _941_valueOrError1 = _939_maybeBranchKeyDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _942_e_boxed0 -> {
            Error _942_e = _942_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_942_e);
        });
        if (_941_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _941_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _940_branchKeyDigest = (DafnySequence)_941_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence<? extends Byte>, Object> _944_valueOrError2 = Result.Default(ValidUTF8Bytes.defaultValue());
        _944_valueOrError2 = UTF8.__default.Encode(__default.EXPRESSION__ATTRIBUTE__VALUE__STATUS__VALUE()).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_944_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _944_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Byte> _943_activeUtf8 = _944_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence _945_identifier = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_937_lenBranchKey, (DafnySequence)_940_branchKeyDigest), (DafnySequence)DafnySequence.of((byte[])new byte[]{0})), _943_activeUtf8);
        Result<DafnySequence<? extends Byte>, Error> _946_maybeCacheIdDigest = _out161 = cryptoPrimitives.Digest(DigestInput.create(_938_hashAlgorithm, (DafnySequence<? extends Byte>)_945_identifier));
        Result<Object, Object> _948_valueOrError3 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _948_valueOrError3 = _946_maybeCacheIdDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _949_e_boxed0 -> {
            Error _949_e = _949_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_949_e);
        });
        if (_948_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _948_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _947_cacheDigest = (DafnySequence)_948_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _950_valueOrError4 = Outcome.Default();
        _950_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(_947_cacheDigest.length()), Digest_Compile.__default.Length(_938_hashAlgorithm)), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Digest generated a message not equal to the expected length.")));
        if (_950_valueOrError4.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _950_valueOrError4.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        cacheId = Result.create_Success(_947_cacheDigest.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(32L))));
        return cacheId;
    }

    public Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetActiveHierarchicalMaterials(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> cacheId, IKeyStoreClient keyStore) {
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> material = Result.Default(BranchKeyMaterials.Default());
        GetCacheEntryInput _951_getCacheInput = GetCacheEntryInput.create(cacheId, Option.create_None());
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out162 = __default.getEntry(this.cache(), _951_getCacheInput);
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _952_getCacheOutput = _out162;
        if (_952_getCacheOutput.is_Failure()) {
            long _out164;
            Result<GetActiveBranchKeyOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _out163;
            Result<GetActiveBranchKeyOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _953_maybeGetActiveBranchKeyOutput = _out163 = keyStore.GetActiveBranchKey(GetActiveBranchKeyInput.create(branchKeyId));
            Result<GetActiveBranchKeyOutput, Object> _955_valueOrError0 = Result.Default(GetActiveBranchKeyOutput.Default());
            _955_valueOrError0 = _953_maybeGetActiveBranchKeyOutput.MapFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _956_e_boxed0 -> {
                software.amazon.cryptography.keystore.internaldafny.types.Error _956_e = _956_e_boxed0;
                return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyKeyStore(_956_e);
            });
            if (_955_valueOrError0.IsFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _955_valueOrError0.PropagateFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            GetActiveBranchKeyOutput _954_getActiveBranchKeyOutput = _955_valueOrError0.Extract(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            BranchKeyMaterials _957_branchKeyMaterials = _954_getActiveBranchKeyOutput.dtor_branchKeyMaterials();
            long _958_now = _out164 = Time.__default.CurrentRelativeTime().longValue();
            Outcome<Object> _959_valueOrError1 = Outcome.Default();
            _959_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_958_now).add(BigInteger.valueOf(this.ttlSeconds())).compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) < 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"INT64 Overflow when putting cache entry.")));
            if (_959_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _959_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            PutCacheEntryInput _960_putCacheEntryInput = PutCacheEntryInput.create(cacheId, Materials.create_BranchKey(_957_branchKeyMaterials), _958_now, this.ttlSeconds() + _958_now, Option.create_None(), Option.create_None());
            Result<Tuple0, Object> _962_valueOrError2 = Result.Default(Tuple0.Default());
            Result<Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out165 = __default.putEntry(this.cache(), _960_putCacheEntryInput);
            _962_valueOrError2 = _out165;
            if (_962_valueOrError2.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _962_valueOrError2.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            Tuple0 _961___v0 = _962_valueOrError2.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            material = Result.create_Success(_957_branchKeyMaterials);
            return material;
        }
        Outcome<Object> _963_valueOrError3 = Outcome.Default();
        _963_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _952_getCacheOutput.dtor_value().dtor_materials().is_BranchKey() && Objects.equals(_952_getCacheOutput.dtor_value().dtor_materials(), Materials.create_BranchKey(_952_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey())), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_963_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            material = _963_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
            return material;
        }
        material = Result.create_Success(_952_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey());
        return material;
    }

    public IKeyStoreClient keyStore() {
        return this._keyStore;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public Option<IBranchKeyIdSupplier> branchKeyIdSupplier() {
        return this._branchKeyIdSupplier;
    }

    public Option<DafnySequence<? extends Character>> branchKeyId() {
        return this._branchKeyId;
    }

    public long ttlSeconds() {
        return this._ttlSeconds;
    }

    public ICryptographicMaterialsCache cache() {
        return this._cache;
    }

    public static TypeDescriptor<AwsKmsHierarchicalKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsHierarchicalKeyring.AwsKmsHierarchicalKeyring";
    }
}

