/*
 * Decompiled with CFR 0.152.
 */
package AlgorithmSuites_Compile;

import AlgorithmSuites_Compile.AlgorithmSuite;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Tuple2;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId_DBE;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteId_ESDK;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.internaldafny.types.DIRECT__KEY__WRAPPING;
import software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm;
import software.amazon.cryptography.materialproviders.internaldafny.types.ECDSA;
import software.amazon.cryptography.materialproviders.internaldafny.types.ESDKAlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.internaldafny.types.EdkWrappingAlgorithm;
import software.amazon.cryptography.materialproviders.internaldafny.types.Encrypt;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.HKDF;
import software.amazon.cryptography.materialproviders.internaldafny.types.IDENTITY;
import software.amazon.cryptography.materialproviders.internaldafny.types.IntermediateKeyWrapping;
import software.amazon.cryptography.materialproviders.internaldafny.types.None;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm;
import software.amazon.cryptography.materialproviders.internaldafny.types.SymmetricSignatureAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.AES__GCM;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;

public class __default {
    public static boolean SupportedESDKEncrypt_q(Encrypt e) {
        return (e.dtor_AES__GCM().dtor_keyLength() == 32 || e.dtor_AES__GCM().dtor_keyLength() == 24 || e.dtor_AES__GCM().dtor_keyLength() == 16) && e.dtor_AES__GCM().dtor_tagLength() == 16 && e.dtor_AES__GCM().dtor_ivLength() == 12;
    }

    public static boolean SupportedDBEEncrypt_q(Encrypt e) {
        return e.dtor_AES__GCM().dtor_keyLength() == 32 && e.dtor_AES__GCM().dtor_tagLength() == 16 && e.dtor_AES__GCM().dtor_ivLength() == 12;
    }

    public static boolean SupportedDBEEDKWrapping_q(EdkWrappingAlgorithm p) {
        return p.is_IntermediateKeyWrapping() && p.dtor_IntermediateKeyWrapping().dtor_pdkEncryptAlgorithm().dtor_AES__GCM().dtor_keyLength() == 32 && p.dtor_IntermediateKeyWrapping().dtor_pdkEncryptAlgorithm().dtor_AES__GCM().dtor_tagLength() == 16 && p.dtor_IntermediateKeyWrapping().dtor_pdkEncryptAlgorithm().dtor_AES__GCM().dtor_ivLength() == 12 && p.dtor_IntermediateKeyWrapping().dtor_macKeyKdf().is_HKDF() && p.dtor_IntermediateKeyWrapping().dtor_keyEncryptionKeyKdf().is_HKDF();
    }

    public static boolean KeyDerivationAlgorithm_q(DerivationAlgorithm kdf) {
        return (!kdf.is_HKDF() || kdf.dtor_HKDF().dtor_inputKeyLength() == kdf.dtor_HKDF().dtor_outputKeyLength() && (!Objects.equals(kdf.dtor_HKDF().dtor_hmac(), DigestAlgorithm.create_SHA__512()) || kdf.dtor_HKDF().dtor_inputKeyLength() == 32)) && !kdf.is_None();
    }

    public static boolean CommitmentDerivationAlgorithm_q(DerivationAlgorithm kdf) {
        return (!kdf.is_HKDF() || kdf.dtor_HKDF().dtor_hmac().is_SHA__512() && kdf.dtor_HKDF().dtor_saltLength() == 32 && kdf.dtor_HKDF().dtor_inputKeyLength() == 32 && kdf.dtor_HKDF().dtor_outputKeyLength() == 32) && !kdf.is_IDENTITY();
    }

    public static boolean EdkWrappingAlgorithm_q(EdkWrappingAlgorithm alg) {
        return alg.is_IntermediateKeyWrapping() && alg.dtor_IntermediateKeyWrapping().dtor_keyEncryptionKeyKdf().is_HKDF() && alg.dtor_IntermediateKeyWrapping().dtor_macKeyKdf().is_HKDF() && alg.dtor_IntermediateKeyWrapping().dtor_pdkEncryptAlgorithm().dtor_AES__GCM().dtor_keyLength() == 32 || alg.is_DIRECT__KEY__WRAPPING();
    }

    public static boolean AlgorithmSuiteInfo_q(AlgorithmSuiteInfo a) {
        return !(!__default.KeyDerivationAlgorithm_q(a.dtor_kdf()) || !__default.CommitmentDerivationAlgorithm_q(a.dtor_commitment()) || !__default.EdkWrappingAlgorithm_q(a.dtor_edkWrapping()) || a.dtor_kdf().is_HKDF() && a.dtor_kdf().dtor_HKDF().dtor_outputKeyLength() != a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() || a.dtor_signature().is_ECDSA() && !a.dtor_kdf().is_HKDF() || a.dtor_commitment().is_HKDF() && (a.dtor_commitment().dtor_HKDF().dtor_saltLength() != 32 || !Objects.equals(a.dtor_commitment(), a.dtor_kdf())) || a.dtor_edkWrapping().is_IntermediateKeyWrapping() && (!a.dtor_kdf().is_HKDF() || !Objects.equals(a.dtor_edkWrapping().dtor_IntermediateKeyWrapping().dtor_keyEncryptionKeyKdf(), a.dtor_kdf()) || !Objects.equals(a.dtor_edkWrapping().dtor_IntermediateKeyWrapping().dtor_macKeyKdf(), a.dtor_kdf())) || a.dtor_kdf().is_HKDF() && a.dtor_commitment().is_None() && Integer.signum(a.dtor_kdf().dtor_HKDF().dtor_saltLength()) != 0 || !a.dtor_symmetricSignature().is_None() && !a.dtor_edkWrapping().is_IntermediateKeyWrapping());
    }

    public static boolean ESDKAlgorithmSuite_q(AlgorithmSuiteInfo a) {
        return __default.AlgorithmSuiteInfo_q(a) && __default.SupportedESDKEncrypt_q(a.dtor_encrypt()) && ((Function<ESDKAlgorithmSuiteId, Boolean>)_source13_boxed0 -> {
            ESDKAlgorithmSuiteId _source13 = _source13_boxed0;
            if (_source13.is_ALG__AES__128__GCM__IV12__TAG16__NO__KDF()) {
                return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{0, 20})) && a.dtor_messageVersion() == 1 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 16 && a.dtor_kdf().is_IDENTITY() && a.dtor_signature().is_None() && a.dtor_commitment().is_None() && a.dtor_symmetricSignature().is_None() && a.dtor_edkWrapping().is_DIRECT__KEY__WRAPPING();
            }
            if (_source13.is_ALG__AES__192__GCM__IV12__TAG16__NO__KDF()) {
                return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{0, 70})) && a.dtor_messageVersion() == 1 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 24 && a.dtor_kdf().is_IDENTITY() && a.dtor_signature().is_None() && a.dtor_commitment().is_None() && a.dtor_symmetricSignature().is_None() && a.dtor_edkWrapping().is_DIRECT__KEY__WRAPPING();
            }
            if (_source13.is_ALG__AES__256__GCM__IV12__TAG16__NO__KDF()) {
                return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{0, 120})) && a.dtor_messageVersion() == 1 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 32 && a.dtor_kdf().is_IDENTITY() && a.dtor_signature().is_None() && a.dtor_commitment().is_None() && a.dtor_symmetricSignature().is_None() && a.dtor_edkWrapping().is_DIRECT__KEY__WRAPPING();
            }
            if (_source13.is_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256()) {
                return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{1, 20})) && a.dtor_messageVersion() == 1 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 16 && a.dtor_kdf().is_HKDF() && Objects.equals(a.dtor_kdf().dtor_HKDF().dtor_hmac(), DigestAlgorithm.create_SHA__256()) && a.dtor_signature().is_None() && a.dtor_commitment().is_None() && a.dtor_symmetricSignature().is_None() && a.dtor_edkWrapping().is_DIRECT__KEY__WRAPPING();
            }
            if (_source13.is_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256()) {
                return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{1, 70})) && a.dtor_messageVersion() == 1 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 24 && a.dtor_kdf().is_HKDF() && Objects.equals(a.dtor_kdf().dtor_HKDF().dtor_hmac(), DigestAlgorithm.create_SHA__256()) && a.dtor_signature().is_None() && a.dtor_commitment().is_None() && a.dtor_symmetricSignature().is_None() && a.dtor_edkWrapping().is_DIRECT__KEY__WRAPPING();
            }
            if (_source13.is_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256()) {
                return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{1, 120})) && a.dtor_messageVersion() == 1 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 32 && a.dtor_kdf().is_HKDF() && Objects.equals(a.dtor_kdf().dtor_HKDF().dtor_hmac(), DigestAlgorithm.create_SHA__256()) && a.dtor_signature().is_None() && a.dtor_commitment().is_None() && a.dtor_symmetricSignature().is_None() && a.dtor_edkWrapping().is_DIRECT__KEY__WRAPPING();
            }
            if (_source13.is_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256()) {
                return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{2, 20})) && a.dtor_messageVersion() == 1 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 16 && a.dtor_kdf().is_HKDF() && Objects.equals(a.dtor_kdf().dtor_HKDF().dtor_hmac(), DigestAlgorithm.create_SHA__256()) && a.dtor_signature().is_ECDSA() && Objects.equals(a.dtor_signature().dtor_ECDSA().dtor_curve(), ECDSASignatureAlgorithm.create_ECDSA__P256()) && a.dtor_commitment().is_None() && a.dtor_symmetricSignature().is_None() && a.dtor_edkWrapping().is_DIRECT__KEY__WRAPPING();
            }
            if (_source13.is_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()) {
                return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{3, 70})) && a.dtor_messageVersion() == 1 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 24 && a.dtor_kdf().is_HKDF() && Objects.equals(a.dtor_kdf().dtor_HKDF().dtor_hmac(), DigestAlgorithm.create_SHA__384()) && a.dtor_signature().is_ECDSA() && Objects.equals(a.dtor_signature().dtor_ECDSA().dtor_curve(), ECDSASignatureAlgorithm.create_ECDSA__P384()) && a.dtor_commitment().is_None() && a.dtor_symmetricSignature().is_None() && a.dtor_edkWrapping().is_DIRECT__KEY__WRAPPING();
            }
            if (_source13.is_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()) {
                return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{3, 120})) && a.dtor_messageVersion() == 1 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 32 && a.dtor_kdf().is_HKDF() && Objects.equals(a.dtor_kdf().dtor_HKDF().dtor_hmac(), DigestAlgorithm.create_SHA__384()) && a.dtor_signature().is_ECDSA() && Objects.equals(a.dtor_signature().dtor_ECDSA().dtor_curve(), ECDSASignatureAlgorithm.create_ECDSA__P384()) && a.dtor_commitment().is_None() && a.dtor_symmetricSignature().is_None() && a.dtor_edkWrapping().is_DIRECT__KEY__WRAPPING();
            }
            if (_source13.is_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY()) {
                return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{4, 120})) && a.dtor_messageVersion() == 2 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 32 && a.dtor_kdf().is_HKDF() && Objects.equals(a.dtor_kdf().dtor_HKDF().dtor_hmac(), DigestAlgorithm.create_SHA__512()) && a.dtor_signature().is_None() && a.dtor_commitment().is_HKDF() && a.dtor_symmetricSignature().is_None() && a.dtor_edkWrapping().is_DIRECT__KEY__WRAPPING();
            }
            return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{5, 120})) && a.dtor_messageVersion() == 2 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 32 && a.dtor_kdf().is_HKDF() && Objects.equals(a.dtor_kdf().dtor_HKDF().dtor_hmac(), DigestAlgorithm.create_SHA__512()) && a.dtor_signature().is_ECDSA() && Objects.equals(a.dtor_signature().dtor_ECDSA().dtor_curve(), ECDSASignatureAlgorithm.create_ECDSA__P384()) && a.dtor_commitment().is_HKDF() && a.dtor_symmetricSignature().is_None() && a.dtor_edkWrapping().is_DIRECT__KEY__WRAPPING();
        }).apply(a.dtor_id().dtor_ESDK()) != false;
    }

    public static boolean DBEAlgorithmSuite_q(AlgorithmSuiteInfo a) {
        return __default.AlgorithmSuiteInfo_q(a) && __default.SupportedDBEEncrypt_q(a.dtor_encrypt()) && __default.SupportedDBEEDKWrapping_q(a.dtor_edkWrapping()) && ((Function<DBEAlgorithmSuiteId, Boolean>)_source14_boxed0 -> {
            DBEAlgorithmSuiteId _source14 = _source14_boxed0;
            if (_source14.is_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384()) {
                return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{103, 0})) && a.dtor_messageVersion() == 1 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 32 && a.dtor_kdf().is_HKDF() && Objects.equals(a.dtor_kdf().dtor_HKDF().dtor_hmac(), DigestAlgorithm.create_SHA__512()) && a.dtor_signature().is_None() && a.dtor_commitment().is_HKDF() && a.dtor_symmetricSignature().is_HMAC() && Objects.equals(a.dtor_symmetricSignature().dtor_HMAC(), DigestAlgorithm.create_SHA__384()) && a.dtor_edkWrapping().is_IntermediateKeyWrapping() && a.dtor_edkWrapping().dtor_IntermediateKeyWrapping().dtor_pdkEncryptAlgorithm().dtor_AES__GCM().dtor_keyLength() == 32;
            }
            return a.dtor_binaryId().equals((Object)DafnySequence.of((byte[])new byte[]{103, 1})) && a.dtor_messageVersion() == 1 && a.dtor_encrypt().dtor_AES__GCM().dtor_keyLength() == 32 && a.dtor_kdf().is_HKDF() && Objects.equals(a.dtor_kdf().dtor_HKDF().dtor_hmac(), DigestAlgorithm.create_SHA__512()) && a.dtor_signature().is_ECDSA() && Objects.equals(a.dtor_signature().dtor_ECDSA().dtor_curve(), ECDSASignatureAlgorithm.create_ECDSA__P384()) && a.dtor_commitment().is_HKDF() && a.dtor_symmetricSignature().is_HMAC() && Objects.equals(a.dtor_symmetricSignature().dtor_HMAC(), DigestAlgorithm.create_SHA__384()) && a.dtor_edkWrapping().is_IntermediateKeyWrapping() && a.dtor_edkWrapping().dtor_IntermediateKeyWrapping().dtor_pdkEncryptAlgorithm().dtor_AES__GCM().dtor_keyLength() == 32;
        }).apply(a.dtor_id().dtor_DBE()) != false;
    }

    public static boolean AlgorithmSuite_q(AlgorithmSuiteInfo a) {
        AlgorithmSuiteId _source15 = a.dtor_id();
        if (_source15.is_ESDK()) {
            ESDKAlgorithmSuiteId _353___mcc_h0 = ((AlgorithmSuiteId_ESDK)_source15)._ESDK;
            return __default.ESDKAlgorithmSuite_q(a);
        }
        DBEAlgorithmSuiteId _354___mcc_h1 = ((AlgorithmSuiteId_DBE)_source15)._DBE;
        return __default.DBEAlgorithmSuite_q(a);
    }

    public static DerivationAlgorithm HKDF__SHA__256(int keyLength) {
        return DerivationAlgorithm.create_HKDF(HKDF.create(DigestAlgorithm.create_SHA__256(), 0, keyLength, keyLength));
    }

    public static DerivationAlgorithm HKDF__SHA__384(int keyLength) {
        return DerivationAlgorithm.create_HKDF(HKDF.create(DigestAlgorithm.create_SHA__384(), 0, keyLength, keyLength));
    }

    public static DerivationAlgorithm HKDF__SHA__512(int keyLength) {
        return DerivationAlgorithm.create_HKDF(HKDF.create(DigestAlgorithm.create_SHA__512(), 32, keyLength, keyLength));
    }

    public static AlgorithmSuiteInfo GetSuite(AlgorithmSuiteId id) {
        DBEAlgorithmSuiteId _357___mcc_h1;
        AlgorithmSuiteId _source16 = id;
        if (_source16.is_ESDK()) {
            ESDKAlgorithmSuiteId _355___mcc_h0;
            ESDKAlgorithmSuiteId _356_e = _355___mcc_h0 = ((AlgorithmSuiteId_ESDK)_source16)._ESDK;
            return __default.GetESDKSuite(_356_e);
        }
        DBEAlgorithmSuiteId _358_e = _357___mcc_h1 = ((AlgorithmSuiteId_DBE)_source16)._DBE;
        return __default.GetDBESuite(_358_e);
    }

    public static AlgorithmSuiteInfo GetDBESuite(DBEAlgorithmSuiteId id) {
        return (AlgorithmSuiteInfo)__default.SupportedDBEAlgorithmSuites().get((Object)id);
    }

    public static AlgorithmSuiteInfo GetESDKSuite(ESDKAlgorithmSuiteId id) {
        return (AlgorithmSuiteInfo)__default.SupportedESDKAlgorithmSuites().get((Object)id);
    }

    public static int GetEncryptKeyLength(AlgorithmSuiteInfo a) {
        AES__GCM _359___mcc_h0;
        Encrypt _source17 = a.dtor_encrypt();
        AES__GCM _360_e = _359___mcc_h0 = _source17._AES__GCM;
        return _360_e.dtor_keyLength();
    }

    public static int GetEncryptTagLength(AlgorithmSuiteInfo a) {
        AES__GCM _361___mcc_h0;
        Encrypt _source18 = a.dtor_encrypt();
        AES__GCM _362_e = _361___mcc_h0 = _source18._AES__GCM;
        return _362_e.dtor_tagLength();
    }

    public static int GetEncryptIvLength(AlgorithmSuiteInfo a) {
        AES__GCM _363___mcc_h0;
        Encrypt _source19 = a.dtor_encrypt();
        AES__GCM _364_e = _363___mcc_h0 = _source19._AES__GCM;
        return _364_e.dtor_ivLength();
    }

    public static Result<AlgorithmSuiteInfo, Error> GetAlgorithmSuiteInfo(DafnySequence<? extends Byte> binaryId_q) {
        Outcome<Error> _365_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.AlgorithmSuiteInfoByBinaryId().contains(binaryId_q), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid BinaryId")));
        if (_365_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _365_valueOrError0.PropagateFailure(Error._typeDescriptor(), AlgorithmSuite._typeDescriptor());
        }
        return Result.create_Success((AlgorithmSuiteInfo)__default.AlgorithmSuiteInfoByBinaryId().get(binaryId_q));
    }

    public static int Bits128() {
        return 16;
    }

    public static int TagLen() {
        return 16;
    }

    public static int IvLen() {
        return 12;
    }

    public static Encrypt AES__128__GCM__IV12__TAG16() {
        return Encrypt.create(AES__GCM.create(__default.Bits128(), __default.TagLen(), __default.IvLen()));
    }

    public static int Bits192() {
        return 24;
    }

    public static Encrypt AES__192__GCM__IV12__TAG16() {
        return Encrypt.create(AES__GCM.create(__default.Bits192(), __default.TagLen(), __default.IvLen()));
    }

    public static int Bits256() {
        return 32;
    }

    public static Encrypt AES__256__GCM__IV12__TAG16() {
        return Encrypt.create(AES__GCM.create(__default.Bits256(), __default.TagLen(), __default.IvLen()));
    }

    public static EdkWrappingAlgorithm EDK__INTERMEDIATE__WRAPPING__AES__GCM__256__HKDF__SHA__512() {
        return EdkWrappingAlgorithm.create_IntermediateKeyWrapping(IntermediateKeyWrapping.create(__default.HKDF__SHA__512(__default.Bits256()), __default.HKDF__SHA__512(__default.Bits256()), __default.AES__256__GCM__IV12__TAG16()));
    }

    public static AlgorithmSuiteInfo DBE__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_DBE(DBEAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{103, 0}), 1, __default.AES__256__GCM__IV12__TAG16(), __default.HKDF__SHA__512(__default.Bits256()), __default.HKDF__SHA__512(__default.Bits256()), SignatureAlgorithm.create_None(None.create()), SymmetricSignatureAlgorithm.create_HMAC(DigestAlgorithm.create_SHA__384()), __default.EDK__INTERMEDIATE__WRAPPING__AES__GCM__256__HKDF__SHA__512());
    }

    public static AlgorithmSuiteInfo DBE__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384__SYMSIG__HMAC__SHA384() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_DBE(DBEAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384__SYMSIG__HMAC__SHA384()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{103, 1}), 1, __default.AES__256__GCM__IV12__TAG16(), __default.HKDF__SHA__512(__default.Bits256()), __default.HKDF__SHA__512(__default.Bits256()), SignatureAlgorithm.create_ECDSA(ECDSA.create(ECDSASignatureAlgorithm.create_ECDSA__P384())), SymmetricSignatureAlgorithm.create_HMAC(DigestAlgorithm.create_SHA__384()), __default.EDK__INTERMEDIATE__WRAPPING__AES__GCM__256__HKDF__SHA__512());
    }

    public static AlgorithmSuiteInfo ESDK__ALG__AES__128__GCM__IV12__TAG16__NO__KDF() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_ESDK(ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__NO__KDF()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{0, 20}), 1, __default.AES__128__GCM__IV12__TAG16(), DerivationAlgorithm.create_IDENTITY(IDENTITY.create()), DerivationAlgorithm.create_None(None.create()), SignatureAlgorithm.create_None(None.create()), SymmetricSignatureAlgorithm.create_None(None.create()), EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(DIRECT__KEY__WRAPPING.create()));
    }

    public static AlgorithmSuiteInfo ESDK__ALG__AES__192__GCM__IV12__TAG16__NO__KDF() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_ESDK(ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__NO__KDF()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{0, 70}), 1, __default.AES__192__GCM__IV12__TAG16(), DerivationAlgorithm.create_IDENTITY(IDENTITY.create()), DerivationAlgorithm.create_None(None.create()), SignatureAlgorithm.create_None(None.create()), SymmetricSignatureAlgorithm.create_None(None.create()), EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(DIRECT__KEY__WRAPPING.create()));
    }

    public static AlgorithmSuiteInfo ESDK__ALG__AES__256__GCM__IV12__TAG16__NO__KDF() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_ESDK(ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__NO__KDF()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{0, 120}), 1, __default.AES__256__GCM__IV12__TAG16(), DerivationAlgorithm.create_IDENTITY(IDENTITY.create()), DerivationAlgorithm.create_None(None.create()), SignatureAlgorithm.create_None(None.create()), SymmetricSignatureAlgorithm.create_None(None.create()), EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(DIRECT__KEY__WRAPPING.create()));
    }

    public static AlgorithmSuiteInfo ESDK__ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_ESDK(ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{1, 20}), 1, __default.AES__128__GCM__IV12__TAG16(), __default.HKDF__SHA__256(__default.Bits128()), DerivationAlgorithm.create_None(None.create()), SignatureAlgorithm.create_None(None.create()), SymmetricSignatureAlgorithm.create_None(None.create()), EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(DIRECT__KEY__WRAPPING.create()));
    }

    public static AlgorithmSuiteInfo ESDK__ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_ESDK(ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{1, 70}), 1, __default.AES__192__GCM__IV12__TAG16(), __default.HKDF__SHA__256(__default.Bits192()), DerivationAlgorithm.create_None(None.create()), SignatureAlgorithm.create_None(None.create()), SymmetricSignatureAlgorithm.create_None(None.create()), EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(DIRECT__KEY__WRAPPING.create()));
    }

    public static AlgorithmSuiteInfo ESDK__ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_ESDK(ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{1, 120}), 1, __default.AES__256__GCM__IV12__TAG16(), __default.HKDF__SHA__256(__default.Bits256()), DerivationAlgorithm.create_None(None.create()), SignatureAlgorithm.create_None(None.create()), SymmetricSignatureAlgorithm.create_None(None.create()), EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(DIRECT__KEY__WRAPPING.create()));
    }

    public static AlgorithmSuiteInfo ESDK__ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_ESDK(ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{2, 20}), 1, __default.AES__128__GCM__IV12__TAG16(), __default.HKDF__SHA__256(__default.Bits128()), DerivationAlgorithm.create_None(None.create()), SignatureAlgorithm.create_ECDSA(ECDSA.create(ECDSASignatureAlgorithm.create_ECDSA__P256())), SymmetricSignatureAlgorithm.create_None(None.create()), EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(DIRECT__KEY__WRAPPING.create()));
    }

    public static AlgorithmSuiteInfo ESDK__ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_ESDK(ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{3, 70}), 1, __default.AES__192__GCM__IV12__TAG16(), __default.HKDF__SHA__384(__default.Bits192()), DerivationAlgorithm.create_None(None.create()), SignatureAlgorithm.create_ECDSA(ECDSA.create(ECDSASignatureAlgorithm.create_ECDSA__P384())), SymmetricSignatureAlgorithm.create_None(None.create()), EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(DIRECT__KEY__WRAPPING.create()));
    }

    public static AlgorithmSuiteInfo ESDK__ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_ESDK(ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{3, 120}), 1, __default.AES__256__GCM__IV12__TAG16(), __default.HKDF__SHA__384(__default.Bits256()), DerivationAlgorithm.create_None(None.create()), SignatureAlgorithm.create_ECDSA(ECDSA.create(ECDSASignatureAlgorithm.create_ECDSA__P384())), SymmetricSignatureAlgorithm.create_None(None.create()), EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(DIRECT__KEY__WRAPPING.create()));
    }

    public static AlgorithmSuiteInfo ESDK__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_ESDK(ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{4, 120}), 2, __default.AES__256__GCM__IV12__TAG16(), __default.HKDF__SHA__512(__default.Bits256()), __default.HKDF__SHA__512(__default.Bits256()), SignatureAlgorithm.create_None(None.create()), SymmetricSignatureAlgorithm.create_None(None.create()), EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(DIRECT__KEY__WRAPPING.create()));
    }

    public static AlgorithmSuiteInfo ESDK__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384() {
        return AlgorithmSuiteInfo.create(AlgorithmSuiteId.create_ESDK(ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384()), (DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{5, 120}), 2, __default.AES__256__GCM__IV12__TAG16(), __default.HKDF__SHA__512(__default.Bits256()), __default.HKDF__SHA__512(__default.Bits256()), SignatureAlgorithm.create_ECDSA(ECDSA.create(ECDSASignatureAlgorithm.create_ECDSA__P384())), SymmetricSignatureAlgorithm.create_None(None.create()), EdkWrappingAlgorithm.create_DIRECT__KEY__WRAPPING(DIRECT__KEY__WRAPPING.create()));
    }

    public static DafnyMap<? extends ESDKAlgorithmSuiteId, ? extends AlgorithmSuiteInfo> SupportedESDKAlgorithmSuites() {
        return DafnyMap.fromElements((Tuple2[])new Tuple2[]{new Tuple2((Object)ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__NO__KDF(), (Object)__default.ESDK__ALG__AES__128__GCM__IV12__TAG16__NO__KDF()), new Tuple2((Object)ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__NO__KDF(), (Object)__default.ESDK__ALG__AES__192__GCM__IV12__TAG16__NO__KDF()), new Tuple2((Object)ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__NO__KDF(), (Object)__default.ESDK__ALG__AES__256__GCM__IV12__TAG16__NO__KDF()), new Tuple2((Object)ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256(), (Object)__default.ESDK__ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256()), new Tuple2((Object)ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256(), (Object)__default.ESDK__ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256()), new Tuple2((Object)ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256(), (Object)__default.ESDK__ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256()), new Tuple2((Object)ESDKAlgorithmSuiteId.create_ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256(), (Object)__default.ESDK__ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256()), new Tuple2((Object)ESDKAlgorithmSuiteId.create_ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384(), (Object)__default.ESDK__ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()), new Tuple2((Object)ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384(), (Object)__default.ESDK__ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()), new Tuple2((Object)ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY(), (Object)__default.ESDK__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY()), new Tuple2((Object)ESDKAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384(), (Object)__default.ESDK__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384())});
    }

    public static DafnyMap<? extends DBEAlgorithmSuiteId, ? extends AlgorithmSuiteInfo> SupportedDBEAlgorithmSuites() {
        return DafnyMap.fromElements((Tuple2[])new Tuple2[]{new Tuple2((Object)DBEAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384(), (Object)__default.DBE__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384()), new Tuple2((Object)DBEAlgorithmSuiteId.create_ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384__SYMSIG__HMAC__SHA384(), (Object)__default.DBE__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384__SYMSIG__HMAC__SHA384())});
    }

    public static DafnyMap<? extends DafnySequence<? extends Byte>, ? extends AlgorithmSuiteInfo> AlgorithmSuiteInfoByBinaryId() {
        return DafnyMap.fromElements((Tuple2[])new Tuple2[]{new Tuple2((Object)DafnySequence.of((byte[])new byte[]{0, 20}), (Object)__default.ESDK__ALG__AES__128__GCM__IV12__TAG16__NO__KDF()), new Tuple2((Object)DafnySequence.of((byte[])new byte[]{0, 70}), (Object)__default.ESDK__ALG__AES__192__GCM__IV12__TAG16__NO__KDF()), new Tuple2((Object)DafnySequence.of((byte[])new byte[]{0, 120}), (Object)__default.ESDK__ALG__AES__256__GCM__IV12__TAG16__NO__KDF()), new Tuple2((Object)DafnySequence.of((byte[])new byte[]{1, 20}), (Object)__default.ESDK__ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256()), new Tuple2((Object)DafnySequence.of((byte[])new byte[]{1, 70}), (Object)__default.ESDK__ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA256()), new Tuple2((Object)DafnySequence.of((byte[])new byte[]{1, 120}), (Object)__default.ESDK__ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA256()), new Tuple2((Object)DafnySequence.of((byte[])new byte[]{2, 20}), (Object)__default.ESDK__ALG__AES__128__GCM__IV12__TAG16__HKDF__SHA256__ECDSA__P256()), new Tuple2((Object)DafnySequence.of((byte[])new byte[]{3, 70}), (Object)__default.ESDK__ALG__AES__192__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()), new Tuple2((Object)DafnySequence.of((byte[])new byte[]{3, 120}), (Object)__default.ESDK__ALG__AES__256__GCM__IV12__TAG16__HKDF__SHA384__ECDSA__P384()), new Tuple2((Object)DafnySequence.of((byte[])new byte[]{4, 120}), (Object)__default.ESDK__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY()), new Tuple2((Object)DafnySequence.of((byte[])new byte[]{5, 120}), (Object)__default.ESDK__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384()), new Tuple2((Object)DafnySequence.of((byte[])new byte[]{103, 0}), (Object)__default.DBE__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__SYMSIG__HMAC__SHA384()), new Tuple2((Object)DafnySequence.of((byte[])new byte[]{103, 1}), (Object)__default.DBE__ALG__AES__256__GCM__HKDF__SHA512__COMMIT__KEY__ECDSA__P384__SYMSIG__HMAC__SHA384())});
    }

    public String toString() {
        return "AlgorithmSuites._default";
    }
}

