/*
 * Decompiled with CFR 0.152.
 */
package Signature;

import Dafny.Aws.Cryptography.Primitives.Types.InternalResult;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.model.AwsCryptographicPrimitivesError;

public enum SignatureAlgorithm {
    P256("secp256r1", DigestAlgorithm.create_SHA__256(), "NONEwithECDSA", 71),
    P384("secp384r1", DigestAlgorithm.create_SHA__384(), "NONEwithECDSA", 103);

    public final String curve;
    public final DigestAlgorithm messageDigestAlgorithm;
    public final String rawSignatureAlgorithm;
    public final short expectedSignatureLength;

    private SignatureAlgorithm(String curve, DigestAlgorithm messageDigestAlgorithm, String rawSignatureAlgorithm, short expectedSignatureLength) {
        this.curve = curve;
        this.messageDigestAlgorithm = messageDigestAlgorithm;
        this.rawSignatureAlgorithm = rawSignatureAlgorithm;
        this.expectedSignatureLength = expectedSignatureLength;
    }

    static InternalResult<SignatureAlgorithm, Error> signatureAlgorithm(ECDSASignatureAlgorithm dtor_signatureAlgorithm) {
        SignatureAlgorithm signatureAlgorithm;
        if (dtor_signatureAlgorithm.is_ECDSA__P256()) {
            signatureAlgorithm = P256;
        } else if (dtor_signatureAlgorithm.is_ECDSA__P384()) {
            signatureAlgorithm = P384;
        } else {
            return InternalResult.failure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Requested Curve is not supported. Requested %s.", dtor_signatureAlgorithm)).build()));
        }
        return InternalResult.success(signatureAlgorithm);
    }

    static ECParameterSpec ecParameterSpec(SignatureAlgorithm algorithm) throws NoSuchAlgorithmException, InvalidParameterSpecException {
        ECGenParameterSpec genParameterSpec = new ECGenParameterSpec(algorithm.curve);
        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
        parameters.init(genParameterSpec);
        return parameters.getParameterSpec(ECParameterSpec.class);
    }
}

