/*
 * Decompiled with CFR 0.152.
 */
package Signature;

import Dafny.Aws.Cryptography.Primitives.Types.InternalResult;
import Signature.SignatureAlgorithm;
import dafny.Array;
import dafny.DafnySequence;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.model.OpaqueError;

class PrivateKeyUtils {
    PrivateKeyUtils() {
    }

    static byte[] encodePrivateKey(ECPrivateKey privateKey) {
        return privateKey.getS().toByteArray();
    }

    static InternalResult<ECPrivateKey, Error> decodePrivateKey(SignatureAlgorithm algorithm, DafnySequence<? extends Byte> dtor_signingKey) {
        ECPrivateKey privateKey;
        try {
            ECParameterSpec ecParameterSpec = SignatureAlgorithm.ecParameterSpec(algorithm);
            byte[] keyAsBytes = (byte[])Array.unwrap((Array)dtor_signingKey.toArray());
            ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(new BigInteger(keyAsBytes), ecParameterSpec);
            privateKey = (ECPrivateKey)KeyFactory.getInstance("EC").generatePrivate(privateKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException e) {
            return InternalResult.failure(ToDafny.Error(OpaqueError.builder().obj(e).message(e.getMessage()).cause(e).build()));
        }
        return InternalResult.success(privateKey);
    }
}

