/*
 * Decompiled with CFR 0.152.
 */
package Signature;

import Dafny.Aws.Cryptography.Primitives.Types.InternalResult;
import Digest_Compile.ExternDigest;
import Random_Compile.ExternRandom;
import Signature.PrivateKeyUtils;
import Signature.PublicKeyUtils;
import Signature.SignUtils;
import Signature.SignatureAlgorithm;
import Signature.SignatureKeyPair;
import Signature._ExternBase___default;
import Wrappers_Compile.Result;
import dafny.Array;
import dafny.DafnySequence;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.model.AwsCryptographicPrimitivesError;
import software.amazon.cryptography.primitives.model.OpaqueError;

public class ECDSA
extends _ExternBase___default {
    static final String ELLIPTIC_CURVE_ALGORITHM = "EC";
    static final String SEC_PRIME_FIELD_PREFIX = "secp";
    static final String SEC_P256 = "256r1";
    static final String SEC_P384 = "384r1";
    static final BigInteger TWO = BigInteger.valueOf(2L);
    static final BigInteger THREE = BigInteger.valueOf(3L);
    static final BigInteger FOUR = BigInteger.valueOf(4L);

    public static Result<SignatureKeyPair, Error> ExternKeyGen(ECDSASignatureAlgorithm dtor_signatureAlgorithm) {
        KeyPairGenerator keyGen;
        InternalResult<SignatureAlgorithm, Error> maybeSignatureAlgorithm = SignatureAlgorithm.signatureAlgorithm(dtor_signatureAlgorithm);
        if (maybeSignatureAlgorithm.isFailure()) {
            return ECDSA.CreateExternKeyGenFailure(maybeSignatureAlgorithm.error());
        }
        ECGenParameterSpec genParameterSpec = new ECGenParameterSpec(maybeSignatureAlgorithm.value().curve);
        SecureRandom secureRandom = ExternRandom.getSecureRandom();
        try {
            keyGen = KeyPairGenerator.getInstance(ELLIPTIC_CURVE_ALGORITHM);
            keyGen.initialize(genParameterSpec, secureRandom);
        }
        catch (GeneralSecurityException e) {
            return ECDSA.CreateExternKeyGenFailure(ToDafny.Error(OpaqueError.builder().obj(e).message(e.getMessage()).cause(e).build()));
        }
        KeyPair keyPair = keyGen.generateKeyPair();
        byte[] verificationKey = PublicKeyUtils.encodeAndCompressPublicKey(keyPair.getPublic(), dtor_signatureAlgorithm);
        byte[] signingKey = PrivateKeyUtils.encodePrivateKey((ECPrivateKey)keyPair.getPrivate());
        return ECDSA.CreateExternKeyGenSuccess(SignatureKeyPair.create((DafnySequence<? extends Byte>)DafnySequence.fromBytes((byte[])verificationKey), (DafnySequence<? extends Byte>)DafnySequence.fromBytes((byte[])signingKey)));
    }

    public static Result<DafnySequence<? extends Byte>, Error> Sign(ECDSASignatureAlgorithm dtor_signatureAlgorithm, DafnySequence<? extends Byte> dtor_signingKey, DafnySequence<? extends Byte> dtor_message) {
        byte[] signatureBytes;
        Signature signatureCipher;
        InternalResult<SignatureAlgorithm, Error> maybeSignatureAlgorithm = SignatureAlgorithm.signatureAlgorithm(dtor_signatureAlgorithm);
        if (maybeSignatureAlgorithm.isFailure()) {
            return ECDSA.CreateSignFailure(maybeSignatureAlgorithm.error());
        }
        SignatureAlgorithm algorithm = maybeSignatureAlgorithm.value();
        try {
            signatureCipher = Signature.getInstance(algorithm.rawSignatureAlgorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            return ECDSA.CreateSignFailure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Requested Signature Algorithm is not supported. Requested %s.", algorithm.rawSignatureAlgorithm)).cause(ex).build()));
        }
        InternalResult<ECPrivateKey, Error> maybePrivateKey = PrivateKeyUtils.decodePrivateKey(algorithm, dtor_signingKey);
        if (maybePrivateKey.isFailure()) {
            return ECDSA.CreateSignFailure(maybePrivateKey.error());
        }
        ECPrivateKey privateKey = maybePrivateKey.value();
        InternalResult<byte[], Error> maybeDigest = ExternDigest.__default.internalDigest(algorithm.messageDigestAlgorithm, dtor_message);
        if (maybeDigest.isFailure()) {
            return ECDSA.CreateSignFailure(maybeDigest.error());
        }
        byte[] digest = maybeDigest.value();
        try {
            signatureCipher.initSign(privateKey, ExternRandom.getSecureRandom());
        }
        catch (InvalidKeyException ex) {
            return ECDSA.CreateSignFailure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Signature Cipher does not support provided key.Signature %sKey %s", signatureCipher, privateKey)).cause(ex).build()));
        }
        try {
            signatureBytes = SignUtils.generateEcdsaFixedLengthSignature(digest, signatureCipher, privateKey, algorithm.expectedSignatureLength);
        }
        catch (SignatureException e) {
            return ECDSA.CreateSignFailure(ToDafny.Error(OpaqueError.builder().obj(e).message(e.getMessage()).cause(e).build()));
        }
        return ECDSA.CreateSignSuccess((DafnySequence<? extends Byte>)DafnySequence.fromBytes((byte[])signatureBytes));
    }

    public static Result<Boolean, Error> Verify(ECDSASignatureAlgorithm dtor_signatureAlgorithm, DafnySequence<? extends Byte> dtor_verificationKey, DafnySequence<? extends Byte> dtor_message, DafnySequence<? extends Byte> dtor_signature) {
        boolean success;
        Signature signatureCipher;
        InternalResult<SignatureAlgorithm, Error> maybeSignatureAlgorithm = SignatureAlgorithm.signatureAlgorithm(dtor_signatureAlgorithm);
        if (maybeSignatureAlgorithm.isFailure()) {
            return ECDSA.CreateVerifyFailure(maybeSignatureAlgorithm.error());
        }
        SignatureAlgorithm algorithm = maybeSignatureAlgorithm.value();
        InternalResult<ECPublicKey, Error> maybePublicKey = PublicKeyUtils.decodePublicKey(algorithm, dtor_verificationKey);
        if (maybePublicKey.isFailure()) {
            return ECDSA.CreateVerifyFailure(maybePublicKey.error());
        }
        ECPublicKey publicKey = maybePublicKey.value();
        try {
            signatureCipher = Signature.getInstance(algorithm.rawSignatureAlgorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            return ECDSA.CreateVerifyFailure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Requested Signature Algorithm is not supported. Requested %s.", algorithm.rawSignatureAlgorithm)).cause(ex).build()));
        }
        try {
            signatureCipher.initVerify(publicKey);
        }
        catch (InvalidKeyException ex) {
            return ECDSA.CreateVerifyFailure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Signature does not support provided key.Signature %sKey %s", signatureCipher, publicKey)).cause(ex).build()));
        }
        InternalResult<byte[], Error> maybeDigest = ExternDigest.__default.internalDigest(algorithm.messageDigestAlgorithm, dtor_message);
        if (maybeDigest.isFailure()) {
            return ECDSA.CreateVerifyFailure(maybeDigest.error());
        }
        byte[] digest = maybeDigest.value();
        try {
            signatureCipher.update(digest);
        }
        catch (SignatureException ex) {
            throw new RuntimeException(ex);
        }
        try {
            byte[] signatureAsBytes = (byte[])Array.unwrap((Array)dtor_signature.toArray());
            success = signatureCipher.verify(signatureAsBytes);
        }
        catch (SignatureException ex) {
            return ECDSA.CreateVerifyFailure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Signature Cipher does not support provided key.Signature %sKey %s", signatureCipher, publicKey)).cause(ex).build()));
        }
        return ECDSA.CreateVerifySuccess(success);
    }
}

