/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsRsaKeyring_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsKmsRsaKeyring_Compile.DecryptSingleAWSRSAEncryptedDataKey;
import AwsKmsRsaKeyring_Compile.KmsRsaGenerateAndWrapKeyMaterial;
import AwsKmsRsaKeyring_Compile.KmsRsaWrapInfo;
import AwsKmsRsaKeyring_Compile.KmsRsaWrapKeyMaterial;
import AwsKmsRsaKeyring_Compile.__default;
import AwsKmsUtils_Compile.OnDecryptMrkAwareEncryptedDataKeyFilter;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsRsaKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public Option<IKMSClient> _client = Option.Default();
    public EncryptionAlgorithmSpec _paddingScheme = EncryptionAlgorithmSpec.Default();
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public Option<DafnySequence<? extends Byte>> _publicKey = Option.Default();
    public AwsKmsIdentifier _awsKmsArn = null;
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<AwsKmsRsaKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsRsaKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out181 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out181;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out182 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out182;
    }

    public void __ctor(Option<DafnySequence<? extends Byte>> publicKey, DafnySequence<? extends Character> awsKmsKey, EncryptionAlgorithmSpec paddingScheme, Option<IKMSClient> client, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _1042_parsedAwsKmsId = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(awsKmsKey);
        this._publicKey = publicKey;
        this._awsKmsKey = awsKmsKey;
        this._awsKmsArn = _1042_parsedAwsKmsId.dtor_value();
        this._paddingScheme = paddingScheme;
        this._client = client;
        this._cryptoPrimitives = cryptoPrimitives;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        Outcome<Object> _1043_valueOrError0 = Outcome.Default();
        _1043_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.publicKey().is_Some() && BigInteger.valueOf(this.publicKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())).length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A AwsKmsRsaKeyring without a public key cannot provide OnEncrypt")));
        if (_1043_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1043_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Object> _1044_valueOrError1 = Outcome.Default();
        _1044_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_algorithmSuite().dtor_signature().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"AwsKmsRsaKeyring cannot be used with an Algorithm Suite with asymmetric signing."), (DafnySequence)DafnySequence.asString((String)" Please specify an algorithm suite without asymmetric signing."))));
        if (_1044_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _1044_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        KmsRsaWrapKeyMaterial _nw39 = new KmsRsaWrapKeyMaterial();
        _nw39.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        KmsRsaWrapKeyMaterial _1045_wrap = _nw39;
        KmsRsaGenerateAndWrapKeyMaterial _nw40 = new KmsRsaGenerateAndWrapKeyMaterial();
        _nw40.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        KmsRsaGenerateAndWrapKeyMaterial _1046_generateAndWrap = _nw40;
        Result<WrapEdkMaterialOutput<KmsRsaWrapInfo>, Object> _1048_valueOrError2 = Result.Default(WrapEdkMaterialOutput.Default(KmsRsaWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<KmsRsaWrapInfo>, Error> _out183 = EdkWrapping_Compile.__default.WrapEdkMaterial(KmsRsaWrapInfo._typeDescriptor(), input.dtor_materials(), _1045_wrap, _1046_generateAndWrap);
        _1048_valueOrError2 = _out183;
        if (_1048_valueOrError2.IsFailure(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _1048_valueOrError2.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<KmsRsaWrapInfo> _1047_wrapOutput = _1048_valueOrError2.Extract(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _1049_symmetricSigningKeyList = _1047_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_1047_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _1050_edk = EncryptedDataKey.create(Constants_Compile.__default.RSA__PROVIDER__ID(), UTF8.__default.Encode(this.awsKmsKey()).dtor_value(), _1047_wrapOutput.dtor_wrappedMaterial());
        EncryptionMaterials _1051_returnMaterials = null;
        if (_1047_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1052_valueOrError3 = null;
            _1052_valueOrError3 = Materials_Compile.__default.EncryptionMaterialAddDataKey(input.dtor_materials(), _1047_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1050_edk}), _1049_symmetricSigningKeyList);
            if (_1052_valueOrError3.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _1052_valueOrError3.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _1051_returnMaterials = _1052_valueOrError3.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        } else if (_1047_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1053_valueOrError4 = null;
            _1053_valueOrError4 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(input.dtor_materials(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1050_edk}), _1049_symmetricSigningKeyList);
            if (_1053_valueOrError4.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _1053_valueOrError4.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _1051_returnMaterials = _1053_valueOrError4.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        }
        res = Result.create_Success(OnEncryptOutput.create(_1051_returnMaterials));
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out186;
        Result<OnDecryptOutput, Error> res = null;
        Outcome<Object> _1054_valueOrError0 = Outcome.Default();
        _1054_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.client().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"An AwsKmsRsaKeyring without an AWS KMS client cannot provide OnDecrypt")));
        if (_1054_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1054_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _1055_materials = input.dtor_materials();
        Outcome<Object> _1056_valueOrError1 = Outcome.Default();
        _1056_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_1055_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_1056_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _1056_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Object> _1057_valueOrError2 = Outcome.Default();
        _1057_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_algorithmSuite().dtor_signature().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"AwsKmsRsaKeyring cannot be used with an Algorithm Suite with asymmetric signing."), (DafnySequence)DafnySequence.asString((String)" Please specify an algorithm suite without asymmetric signing."))));
        if (_1057_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _1057_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        OnDecryptMrkAwareEncryptedDataKeyFilter _nw41 = new OnDecryptMrkAwareEncryptedDataKeyFilter();
        _nw41.__ctor(this.awsKmsArn(), Constants_Compile.__default.RSA__PROVIDER__ID());
        OnDecryptMrkAwareEncryptedDataKeyFilter _1058_filter = _nw41;
        Result<Object, Object> _1060_valueOrError3 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out184 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _1058_filter, input.dtor_encryptedDataKeys());
        _1060_valueOrError3 = _out184;
        if (_1060_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _1060_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _1059_edksToAttempt = (DafnySequence)_1060_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_1059_edksToAttempt.length()).signum() == 0) {
            Result<Object, Object> _1062_valueOrError4 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _1062_valueOrError4 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_1062_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _1062_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _1061_errorMessage = (DafnySequence)_1062_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_1061_errorMessage));
            return res;
        }
        Result<Object, Object> _1064_valueOrError5 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out185 = __default.EncryptionContextDigest(this.cryptoPrimitives(), _1055_materials.dtor_encryptionContext());
        _1064_valueOrError5 = _out185;
        if (_1064_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1064_valueOrError5.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _1063_encryptionContextDigest = (DafnySequence)_1064_valueOrError5.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        DecryptSingleAWSRSAEncryptedDataKey _nw42 = new DecryptSingleAWSRSAEncryptedDataKey();
        _nw42.__ctor(_1055_materials, this.client().dtor_value(), this.awsKmsKey(), this.paddingScheme(), (DafnySequence<? extends Byte>)_1063_encryptionContextDigest, this.grantTokens());
        DecryptSingleAWSRSAEncryptedDataKey _1065_decryptClosure = _nw42;
        Result<DecryptionMaterials, DafnySequence<Error>> _1066_outcome = _out186 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _1065_decryptClosure, _1059_edksToAttempt);
        Result<DecryptionMaterials, Error> _1068_valueOrError6 = null;
        _1068_valueOrError6 = _1066_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _1069_errors_boxed0 -> {
            DafnySequence _1069_errors = _1069_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_1069_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_1068_valueOrError6.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _1068_valueOrError6.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _1067_SealedDecryptionMaterials = _1068_valueOrError6.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_1067_SealedDecryptionMaterials));
        return res;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public Option<IKMSClient> client() {
        return this._client;
    }

    public EncryptionAlgorithmSpec paddingScheme() {
        return this._paddingScheme;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public Option<DafnySequence<? extends Byte>> publicKey() {
        return this._publicKey;
    }

    public AwsKmsIdentifier awsKmsArn() {
        return this._awsKmsArn;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<AwsKmsRsaKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsRsaKeyring.AwsKmsRsaKeyring";
    }
}

