/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsMrkKeyring_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsKmsKeyring_Compile.KmsGenerateAndWrapKeyMaterial;
import AwsKmsKeyring_Compile.KmsWrapInfo;
import AwsKmsKeyring_Compile.KmsWrapKeyMaterial;
import AwsKmsMrkKeyring_Compile.DecryptSingleEncryptedDataKey;
import AwsKmsUtils_Compile.OnDecryptMrkAwareEncryptedDataKeyFilter;
import BoundedInts_Compile.uint8;
import Constants_Compile.__default;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsMrkKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    public AwsKmsIdentifier _awsKmsArn = null;
    private static final TypeDescriptor<AwsKmsMrkKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsMrkKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out105 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out105;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out106 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out106;
    }

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _749_parsedAwsKmsId = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(awsKmsKey);
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._awsKmsArn = _749_parsedAwsKmsId.dtor_value();
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        EncryptionMaterials _750_materials = input.dtor_materials();
        AlgorithmSuiteInfo _751_suite = input.dtor_materials().dtor_algorithmSuite();
        Result<Object, Object> _753_valueOrError0 = Result.Default(DafnyMap.empty());
        _753_valueOrError0 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_materials().dtor_encryptionContext());
        if (_753_valueOrError0.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            output = _753_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        DafnyMap _752_stringifiedEncCtx = (DafnyMap)_753_valueOrError0.Extract((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        KmsGenerateAndWrapKeyMaterial _nw20 = new KmsGenerateAndWrapKeyMaterial();
        _nw20.__ctor(this.client(), this.awsKmsKey(), this.grantTokens());
        KmsGenerateAndWrapKeyMaterial _754_kmsGenerateAndWrap = _nw20;
        KmsWrapKeyMaterial _nw21 = new KmsWrapKeyMaterial();
        _nw21.__ctor(this.client(), this.awsKmsKey(), this.grantTokens());
        KmsWrapKeyMaterial _755_kmsWrap = _nw21;
        Result<WrapEdkMaterialOutput<KmsWrapInfo>, Object> _757_valueOrError1 = Result.Default(WrapEdkMaterialOutput.Default(KmsWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<KmsWrapInfo>, Error> _out107 = EdkWrapping_Compile.__default.WrapEdkMaterial(KmsWrapInfo._typeDescriptor(), _750_materials, _755_kmsWrap, _754_kmsGenerateAndWrap);
        _757_valueOrError1 = _out107;
        if (_757_valueOrError1.IsFailure(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            output = _757_valueOrError1.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        WrapEdkMaterialOutput<KmsWrapInfo> _756_wrapOutput = _757_valueOrError1.Extract(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor());
        DafnySequence<? extends Character> _758_kmsKeyArn = _756_wrapOutput.dtor_wrapInfo().dtor_kmsKeyArn();
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _759_symmetricSigningKeyList = _756_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_756_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        Result<DafnySequence<? extends Byte>, Object> _761_valueOrError2 = Result.Default(ValidUTF8Bytes.defaultValue());
        _761_valueOrError2 = UTF8.__default.Encode(_758_kmsKeyArn).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_761_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            output = _761_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence<? extends Byte> _760_providerInfo = _761_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _762_valueOrError3 = Outcome.Default();
        _762_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_760_providerInfo.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GenerateDataKey: Key ID too long.")));
        if (_762_valueOrError3.IsFailure(Error._typeDescriptor())) {
            output = _762_valueOrError3.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        EncryptedDataKey _763_edk = EncryptedDataKey.create(__default.PROVIDER__ID(), _760_providerInfo, _756_wrapOutput.dtor_wrappedMaterial());
        if (_756_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _765_valueOrError4 = null;
            _765_valueOrError4 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_750_materials, _756_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_763_edk}), _759_symmetricSigningKeyList);
            if (_765_valueOrError4.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _765_valueOrError4.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _764_result = _765_valueOrError4.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_764_result));
            return output;
        }
        if (_756_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _767_valueOrError5 = null;
            _767_valueOrError5 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_750_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_763_edk}), _759_symmetricSigningKeyList);
            if (_767_valueOrError5.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _767_valueOrError5.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _766_result = _767_valueOrError5.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_766_result));
            return output;
        }
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out109;
        Result<OnDecryptOutput, Error> output = null;
        DecryptionMaterials _768_materials = input.dtor_materials();
        AlgorithmSuiteInfo _769_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _770_valueOrError0 = Outcome.Default();
        _770_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_768_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_770_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _770_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        OnDecryptMrkAwareEncryptedDataKeyFilter _nw22 = new OnDecryptMrkAwareEncryptedDataKeyFilter();
        _nw22.__ctor(this.awsKmsArn(), __default.PROVIDER__ID());
        OnDecryptMrkAwareEncryptedDataKeyFilter _771_filter = _nw22;
        Result<Object, Object> _773_valueOrError1 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out108 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _771_filter, input.dtor_encryptedDataKeys());
        _773_valueOrError1 = _out108;
        if (_773_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            output = _773_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _772_edksToAttempt = (DafnySequence)_773_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_772_edksToAttempt.length()).signum() == 0) {
            Result<Object, Object> _775_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _775_valueOrError2 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_775_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                output = _775_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return output;
            }
            DafnySequence _774_errorMessage = (DafnySequence)_775_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            output = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_774_errorMessage));
            return output;
        }
        DecryptSingleEncryptedDataKey _nw23 = new DecryptSingleEncryptedDataKey();
        _nw23.__ctor(_768_materials, this.client(), this.awsKmsKey(), this.grantTokens());
        DecryptSingleEncryptedDataKey _776_decryptClosure = _nw23;
        Result<DecryptionMaterials, DafnySequence<Error>> _777_outcome = _out109 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _776_decryptClosure, _772_edksToAttempt);
        Result<DecryptionMaterials, Error> _779_valueOrError3 = null;
        _779_valueOrError3 = _777_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _780_errors_boxed0 -> {
            DafnySequence _780_errors = _780_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_780_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_779_valueOrError3.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            output = _779_valueOrError3.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DecryptionMaterials _778_SealedDecryptionMaterials = _779_valueOrError3.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        output = Result.create_Success(OnDecryptOutput.create(_778_SealedDecryptionMaterials));
        return output;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public AwsKmsIdentifier awsKmsArn() {
        return this._awsKmsArn;
    }

    public static TypeDescriptor<AwsKmsMrkKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsMrkKeyring.AwsKmsMrkKeyring";
    }
}

