/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsKeyring_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsKmsKeyring_Compile.DecryptSingleEncryptedDataKey;
import AwsKmsKeyring_Compile.KmsGenerateAndWrapKeyMaterial;
import AwsKmsKeyring_Compile.KmsWrapInfo;
import AwsKmsKeyring_Compile.KmsWrapKeyMaterial;
import AwsKmsKeyring_Compile.OnDecryptEncryptedDataKeyFilter;
import BoundedInts_Compile.uint8;
import Constants_Compile.__default;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    public AwsKmsIdentifier _awsKmsArn = null;
    private static final TypeDescriptor<AwsKmsKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out81 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out81;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out82 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out82;
    }

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _555_parsedAwsKmsId = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(awsKmsKey);
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._awsKmsArn = _555_parsedAwsKmsId.dtor_value();
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        EncryptionMaterials _556_materials = input.dtor_materials();
        AlgorithmSuiteInfo _557_suite = input.dtor_materials().dtor_algorithmSuite();
        Result<Object, Object> _559_valueOrError0 = Result.Default(DafnyMap.empty());
        _559_valueOrError0 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_materials().dtor_encryptionContext());
        if (_559_valueOrError0.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _559_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnyMap _558_stringifiedEncCtx = (DafnyMap)_559_valueOrError0.Extract((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        KmsGenerateAndWrapKeyMaterial _nw1 = new KmsGenerateAndWrapKeyMaterial();
        _nw1.__ctor(this.client(), this.awsKmsKey(), this.grantTokens());
        KmsGenerateAndWrapKeyMaterial _560_kmsGenerateAndWrap = _nw1;
        KmsWrapKeyMaterial _nw2 = new KmsWrapKeyMaterial();
        _nw2.__ctor(this.client(), this.awsKmsKey(), this.grantTokens());
        KmsWrapKeyMaterial _561_kmsWrap = _nw2;
        Result<WrapEdkMaterialOutput<KmsWrapInfo>, Object> _563_valueOrError1 = Result.Default(WrapEdkMaterialOutput.Default(KmsWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<KmsWrapInfo>, Error> _out83 = EdkWrapping_Compile.__default.WrapEdkMaterial(KmsWrapInfo._typeDescriptor(), _556_materials, _561_kmsWrap, _560_kmsGenerateAndWrap);
        _563_valueOrError1 = _out83;
        if (_563_valueOrError1.IsFailure(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _563_valueOrError1.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<KmsWrapInfo> _562_wrapOutput = _563_valueOrError1.Extract(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor());
        DafnySequence<? extends Character> _564_kmsKeyArn = _562_wrapOutput.dtor_wrapInfo().dtor_kmsKeyArn();
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _565_symmetricSigningKeyList = _562_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_562_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        Result<DafnySequence<? extends Byte>, Object> _567_valueOrError2 = Result.Default(ValidUTF8Bytes.defaultValue());
        _567_valueOrError2 = UTF8.__default.Encode(_564_kmsKeyArn).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_567_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            res = _567_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _566_providerInfo = _567_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _568_valueOrError3 = Outcome.Default();
        _568_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_566_providerInfo.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GenerateDataKey: Key ID too long.")));
        if (_568_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _568_valueOrError3.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        EncryptedDataKey _569_edk = EncryptedDataKey.create(__default.PROVIDER__ID(), _566_providerInfo, _562_wrapOutput.dtor_wrappedMaterial());
        if (_562_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _571_valueOrError4 = null;
            _571_valueOrError4 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_556_materials, _562_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_569_edk}), _565_symmetricSigningKeyList);
            if (_571_valueOrError4.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _571_valueOrError4.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _570_result = _571_valueOrError4.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_570_result));
            return res;
        }
        if (_562_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _573_valueOrError5 = null;
            _573_valueOrError5 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_556_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_569_edk}), _565_symmetricSigningKeyList);
            if (_573_valueOrError5.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _573_valueOrError5.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _572_result = _573_valueOrError5.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_572_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out85;
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _574_materials = input.dtor_materials();
        AlgorithmSuiteInfo _575_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _576_valueOrError0 = Outcome.Default();
        _576_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_574_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_576_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _576_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        OnDecryptEncryptedDataKeyFilter _nw3 = new OnDecryptEncryptedDataKeyFilter();
        _nw3.__ctor(this.awsKmsKey());
        OnDecryptEncryptedDataKeyFilter _577_filter = _nw3;
        Result<Object, Object> _579_valueOrError1 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out84 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _577_filter, input.dtor_encryptedDataKeys());
        _579_valueOrError1 = _out84;
        if (_579_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _579_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _578_edksToAttempt = (DafnySequence)_579_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_578_edksToAttempt.length()).signum() == 0) {
            Result<Object, Object> _581_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _581_valueOrError2 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_581_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _581_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _580_errorMessage = (DafnySequence)_581_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_580_errorMessage));
            return res;
        }
        DecryptSingleEncryptedDataKey _nw4 = new DecryptSingleEncryptedDataKey();
        _nw4.__ctor(_574_materials, this.client(), this.awsKmsKey(), this.grantTokens());
        DecryptSingleEncryptedDataKey _582_decryptClosure = _nw4;
        Result<DecryptionMaterials, DafnySequence<Error>> _583_outcome = _out85 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _582_decryptClosure, _578_edksToAttempt);
        Result<DecryptionMaterials, Error> _585_valueOrError3 = null;
        _585_valueOrError3 = _583_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _586_errors_boxed0 -> {
            DafnySequence _586_errors = _586_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_586_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_585_valueOrError3.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _585_valueOrError3.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _584_SealedDecryptionMaterials = _585_valueOrError3.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_584_SealedDecryptionMaterials));
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public AwsKmsIdentifier awsKmsArn() {
        return this._awsKmsArn;
    }

    public static TypeDescriptor<AwsKmsKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsKeyring.AwsKmsKeyring";
    }
}

