/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsDiscoveryKeyring_Compile;

import Actions_Compile.DeterministicAction;
import Actions_Compile.DeterministicActionWithResult;
import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsArn;
import Constants_Compile.AwsKmsEdkHelper;
import Constants_Compile.__default;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;

public class AwsKmsEncryptedDataKeyTransformer
implements DeterministicActionWithResult<EncryptedDataKey, DafnySequence<? extends AwsKmsEdkHelper>, Error>,
DeterministicAction<EncryptedDataKey, Result<DafnySequence<? extends AwsKmsEdkHelper>, Error>> {
    private static final TypeDescriptor<AwsKmsEncryptedDataKeyTransformer> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsEncryptedDataKeyTransformer.class, () -> null);

    public void __ctor() {
    }

    @Override
    public Result<DafnySequence<? extends AwsKmsEdkHelper>, Error> Invoke(EncryptedDataKey edk) {
        Result<DafnySequence<? extends AwsKmsEdkHelper>, Error> res = Result.Default(DafnySequence.empty(AwsKmsEdkHelper._typeDescriptor()));
        Outcome<Object> _650_valueOrError0 = Outcome.Default();
        _650_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), edk.dtor_keyProviderId().equals(__default.PROVIDER__ID()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encrypted data key was not generated by KMS")));
        if (_650_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _650_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()));
            return res;
        }
        Outcome<Object> _651_valueOrError1 = Outcome.Default();
        _651_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid AWS KMS encoding, provider info is not UTF8.")));
        if (_651_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _651_valueOrError1.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()));
            return res;
        }
        Result<Object, Object> _653_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _653_valueOrError2 = UTF8.__default.Decode(edk.dtor_keyProviderInfo()).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_653_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
            res = _653_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()));
            return res;
        }
        DafnySequence _652_keyId = (DafnySequence)_653_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        Result<AwsArn, Error> _655_valueOrError3 = null;
        _655_valueOrError3 = AwsArnParsing_Compile.__default.ParseAwsKmsArn((DafnySequence<? extends Character>)_652_keyId).MapFailure(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_655_valueOrError3.IsFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor())) {
            res = _655_valueOrError3.PropagateFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor(), DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()));
            return res;
        }
        AwsArn _654_arn = _655_valueOrError3.Extract(AwsKmsArn._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(DafnySequence.of(AwsKmsEdkHelper._typeDescriptor(), (Object[])new AwsKmsEdkHelper[]{AwsKmsEdkHelper.create(edk, _654_arn)}));
        return res;
    }

    public static TypeDescriptor<AwsKmsEncryptedDataKeyTransformer> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsDiscoveryKeyring.AwsKmsEncryptedDataKeyTransformer";
    }
}

