/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsRsaKeyring_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsKmsRsaKeyring_Compile.DecryptSingleAWSRSAEncryptedDataKey;
import AwsKmsRsaKeyring_Compile.KmsRsaGenerateAndWrapKeyMaterial;
import AwsKmsRsaKeyring_Compile.KmsRsaWrapInfo;
import AwsKmsRsaKeyring_Compile.KmsRsaWrapKeyMaterial;
import AwsKmsRsaKeyring_Compile.__default;
import AwsKmsUtils_Compile.OnDecryptMrkAwareEncryptedDataKeyFilter;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsRsaKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public Option<IKMSClient> _client = Option.Default(TypeDescriptor.reference(IKMSClient.class));
    public EncryptionAlgorithmSpec _paddingScheme = EncryptionAlgorithmSpec.Default();
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public Option<DafnySequence<? extends Byte>> _publicKey = Option.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()));
    public AwsKmsIdentifier _awsKmsArn = null;
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<AwsKmsRsaKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsRsaKeyring.class, () -> null);

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out7 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out7;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out7 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out7;
    }

    public void __ctor(Option<DafnySequence<? extends Byte>> publicKey, DafnySequence<? extends Character> awsKmsKey, EncryptionAlgorithmSpec paddingScheme, Option<IKMSClient> client, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _0_parsedAwsKmsId = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(awsKmsKey);
        this._publicKey = publicKey;
        this._awsKmsKey = awsKmsKey;
        this._awsKmsArn = _0_parsedAwsKmsId.dtor_value();
        this._paddingScheme = paddingScheme;
        this._client = client;
        this._cryptoPrimitives = cryptoPrimitives;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.publicKey().is_Some() && BigInteger.valueOf(this.publicKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())).length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A AwsKmsRsaKeyring without a public key cannot provide OnEncrypt")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Error> _1_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _1_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_algorithmSuite().dtor_signature().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"AwsKmsRsaKeyring cannot be used with an Algorithm Suite with asymmetric signing."), (DafnySequence)DafnySequence.asString((String)" Please specify an algorithm suite without asymmetric signing."))));
        if (_1_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _1_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        KmsRsaWrapKeyMaterial _nw0 = new KmsRsaWrapKeyMaterial();
        _nw0.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        KmsRsaWrapKeyMaterial _2_wrap = _nw0;
        KmsRsaGenerateAndWrapKeyMaterial _nw1 = new KmsRsaGenerateAndWrapKeyMaterial();
        _nw1.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        KmsRsaGenerateAndWrapKeyMaterial _3_generateAndWrap = _nw1;
        Result<WrapEdkMaterialOutput<KmsRsaWrapInfo>, Error> _4_valueOrError2 = Result.Default(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor(), WrapEdkMaterialOutput.Default(KmsRsaWrapInfo._typeDescriptor(), KmsRsaWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<KmsRsaWrapInfo>, Error> _out0 = EdkWrapping_Compile.__default.WrapEdkMaterial(KmsRsaWrapInfo._typeDescriptor(), input.dtor_materials(), _2_wrap, _3_generateAndWrap);
        _4_valueOrError2 = _out0;
        if (_4_valueOrError2.IsFailure(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _4_valueOrError2.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<KmsRsaWrapInfo> _5_wrapOutput = _4_valueOrError2.Extract(WrapEdkMaterialOutput._typeDescriptor(KmsRsaWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<Object> _6_symmetricSigningKeyList = _5_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())), DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_5_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())));
        EncryptedDataKey _7_edk = EncryptedDataKey.create(Constants_Compile.__default.RSA__PROVIDER__ID(), UTF8.__default.Encode(this.awsKmsKey()).dtor_value(), _5_wrapOutput.dtor_wrappedMaterial());
        EncryptionMaterials _8_returnMaterials = null;
        if (_5_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _9_valueOrError3 = null;
            _9_valueOrError3 = Materials_Compile.__default.EncryptionMaterialAddDataKey(input.dtor_materials(), _5_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_7_edk}), _6_symmetricSigningKeyList);
            if (_9_valueOrError3.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _9_valueOrError3.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _8_returnMaterials = _9_valueOrError3.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        } else if (_5_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _10_valueOrError4 = null;
            _10_valueOrError4 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(input.dtor_materials(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_7_edk}), _6_symmetricSigningKeyList);
            if (_10_valueOrError4.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _10_valueOrError4.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _8_returnMaterials = _10_valueOrError4.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        }
        res = Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput.create(_8_returnMaterials));
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out2;
        Result<OnDecryptOutput, Error> res = null;
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), this.client().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"An AwsKmsRsaKeyring without an AWS KMS client cannot provide OnDecrypt")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _1_materials = input.dtor_materials();
        Outcome<Error> _2_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _2_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_1_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_2_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _2_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Error> _3_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _3_valueOrError2 = AwsKmsUtils_Compile.__default.OkForDecrypt(this.awsKmsArn(), this.awsKmsKey());
        if (_3_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _3_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Error> _4_valueOrError3 = Outcome.Default(Error._typeDescriptor());
        _4_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_algorithmSuite().dtor_signature().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"AwsKmsRsaKeyring cannot be used with an Algorithm Suite with asymmetric signing."), (DafnySequence)DafnySequence.asString((String)" Please specify an algorithm suite without asymmetric signing."))));
        if (_4_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _4_valueOrError3.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        OnDecryptMrkAwareEncryptedDataKeyFilter _nw0 = new OnDecryptMrkAwareEncryptedDataKeyFilter();
        _nw0.__ctor(this.awsKmsArn(), Constants_Compile.__default.RSA__PROVIDER__ID());
        OnDecryptMrkAwareEncryptedDataKeyFilter _5_filter = _nw0;
        Result<DafnySequence, Error> _6_valueOrError4 = Result.Default(DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out0 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _5_filter, input.dtor_encryptedDataKeys());
        _6_valueOrError4 = _out0;
        if (_6_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _6_valueOrError4.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _7_edksToAttempt = _6_valueOrError4.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_7_edksToAttempt.length()).signum() == 0) {
            Result<DafnySequence, Error> _8_valueOrError5 = Result.Default(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _8_valueOrError5 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_8_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _8_valueOrError5.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _9_errorMessage = _8_valueOrError5.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_9_errorMessage));
            return res;
        }
        Result<DafnySequence, Error> _10_valueOrError6 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out1 = __default.EncryptionContextDigest(this.cryptoPrimitives(), _1_materials.dtor_encryptionContext());
        _10_valueOrError6 = _out1;
        if (_10_valueOrError6.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _10_valueOrError6.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _11_encryptionContextDigest = _10_valueOrError6.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        DecryptSingleAWSRSAEncryptedDataKey _nw1 = new DecryptSingleAWSRSAEncryptedDataKey();
        _nw1.__ctor(_1_materials, this.client().dtor_value(), this.awsKmsKey(), this.paddingScheme(), (DafnySequence<? extends Byte>)_11_encryptionContextDigest, this.grantTokens());
        DecryptSingleAWSRSAEncryptedDataKey _12_decryptClosure = _nw1;
        Result<DecryptionMaterials, DafnySequence<Error>> _13_outcome = _out2 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _12_decryptClosure, _7_edksToAttempt);
        Result<DecryptionMaterials, Error> _14_valueOrError7 = null;
        _14_valueOrError7 = _13_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _15_errors_boxed0 -> {
            DafnySequence _15_errors = _15_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_15_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_14_valueOrError7.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _14_valueOrError7.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _16_SealedDecryptionMaterials = _14_valueOrError7.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput.create(_16_SealedDecryptionMaterials));
        return res;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public Option<IKMSClient> client() {
        return this._client;
    }

    public EncryptionAlgorithmSpec paddingScheme() {
        return this._paddingScheme;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public Option<DafnySequence<? extends Byte>> publicKey() {
        return this._publicKey;
    }

    public AwsKmsIdentifier awsKmsArn() {
        return this._awsKmsArn;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<AwsKmsRsaKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsRsaKeyring.AwsKmsRsaKeyring";
    }
}

