/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.internaldafny.types;

import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;

public class ECDSA {
    public ECDSASignatureAlgorithm _curve;
    private static final ECDSA theDefault = ECDSA.create(ECDSASignatureAlgorithm.Default());
    private static final TypeDescriptor<ECDSA> _TYPE = TypeDescriptor.referenceWithInitializer(ECDSA.class, () -> ECDSA.Default());

    public ECDSA(ECDSASignatureAlgorithm curve) {
        this._curve = curve;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ECDSA o = (ECDSA)other;
        return Objects.equals(this._curve, o._curve);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._curve);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyMaterialProvidersTypes.ECDSA.ECDSA");
        s.append("(");
        s.append(Helpers.toString((Object)this._curve));
        s.append(")");
        return s.toString();
    }

    public static ECDSA Default() {
        return theDefault;
    }

    public static TypeDescriptor<ECDSA> _typeDescriptor() {
        return _TYPE;
    }

    public static ECDSA create(ECDSASignatureAlgorithm curve) {
        return new ECDSA(curve);
    }

    public static ECDSA create_ECDSA(ECDSASignatureAlgorithm curve) {
        return ECDSA.create(curve);
    }

    public boolean is_ECDSA() {
        return true;
    }

    public ECDSASignatureAlgorithm dtor_curve() {
        return this._curve;
    }
}

