/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;

public class HkdfExtractInput {
    public DigestAlgorithm _digestAlgorithm;
    public Option<DafnySequence<? extends Byte>> _salt;
    public DafnySequence<? extends Byte> _ikm;
    private static final HkdfExtractInput theDefault = HkdfExtractInput.create(DigestAlgorithm.Default(), Option.Default(), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
    private static final TypeDescriptor<HkdfExtractInput> _TYPE = TypeDescriptor.referenceWithInitializer(HkdfExtractInput.class, () -> HkdfExtractInput.Default());

    public HkdfExtractInput(DigestAlgorithm digestAlgorithm, Option<DafnySequence<? extends Byte>> salt, DafnySequence<? extends Byte> ikm) {
        this._digestAlgorithm = digestAlgorithm;
        this._salt = salt;
        this._ikm = ikm;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        HkdfExtractInput o = (HkdfExtractInput)other;
        return Objects.equals(this._digestAlgorithm, o._digestAlgorithm) && Objects.equals(this._salt, o._salt) && Objects.equals(this._ikm, o._ikm);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._digestAlgorithm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._salt);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._ikm);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("software.amazon.cryptography.primitives.internaldafny.types_Compile.HkdfExtractInput.HkdfExtractInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._digestAlgorithm));
        s.append(", ");
        s.append(Helpers.toString(this._salt));
        s.append(", ");
        s.append(Helpers.toString(this._ikm));
        s.append(")");
        return s.toString();
    }

    public static HkdfExtractInput Default() {
        return theDefault;
    }

    public static TypeDescriptor<HkdfExtractInput> _typeDescriptor() {
        return _TYPE;
    }

    public static HkdfExtractInput create(DigestAlgorithm digestAlgorithm, Option<DafnySequence<? extends Byte>> salt, DafnySequence<? extends Byte> ikm) {
        return new HkdfExtractInput(digestAlgorithm, salt, ikm);
    }

    public static HkdfExtractInput create_HkdfExtractInput(DigestAlgorithm digestAlgorithm, Option<DafnySequence<? extends Byte>> salt, DafnySequence<? extends Byte> ikm) {
        return HkdfExtractInput.create(digestAlgorithm, salt, ikm);
    }

    public boolean is_HkdfExtractInput() {
        return true;
    }

    public DigestAlgorithm dtor_digestAlgorithm() {
        return this._digestAlgorithm;
    }

    public Option<DafnySequence<? extends Byte>> dtor_salt() {
        return this._salt;
    }

    public DafnySequence<? extends Byte> dtor_ikm() {
        return this._ikm;
    }
}

