/*
 * Decompiled with CFR 0.152.
 */
package Utf8EncodingForm_Compile;

import Unicode_Compile.ScalarValue;
import Utf8EncodingForm_Compile.MinimalWellFormedCodeUnitSeq;
import Utf8EncodingForm_Compile.WellFormedCodeUnitSeq;
import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;

public class __default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static boolean IsMinimalWellFormedCodeUnitSubsequence(DafnySequence<? extends Byte> s) {
        if (Objects.equals(BigInteger.valueOf(s.length()), BigInteger.ONE)) {
            boolean _229_b = __default.IsWellFormedSingleCodeUnitSequence(s);
            return _229_b;
        }
        if (Objects.equals(BigInteger.valueOf(s.length()), BigInteger.valueOf(2L))) {
            boolean _230_b = __default.IsWellFormedDoubleCodeUnitSequence(s);
            return _230_b;
        }
        if (Objects.equals(BigInteger.valueOf(s.length()), BigInteger.valueOf(3L))) {
            boolean _231_b = __default.IsWellFormedTripleCodeUnitSequence(s);
            return _231_b;
        }
        if (Objects.equals(BigInteger.valueOf(s.length()), BigInteger.valueOf(4L))) {
            boolean _232_b = __default.IsWellFormedQuadrupleCodeUnitSequence(s);
            return _232_b;
        }
        return false;
    }

    public static boolean IsWellFormedSingleCodeUnitSequence(DafnySequence<? extends Byte> s) {
        byte _233_firstByte = (Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        return (_233_firstByte == 0 ? 0 : 1) != -1 && Integer.compareUnsigned(_233_firstByte, 127) <= 0;
    }

    public static boolean IsWellFormedDoubleCodeUnitSequence(DafnySequence<? extends Byte> s) {
        byte _234_firstByte = (Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        byte _235_secondByte = (Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ONE));
        return Integer.compareUnsigned(-62, _234_firstByte) <= 0 && Integer.compareUnsigned(_234_firstByte, -33) <= 0 && Integer.compareUnsigned(-128, _235_secondByte) <= 0 && Integer.compareUnsigned(_235_secondByte, -65) <= 0;
    }

    public static boolean IsWellFormedTripleCodeUnitSequence(DafnySequence<? extends Byte> s) {
        byte _236_firstByte = (Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        byte _237_secondByte = (Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ONE));
        byte _238_thirdByte = (Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)));
        return (_236_firstByte == -32 && Integer.compareUnsigned(-96, _237_secondByte) <= 0 && Integer.compareUnsigned(_237_secondByte, -65) <= 0 || Integer.compareUnsigned(-31, _236_firstByte) <= 0 && Integer.compareUnsigned(_236_firstByte, -20) <= 0 && Integer.compareUnsigned(-128, _237_secondByte) <= 0 && Integer.compareUnsigned(_237_secondByte, -65) <= 0 || _236_firstByte == -19 && Integer.compareUnsigned(-128, _237_secondByte) <= 0 && Integer.compareUnsigned(_237_secondByte, -97) <= 0 || Integer.compareUnsigned(-18, _236_firstByte) <= 0 && Integer.compareUnsigned(_236_firstByte, -17) <= 0 && Integer.compareUnsigned(-128, _237_secondByte) <= 0 && Integer.compareUnsigned(_237_secondByte, -65) <= 0) && Integer.compareUnsigned(-128, _238_thirdByte) <= 0 && Integer.compareUnsigned(_238_thirdByte, -65) <= 0;
    }

    public static boolean IsWellFormedQuadrupleCodeUnitSequence(DafnySequence<? extends Byte> s) {
        byte _239_firstByte = (Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        byte _240_secondByte = (Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ONE));
        byte _241_thirdByte = (Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)));
        byte _242_fourthByte = (Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L)));
        return (_239_firstByte == -16 && Integer.compareUnsigned(-112, _240_secondByte) <= 0 && Integer.compareUnsigned(_240_secondByte, -65) <= 0 || Integer.compareUnsigned(-15, _239_firstByte) <= 0 && Integer.compareUnsigned(_239_firstByte, -13) <= 0 && Integer.compareUnsigned(-128, _240_secondByte) <= 0 && Integer.compareUnsigned(_240_secondByte, -65) <= 0 || _239_firstByte == -12 && Integer.compareUnsigned(-128, _240_secondByte) <= 0 && Integer.compareUnsigned(_240_secondByte, -113) <= 0) && Integer.compareUnsigned(-128, _241_thirdByte) <= 0 && Integer.compareUnsigned(_241_thirdByte, -65) <= 0 && Integer.compareUnsigned(-128, _242_fourthByte) <= 0 && Integer.compareUnsigned(_242_fourthByte, -65) <= 0;
    }

    public static Option<DafnySequence<? extends Byte>> SplitPrefixMinimalWellFormedCodeUnitSubsequence(DafnySequence<? extends Byte> s) {
        if (BigInteger.valueOf(s.length()).compareTo(BigInteger.ONE) >= 0 && __default.IsWellFormedSingleCodeUnitSequence((DafnySequence<? extends Byte>)s.take(BigInteger.ONE))) {
            return Option.create_Some(s.take(BigInteger.ONE));
        }
        if (BigInteger.valueOf(s.length()).compareTo(BigInteger.valueOf(2L)) >= 0 && __default.IsWellFormedDoubleCodeUnitSequence((DafnySequence<? extends Byte>)s.take(BigInteger.valueOf(2L)))) {
            return Option.create_Some(s.take(BigInteger.valueOf(2L)));
        }
        if (BigInteger.valueOf(s.length()).compareTo(BigInteger.valueOf(3L)) >= 0 && __default.IsWellFormedTripleCodeUnitSequence((DafnySequence<? extends Byte>)s.take(BigInteger.valueOf(3L)))) {
            return Option.create_Some(s.take(BigInteger.valueOf(3L)));
        }
        if (BigInteger.valueOf(s.length()).compareTo(BigInteger.valueOf(4L)) >= 0 && __default.IsWellFormedQuadrupleCodeUnitSequence((DafnySequence<? extends Byte>)s.take(BigInteger.valueOf(4L)))) {
            return Option.create_Some(s.take(BigInteger.valueOf(4L)));
        }
        return Option.create_None();
    }

    public static DafnySequence<? extends Byte> EncodeScalarValue(int v) {
        if (Integer.compareUnsigned(v, 127) <= 0) {
            return __default.EncodeScalarValueSingleByte(v);
        }
        if (Integer.compareUnsigned(v, 2047) <= 0) {
            return __default.EncodeScalarValueDoubleByte(v);
        }
        if (Integer.compareUnsigned(v, 65535) <= 0) {
            return __default.EncodeScalarValueTripleByte(v);
        }
        return __default.EncodeScalarValueQuadrupleByte(v);
    }

    public static DafnySequence<? extends Byte> EncodeScalarValueSingleByte(int v) {
        byte _243_x;
        byte _244_firstByte = _243_x = (byte)(v & 0x7F);
        return DafnySequence.of((byte[])new byte[]{_244_firstByte});
    }

    public static DafnySequence<? extends Byte> EncodeScalarValueDoubleByte(int v) {
        byte _245_x = (byte)(v & 0x3F);
        byte _246_y = (byte)((v & 0x7C0) >>> 6);
        byte _247_firstByte = (byte)(0xFFFFFFC0 | _246_y);
        byte _248_secondByte = (byte)(0xFFFFFF80 | _245_x);
        return DafnySequence.of((byte[])new byte[]{_247_firstByte, _248_secondByte});
    }

    public static DafnySequence<? extends Byte> EncodeScalarValueTripleByte(int v) {
        byte _249_x = (byte)(v & 0x3F);
        byte _250_y = (byte)((v & 0xFC0) >>> 6);
        byte _251_z = (byte)((v & 0xF000) >>> 12);
        byte _252_firstByte = (byte)(0xFFFFFFE0 | _251_z);
        byte _253_secondByte = (byte)(0xFFFFFF80 | _250_y);
        byte _254_thirdByte = (byte)(0xFFFFFF80 | _249_x);
        return DafnySequence.of((byte[])new byte[]{_252_firstByte, _253_secondByte, _254_thirdByte});
    }

    public static DafnySequence<? extends Byte> EncodeScalarValueQuadrupleByte(int v) {
        byte _255_x = (byte)(v & 0x3F);
        byte _256_y = (byte)((v & 0xFC0) >>> 6);
        byte _257_z = (byte)((v & 0xF000) >>> 12);
        byte _258_u2 = (byte)((v & 0x30000) >>> 16);
        byte _259_u1 = (byte)((v & 0x1C0000) >>> 18);
        byte _260_firstByte = (byte)(0xFFFFFFF0 | _259_u1);
        byte _261_secondByte = (byte)((byte)(0xFFFFFF80 | (byte)(_258_u2 << 4)) | _257_z);
        byte _262_thirdByte = (byte)(0xFFFFFF80 | _256_y);
        byte _263_fourthByte = (byte)(0xFFFFFF80 | _255_x);
        return DafnySequence.of((byte[])new byte[]{_260_firstByte, _261_secondByte, _262_thirdByte, _263_fourthByte});
    }

    public static int DecodeMinimalWellFormedCodeUnitSubsequence(DafnySequence<? extends Byte> m) {
        if (Objects.equals(BigInteger.valueOf(m.length()), BigInteger.ONE)) {
            return __default.DecodeMinimalWellFormedCodeUnitSubsequenceSingleByte(m);
        }
        if (Objects.equals(BigInteger.valueOf(m.length()), BigInteger.valueOf(2L))) {
            return __default.DecodeMinimalWellFormedCodeUnitSubsequenceDoubleByte(m);
        }
        if (Objects.equals(BigInteger.valueOf(m.length()), BigInteger.valueOf(3L))) {
            return __default.DecodeMinimalWellFormedCodeUnitSubsequenceTripleByte(m);
        }
        return __default.DecodeMinimalWellFormedCodeUnitSubsequenceQuadrupleByte(m);
    }

    public static int DecodeMinimalWellFormedCodeUnitSubsequenceSingleByte(DafnySequence<? extends Byte> m) {
        byte _264_firstByte;
        byte _265_x = _264_firstByte = ((Byte)m.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).byteValue();
        return Byte.toUnsignedInt(_265_x);
    }

    public static int DecodeMinimalWellFormedCodeUnitSubsequenceDoubleByte(DafnySequence<? extends Byte> m) {
        byte _266_firstByte = (Byte)m.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        byte _267_secondByte = (Byte)m.select(Helpers.toInt((BigInteger)BigInteger.ONE));
        int _268_y = Byte.toUnsignedInt((byte)(_266_firstByte & 0x1F));
        int _269_x = Byte.toUnsignedInt((byte)(_267_secondByte & 0x3F));
        return _268_y << 6 & 0xFFFFFF | _269_x;
    }

    public static int DecodeMinimalWellFormedCodeUnitSubsequenceTripleByte(DafnySequence<? extends Byte> m) {
        byte _270_firstByte = (Byte)m.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        byte _271_secondByte = (Byte)m.select(Helpers.toInt((BigInteger)BigInteger.ONE));
        byte _272_thirdByte = (Byte)m.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)));
        int _273_z = Byte.toUnsignedInt((byte)(_270_firstByte & 0xF));
        int _274_y = Byte.toUnsignedInt((byte)(_271_secondByte & 0x3F));
        int _275_x = Byte.toUnsignedInt((byte)(_272_thirdByte & 0x3F));
        return _273_z << 12 & 0xFFFFFF | _274_y << 6 & 0xFFFFFF | _275_x;
    }

    public static int DecodeMinimalWellFormedCodeUnitSubsequenceQuadrupleByte(DafnySequence<? extends Byte> m) {
        byte _276_firstByte = (Byte)m.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        byte _277_secondByte = (Byte)m.select(Helpers.toInt((BigInteger)BigInteger.ONE));
        byte _278_thirdByte = (Byte)m.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)));
        byte _279_fourthByte = (Byte)m.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L)));
        int _280_u1 = Byte.toUnsignedInt((byte)(_276_firstByte & 7));
        int _281_u2 = Byte.toUnsignedInt((byte)Helpers.bv8ShiftRight((byte)((byte)(_277_secondByte & 0x30)), (byte)4));
        int _282_z = Byte.toUnsignedInt((byte)(_277_secondByte & 0xF));
        int _283_y = Byte.toUnsignedInt((byte)(_278_thirdByte & 0x3F));
        int _284_x = Byte.toUnsignedInt((byte)(_279_fourthByte & 0x3F));
        return _280_u1 << 18 & 0xFFFFFF | _281_u2 << 16 & 0xFFFFFF | _282_z << 12 & 0xFFFFFF | _283_y << 6 & 0xFFFFFF | _284_x;
    }

    public static Option<DafnySequence<? extends DafnySequence<? extends Byte>>> PartitionCodeUnitSequenceChecked(DafnySequence<? extends Byte> s) {
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> maybeParts = Option.Default();
        if (s.equals((Object)DafnySequence.empty((TypeDescriptor)TypeDescriptor.BYTE))) {
            maybeParts = Option.create_Some(DafnySequence.empty(MinimalWellFormedCodeUnitSeq._typeDescriptor()));
            return maybeParts;
        }
        DafnySequence _285_result = DafnySequence.empty(MinimalWellFormedCodeUnitSeq._typeDescriptor());
        DafnySequence _286_rest = s;
        while (BigInteger.valueOf(_286_rest.length()).signum() == 1) {
            Option<Object> _288_valueOrError0 = Option.Default();
            _288_valueOrError0 = __default.SplitPrefixMinimalWellFormedCodeUnitSubsequence(_286_rest);
            if (_288_valueOrError0.IsFailure(MinimalWellFormedCodeUnitSeq._typeDescriptor())) {
                maybeParts = _288_valueOrError0.PropagateFailure(MinimalWellFormedCodeUnitSeq._typeDescriptor(), DafnySequence._typeDescriptor(MinimalWellFormedCodeUnitSeq._typeDescriptor()));
                return maybeParts;
            }
            DafnySequence<? extends Byte> _287_prefix = _288_valueOrError0.Extract(MinimalWellFormedCodeUnitSeq._typeDescriptor());
            _285_result = DafnySequence.concatenate((DafnySequence)_285_result, (DafnySequence)DafnySequence.of(MinimalWellFormedCodeUnitSeq._typeDescriptor(), (Object[])new DafnySequence[]{_287_prefix}));
            _286_rest = _286_rest.drop(BigInteger.valueOf(_287_prefix.length()));
        }
        maybeParts = Option.create_Some(_285_result);
        return maybeParts;
    }

    public static DafnySequence<? extends DafnySequence<? extends Byte>> PartitionCodeUnitSequence(DafnySequence<? extends Byte> s) {
        return __default.PartitionCodeUnitSequenceChecked(s).Extract((TypeDescriptor<DafnySequence<? extends DafnySequence<? extends Byte>>>)DafnySequence._typeDescriptor(MinimalWellFormedCodeUnitSeq._typeDescriptor()));
    }

    public static boolean IsWellFormedCodeUnitSequence(DafnySequence<? extends Byte> s) {
        return __default.PartitionCodeUnitSequenceChecked(s).is_Some();
    }

    public static DafnySequence<? extends Byte> EncodeScalarSequence(DafnySequence<? extends Integer> vs) {
        DafnySequence s = WellFormedCodeUnitSeq.defaultValue();
        s = DafnySequence.empty((TypeDescriptor)TypeDescriptor.BYTE);
        BigInteger _lo1 = BigInteger.ZERO;
        BigInteger _289_i = BigInteger.valueOf(vs.length());
        while (_lo1.compareTo(_289_i) < 0) {
            _289_i = _289_i.subtract(BigInteger.ONE);
            DafnySequence<? extends Byte> _290_next = __default.EncodeScalarValue((Integer)vs.select(Helpers.toInt((BigInteger)_289_i)));
            s = DafnySequence.concatenate(_290_next, (DafnySequence)s);
        }
        return s;
    }

    public static DafnySequence<? extends Integer> DecodeCodeUnitSequence(DafnySequence<? extends Byte> s) {
        DafnySequence<? extends DafnySequence<? extends Byte>> _291_parts = __default.PartitionCodeUnitSequence(s);
        DafnySequence<Integer> _292_vs = Seq_Compile.__default.Map(MinimalWellFormedCodeUnitSeq._typeDescriptor(), ScalarValue._typeDescriptor(), __default::DecodeMinimalWellFormedCodeUnitSubsequence, _291_parts);
        return _292_vs;
    }

    public static Option<DafnySequence<? extends Integer>> DecodeCodeUnitSequenceChecked(DafnySequence<? extends Byte> s) {
        Option<DafnySequence<? extends Integer>> maybeVs = Option.Default();
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _293_maybeParts = __default.PartitionCodeUnitSequenceChecked(s);
        if (_293_maybeParts.is_None()) {
            maybeVs = Option.create_None();
            return maybeVs;
        }
        DafnySequence<? extends DafnySequence<? extends Byte>> _294_parts = _293_maybeParts.dtor_value();
        DafnySequence<Integer> _295_vs = Seq_Compile.__default.Map(MinimalWellFormedCodeUnitSeq._typeDescriptor(), ScalarValue._typeDescriptor(), __default::DecodeMinimalWellFormedCodeUnitSubsequence, _294_parts);
        maybeVs = Option.create_Some(_295_vs);
        return maybeVs;
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "Utf8EncodingForm_Compile._default";
    }
}

