/*
 * Decompiled with CFR 0.152.
 */
package Utf16EncodingForm_Compile;

import Unicode_Compile.ScalarValue;
import Utf16EncodingForm_Compile.MinimalWellFormedCodeUnitSeq;
import Utf16EncodingForm_Compile.WellFormedCodeUnitSeq;
import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;

public class __default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static boolean IsMinimalWellFormedCodeUnitSubsequence(DafnySequence<? extends Short> s) {
        if (Objects.equals(BigInteger.valueOf(s.length()), BigInteger.ONE)) {
            return __default.IsWellFormedSingleCodeUnitSequence(s);
        }
        if (Objects.equals(BigInteger.valueOf(s.length()), BigInteger.valueOf(2L))) {
            boolean _296_b = __default.IsWellFormedDoubleCodeUnitSequence(s);
            return _296_b;
        }
        return false;
    }

    public static boolean IsWellFormedSingleCodeUnitSequence(DafnySequence<? extends Short> s) {
        short _297_firstWord = (Short)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        return (_297_firstWord == 0 ? 0 : 1) != -1 && Integer.compareUnsigned(_297_firstWord, -10241) <= 0 || Integer.compareUnsigned(-8192, _297_firstWord) <= 0 && Integer.compareUnsigned(_297_firstWord, -1) <= 0;
    }

    public static boolean IsWellFormedDoubleCodeUnitSequence(DafnySequence<? extends Short> s) {
        short _298_firstWord = (Short)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        short _299_secondWord = (Short)s.select(Helpers.toInt((BigInteger)BigInteger.ONE));
        return Integer.compareUnsigned(-10240, _298_firstWord) <= 0 && Integer.compareUnsigned(_298_firstWord, -9217) <= 0 && Integer.compareUnsigned(-9216, _299_secondWord) <= 0 && Integer.compareUnsigned(_299_secondWord, -8193) <= 0;
    }

    public static Option<DafnySequence<? extends Short>> SplitPrefixMinimalWellFormedCodeUnitSubsequence(DafnySequence<? extends Short> s) {
        if (BigInteger.valueOf(s.length()).compareTo(BigInteger.ONE) >= 0 && __default.IsWellFormedSingleCodeUnitSequence((DafnySequence<? extends Short>)s.take(BigInteger.ONE))) {
            return Option.create_Some(s.take(BigInteger.ONE));
        }
        if (BigInteger.valueOf(s.length()).compareTo(BigInteger.valueOf(2L)) >= 0 && __default.IsWellFormedDoubleCodeUnitSequence((DafnySequence<? extends Short>)s.take(BigInteger.valueOf(2L)))) {
            return Option.create_Some(s.take(BigInteger.valueOf(2L)));
        }
        return Option.create_None();
    }

    public static DafnySequence<? extends Short> EncodeScalarValue(int v) {
        if ((v == 0 ? 0 : 1) != -1 && Integer.compareUnsigned(v, 55295) <= 0 || Integer.compareUnsigned(57344, v) <= 0 && Integer.compareUnsigned(v, 65535) <= 0) {
            return __default.EncodeScalarValueSingleWord(v);
        }
        return __default.EncodeScalarValueDoubleWord(v);
    }

    public static DafnySequence<? extends Short> EncodeScalarValueSingleWord(int v) {
        short _300_firstWord = (short)v;
        return DafnySequence.of((short[])new short[]{_300_firstWord});
    }

    public static DafnySequence<? extends Short> EncodeScalarValueDoubleWord(int v) {
        short _301_x2 = (short)(v & 0x3FF);
        byte _302_x1 = (byte)((v & 0xFC00) >>> 10);
        byte _303_u = (byte)((v & 0x1F0000) >>> 16);
        byte _304_w = (byte)((byte)(_303_u - 1) & 0x1F);
        short _305_firstWord = (short)((short)(0xFFFFD800 | (short)((short)Byte.toUnsignedInt(_304_w) << 6)) | (short)Byte.toUnsignedInt(_302_x1));
        short _306_secondWord = (short)(0xFFFFDC00 | _301_x2);
        return DafnySequence.of((short[])new short[]{_305_firstWord, _306_secondWord});
    }

    public static int DecodeMinimalWellFormedCodeUnitSubsequence(DafnySequence<? extends Short> m) {
        if (Objects.equals(BigInteger.valueOf(m.length()), BigInteger.ONE)) {
            return __default.DecodeMinimalWellFormedCodeUnitSubsequenceSingleWord(m);
        }
        return __default.DecodeMinimalWellFormedCodeUnitSubsequenceDoubleWord(m);
    }

    public static int DecodeMinimalWellFormedCodeUnitSubsequenceSingleWord(DafnySequence<? extends Short> m) {
        short _307_firstWord;
        short _308_x = _307_firstWord = ((Short)m.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).shortValue();
        return Short.toUnsignedInt(_308_x);
    }

    public static int DecodeMinimalWellFormedCodeUnitSubsequenceDoubleWord(DafnySequence<? extends Short> m) {
        short _309_firstWord = (Short)m.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        short _310_secondWord = (Short)m.select(Helpers.toInt((BigInteger)BigInteger.ONE));
        int _311_x2 = Short.toUnsignedInt((short)(_310_secondWord & 0x3FF));
        int _312_x1 = Short.toUnsignedInt((short)(_309_firstWord & 0x3F));
        int _313_w = Short.toUnsignedInt((short)Helpers.bv16ShiftRight((short)((short)(_309_firstWord & 0x3C0)), (byte)6));
        int _314_u = _313_w + 1 & 0xFFFFFF;
        int _315_v = _314_u << 16 & 0xFFFFFF | _312_x1 << 10 & 0xFFFFFF | _311_x2;
        return _315_v;
    }

    public static Option<DafnySequence<? extends DafnySequence<? extends Short>>> PartitionCodeUnitSequenceChecked(DafnySequence<? extends Short> s) {
        Option<DafnySequence<? extends DafnySequence<? extends Short>>> maybeParts = Option.Default();
        if (s.equals((Object)DafnySequence.empty((TypeDescriptor)TypeDescriptor.SHORT))) {
            maybeParts = Option.create_Some(DafnySequence.empty(MinimalWellFormedCodeUnitSeq._typeDescriptor()));
            return maybeParts;
        }
        DafnySequence _316_result = DafnySequence.empty(MinimalWellFormedCodeUnitSeq._typeDescriptor());
        DafnySequence _317_rest = s;
        while (BigInteger.valueOf(_317_rest.length()).signum() == 1) {
            Option<Object> _319_valueOrError0 = Option.Default();
            _319_valueOrError0 = __default.SplitPrefixMinimalWellFormedCodeUnitSubsequence(_317_rest);
            if (_319_valueOrError0.IsFailure(MinimalWellFormedCodeUnitSeq._typeDescriptor())) {
                maybeParts = _319_valueOrError0.PropagateFailure(MinimalWellFormedCodeUnitSeq._typeDescriptor(), DafnySequence._typeDescriptor(MinimalWellFormedCodeUnitSeq._typeDescriptor()));
                return maybeParts;
            }
            DafnySequence<? extends Short> _318_prefix = _319_valueOrError0.Extract(MinimalWellFormedCodeUnitSeq._typeDescriptor());
            _316_result = DafnySequence.concatenate((DafnySequence)_316_result, (DafnySequence)DafnySequence.of(MinimalWellFormedCodeUnitSeq._typeDescriptor(), (Object[])new DafnySequence[]{_318_prefix}));
            _317_rest = _317_rest.drop(BigInteger.valueOf(_318_prefix.length()));
        }
        maybeParts = Option.create_Some(_316_result);
        return maybeParts;
    }

    public static DafnySequence<? extends DafnySequence<? extends Short>> PartitionCodeUnitSequence(DafnySequence<? extends Short> s) {
        return __default.PartitionCodeUnitSequenceChecked(s).Extract((TypeDescriptor<DafnySequence<? extends DafnySequence<? extends Short>>>)DafnySequence._typeDescriptor(MinimalWellFormedCodeUnitSeq._typeDescriptor()));
    }

    public static boolean IsWellFormedCodeUnitSequence(DafnySequence<? extends Short> s) {
        return __default.PartitionCodeUnitSequenceChecked(s).is_Some();
    }

    public static DafnySequence<? extends Short> EncodeScalarSequence(DafnySequence<? extends Integer> vs) {
        DafnySequence s = WellFormedCodeUnitSeq.defaultValue();
        s = DafnySequence.empty((TypeDescriptor)TypeDescriptor.SHORT);
        BigInteger _lo2 = BigInteger.ZERO;
        BigInteger _320_i = BigInteger.valueOf(vs.length());
        while (_lo2.compareTo(_320_i) < 0) {
            _320_i = _320_i.subtract(BigInteger.ONE);
            DafnySequence<? extends Short> _321_next = __default.EncodeScalarValue((Integer)vs.select(Helpers.toInt((BigInteger)_320_i)));
            s = DafnySequence.concatenate(_321_next, (DafnySequence)s);
        }
        return s;
    }

    public static DafnySequence<? extends Integer> DecodeCodeUnitSequence(DafnySequence<? extends Short> s) {
        DafnySequence<? extends DafnySequence<? extends Short>> _322_parts = __default.PartitionCodeUnitSequence(s);
        DafnySequence<Integer> _323_vs = Seq_Compile.__default.Map(MinimalWellFormedCodeUnitSeq._typeDescriptor(), ScalarValue._typeDescriptor(), __default::DecodeMinimalWellFormedCodeUnitSubsequence, _322_parts);
        return _323_vs;
    }

    public static Option<DafnySequence<? extends Integer>> DecodeCodeUnitSequenceChecked(DafnySequence<? extends Short> s) {
        Option<DafnySequence<? extends Integer>> maybeVs = Option.Default();
        Option<DafnySequence<? extends DafnySequence<? extends Short>>> _324_maybeParts = __default.PartitionCodeUnitSequenceChecked(s);
        if (_324_maybeParts.is_None()) {
            maybeVs = Option.create_None();
            return maybeVs;
        }
        DafnySequence<? extends DafnySequence<? extends Short>> _325_parts = _324_maybeParts.dtor_value();
        DafnySequence<Integer> _326_vs = Seq_Compile.__default.Map(MinimalWellFormedCodeUnitSeq._typeDescriptor(), ScalarValue._typeDescriptor(), __default::DecodeMinimalWellFormedCodeUnitSubsequence, _325_parts);
        maybeVs = Option.create_Some(_326_vs);
        return maybeVs;
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "Utf16EncodingForm_Compile._default";
    }
}

