/*
 * Decompiled with CFR 0.152.
 */
package Signature;

import Digest_Compile.ExternDigest;
import Random_Compile.ExternRandom;
import Signature.PrivateKeyUtils;
import Signature.PublicKeyUtils;
import Signature.SignUtils;
import Signature.SignatureAlgorithm;
import Signature.SignatureKeyPair;
import Wrappers_Compile.Result;
import dafny.Array;
import dafny.DafnySequence;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.model.AwsCryptographicPrimitivesError;
import software.amazon.cryptography.primitives.model.OpaqueError;

public class ECDSA {
    static final String ELLIPTIC_CURVE_ALGORITHM = "EC";
    static final String SEC_PRIME_FIELD_PREFIX = "secp";
    static final String SEC_P256 = "256r1";
    static final String SEC_P384 = "384r1";
    static final BigInteger TWO = BigInteger.valueOf(2L);
    static final BigInteger THREE = BigInteger.valueOf(3L);
    static final BigInteger FOUR = BigInteger.valueOf(4L);

    public static Result<SignatureKeyPair, Error> ExternKeyGen(ECDSASignatureAlgorithm dtor_signatureAlgorithm) {
        KeyPairGenerator keyGen;
        Result<SignatureAlgorithm, Error> maybeSignatureAlgorithm = SignatureAlgorithm.signatureAlgorithm(dtor_signatureAlgorithm);
        if (maybeSignatureAlgorithm.is_Failure()) {
            return Result.create_Failure(maybeSignatureAlgorithm.dtor_error());
        }
        ECGenParameterSpec genParameterSpec = new ECGenParameterSpec(maybeSignatureAlgorithm.dtor_value().curve);
        SecureRandom secureRandom = ExternRandom.getSecureRandom();
        try {
            keyGen = KeyPairGenerator.getInstance(ELLIPTIC_CURVE_ALGORITHM);
            keyGen.initialize(genParameterSpec, secureRandom);
        }
        catch (GeneralSecurityException e) {
            return Result.create_Failure(ToDafny.Error(OpaqueError.builder().obj(e).message(e.getMessage()).cause(e).build()));
        }
        KeyPair keyPair = keyGen.generateKeyPair();
        byte[] verificationKey = PublicKeyUtils.encodeAndCompressPublicKey(keyPair.getPublic(), dtor_signatureAlgorithm);
        byte[] signingKey = PrivateKeyUtils.encodePrivateKey((ECPrivateKey)keyPair.getPrivate());
        return Result.create_Success(SignatureKeyPair.create((DafnySequence<? extends Byte>)DafnySequence.fromBytes((byte[])verificationKey), (DafnySequence<? extends Byte>)DafnySequence.fromBytes((byte[])signingKey)));
    }

    public static Result<DafnySequence<? extends Byte>, Error> Sign(ECDSASignatureAlgorithm dtor_signatureAlgorithm, DafnySequence<? extends Byte> dtor_signingKey, DafnySequence<? extends Byte> dtor_message) {
        byte[] signatureBytes;
        Signature signatureCipher;
        Result<SignatureAlgorithm, Error> maybeSignatureAlgorithm = SignatureAlgorithm.signatureAlgorithm(dtor_signatureAlgorithm);
        if (maybeSignatureAlgorithm.is_Failure()) {
            return Result.create_Failure(maybeSignatureAlgorithm.dtor_error());
        }
        SignatureAlgorithm algorithm = maybeSignatureAlgorithm.dtor_value();
        try {
            signatureCipher = Signature.getInstance(algorithm.rawSignatureAlgorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            return Result.create_Failure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Requested Signature Algorithm is not supported. Requested %s.", algorithm.rawSignatureAlgorithm)).cause(ex).build()));
        }
        Result<ECPrivateKey, Error> maybePrivateKey = PrivateKeyUtils.decodePrivateKey(algorithm, dtor_signingKey);
        if (maybePrivateKey.is_Failure()) {
            return Result.create_Failure(maybePrivateKey.dtor_error());
        }
        ECPrivateKey privateKey = maybePrivateKey.dtor_value();
        Result<byte[], Error> maybeDigest = ExternDigest.__default.internalDigest(algorithm.messageDigestAlgorithm, dtor_message);
        if (maybeDigest.is_Failure()) {
            return Result.create_Failure(maybeDigest.dtor_error());
        }
        byte[] digest = maybeDigest.dtor_value();
        try {
            signatureCipher.initSign(privateKey, ExternRandom.getSecureRandom());
        }
        catch (InvalidKeyException ex) {
            return Result.create_Failure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Signature Cipher does not support provided key.Signature %sKey %s", signatureCipher, privateKey)).cause(ex).build()));
        }
        try {
            signatureBytes = SignUtils.generateEcdsaFixedLengthSignature(digest, signatureCipher, privateKey, algorithm.expectedSignatureLength);
        }
        catch (SignatureException e) {
            return Result.create_Failure(ToDafny.Error(OpaqueError.builder().obj(e).message(e.getMessage()).cause(e).build()));
        }
        return Result.create_Success(DafnySequence.fromBytes((byte[])signatureBytes));
    }

    public static Result<Boolean, Error> Verify(ECDSASignatureAlgorithm dtor_signatureAlgorithm, DafnySequence<? extends Byte> dtor_verificationKey, DafnySequence<? extends Byte> dtor_message, DafnySequence<? extends Byte> dtor_signature) {
        boolean success;
        Signature signatureCipher;
        Result<SignatureAlgorithm, Error> maybeSignatureAlgorithm = SignatureAlgorithm.signatureAlgorithm(dtor_signatureAlgorithm);
        if (maybeSignatureAlgorithm.is_Failure()) {
            return Result.create_Failure(maybeSignatureAlgorithm.dtor_error());
        }
        SignatureAlgorithm algorithm = maybeSignatureAlgorithm.dtor_value();
        Result<ECPublicKey, Error> maybePublicKey = PublicKeyUtils.decodePublicKey(algorithm, dtor_verificationKey);
        if (maybePublicKey.is_Failure()) {
            return Result.create_Failure(maybePublicKey.dtor_error());
        }
        ECPublicKey publicKey = maybePublicKey.dtor_value();
        try {
            signatureCipher = Signature.getInstance(algorithm.rawSignatureAlgorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            return Result.create_Failure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Requested Signature Algorithm is not supported. Requested %s.", algorithm.rawSignatureAlgorithm)).cause(ex).build()));
        }
        try {
            signatureCipher.initVerify(publicKey);
        }
        catch (InvalidKeyException ex) {
            return Result.create_Failure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Signature does not support provided key.Signature %sKey %s", signatureCipher, publicKey)).cause(ex).build()));
        }
        Result<byte[], Error> maybeDigest = ExternDigest.__default.internalDigest(algorithm.messageDigestAlgorithm, dtor_message);
        if (maybeDigest.is_Failure()) {
            return Result.create_Failure(maybeDigest.dtor_error());
        }
        byte[] digest = maybeDigest.dtor_value();
        try {
            signatureCipher.update(digest);
        }
        catch (SignatureException ex) {
            throw new RuntimeException(ex);
        }
        try {
            byte[] signatureAsBytes = (byte[])Array.unwrap((Array)dtor_signature.toArray());
            success = signatureCipher.verify(signatureAsBytes);
        }
        catch (SignatureException ex) {
            return Result.create_Failure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Signature Cipher does not support provided key.Signature %sKey %s", signatureCipher, publicKey)).cause(ex).build()));
        }
        return Result.create_Success(success);
    }
}

