/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsDiscoveryKeyring_Compile;

import Actions_Compile.__default;
import AwsKmsDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyDecryptor;
import AwsKmsDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyFilter;
import AwsKmsDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyTransformer;
import Constants_Compile.AwsKmsEdkHelper;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.Result_Failure;
import Wrappers_Compile.Result_Success;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.DiscoveryFilter;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsDiscoveryKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public Option<DiscoveryFilter> _discoveryFilter = Option.Default();
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<AwsKmsDiscoveryKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsDiscoveryKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out48 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out48;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out49 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out49;
    }

    public void __ctor(IKMSClient client, Option<DiscoveryFilter> discoveryFilter, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._discoveryFilter = discoveryFilter;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        output = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption is not supported with a Discovery Keyring.")));
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out52;
        Result res = null;
        DecryptionMaterials _425_materials = input.dtor_materials();
        DafnySequence<? extends EncryptedDataKey> _426_encryptedDataKeys = input.dtor_encryptedDataKeys();
        AlgorithmSuiteInfo _427_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _428_valueOrError0 = Outcome.Default();
        _428_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_425_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_428_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _428_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        AwsKmsEncryptedDataKeyFilter _nw8 = new AwsKmsEncryptedDataKeyFilter();
        _nw8.__ctor(this.discoveryFilter());
        AwsKmsEncryptedDataKeyFilter _429_edkFilter = _nw8;
        Result<Object, Object> _431_valueOrError1 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out50 = __default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _429_edkFilter, _426_encryptedDataKeys);
        _431_valueOrError1 = _out50;
        if (_431_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _431_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _430_matchingEdks = (DafnySequence)_431_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        AwsKmsEncryptedDataKeyTransformer _nw9 = new AwsKmsEncryptedDataKeyTransformer();
        _nw9.__ctor();
        AwsKmsEncryptedDataKeyTransformer _432_edkTransform = _nw9;
        Result<Object, Object> _434_valueOrError2 = Result.Default(DafnySequence.empty(AwsKmsEdkHelper._typeDescriptor()));
        Result<DafnySequence<? extends AwsKmsEdkHelper>, Error> _out51 = __default.DeterministicFlatMapWithResult(EncryptedDataKey._typeDescriptor(), AwsKmsEdkHelper._typeDescriptor(), Error._typeDescriptor(), _432_edkTransform, _430_matchingEdks);
        _434_valueOrError2 = _out51;
        if (_434_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor())) {
            res = _434_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _433_edksToAttempt = (DafnySequence)_434_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor());
        Outcome<Object> _435_valueOrError3 = Outcome.Default();
        _435_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_433_edksToAttempt.length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to decrypt data key: No Encrypted Data Keys found to match.")));
        if (_435_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _435_valueOrError3.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        AwsKmsEncryptedDataKeyDecryptor _nw10 = new AwsKmsEncryptedDataKeyDecryptor();
        _nw10.__ctor(_425_materials, this.client(), this.grantTokens());
        AwsKmsEncryptedDataKeyDecryptor _436_decryptAction = _nw10;
        Result<DecryptionMaterials, DafnySequence<Error>> _437_outcome = _out52 = __default.ReduceToSuccess(AwsKmsEdkHelper._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _436_decryptAction, _433_edksToAttempt);
        res = ((Function<Result, Result>)_source20_boxed0 -> {
            Result _source20 = _source20_boxed0;
            if (_source20.is_Success()) {
                DecryptionMaterials _438___mcc_h0 = (DecryptionMaterials)((Result_Success)_source20)._value;
                return (Result)Helpers.Let((Object)_438___mcc_h0, boxed22 -> {
                    DecryptionMaterials _pat_let11_0 = boxed22;
                    return (Result)Helpers.Let((Object)_pat_let11_0, boxed23 -> {
                        DecryptionMaterials _439_mat = boxed23;
                        return Result.create_Success(OnDecryptOutput.create(_439_mat));
                    });
                });
            }
            DafnySequence _440___mcc_h1 = (DafnySequence)((Result_Failure)_source20)._error;
            return (Result)Helpers.Let((Object)_440___mcc_h1, boxed24 -> {
                DafnySequence _pat_let12_0 = boxed24;
                return (Result)Helpers.Let((Object)_pat_let12_0, boxed25 -> {
                    DafnySequence _441_errors = boxed25;
                    return Result.create_Failure(Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_441_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`.")));
                });
            });
        }).apply(_437_outcome);
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public Option<DiscoveryFilter> discoveryFilter() {
        return this._discoveryFilter;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<AwsKmsDiscoveryKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsDiscoveryKeyring_Compile.AwsKmsDiscoveryKeyring";
    }
}

