/*
 * Decompiled with CFR 0.152.
 */
package AwsArnParsing_Compile;

import AwsArnParsing_Compile.AmazonDynamodbResource;
import AwsArnParsing_Compile.AmazonDynamodbTableArn;
import AwsArnParsing_Compile.AmazonDynamodbTableName;
import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsArn;
import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsArnParsing_Compile.AwsKmsIdentifier_AwsKmsArnIdentifier;
import AwsArnParsing_Compile.AwsKmsIdentifier_AwsKmsRawResourceIdentifier;
import AwsArnParsing_Compile.AwsKmsResource;
import AwsArnParsing_Compile.AwsResource;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.Tuple2;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.TableName;

public class __default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static boolean ValidAwsKmsResource(AwsResource resource) {
        return resource.Valid() && (resource.dtor_resourceType().equals((Object)DafnySequence.asString((String)"key")) || resource.dtor_resourceType().equals((Object)DafnySequence.asString((String)"alias")));
    }

    public static boolean ValidAwsKmsArn(AwsArn arn) {
        return arn.Valid() && arn.dtor_service().equals((Object)DafnySequence.asString((String)"kms")) && __default.ValidAwsKmsResource(arn.dtor_resource());
    }

    public static Result<AwsResource, DafnySequence<? extends Character>> ParseAwsKmsRawResources(DafnySequence<? extends Character> identifier) {
        DafnySequence<DafnySequence<Character>> _99_info = StandardLibrary_Compile.__default.Split(TypeDescriptor.CHAR, identifier, Character.valueOf('/'));
        Outcome<DafnySequence> _100_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), !((DafnySequence)_99_info.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).equals((Object)DafnySequence.asString((String)"key")), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed raw key id: "), identifier));
        if (_100_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _100_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsResource._typeDescriptor());
        }
        if (Objects.equals(BigInteger.valueOf(_99_info.length()), BigInteger.ONE)) {
            return __default.ParseAwsKmsResources((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"key/"), identifier));
        }
        return __default.ParseAwsKmsResources(identifier);
    }

    public static Result<AwsResource, DafnySequence<? extends Character>> ParseAwsKmsResources(DafnySequence<? extends Character> identifier) {
        DafnySequence<DafnySequence<Character>> _101_info = StandardLibrary_Compile.__default.Split(TypeDescriptor.CHAR, identifier, Character.valueOf('/'));
        Outcome<DafnySequence> _102_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), BigInteger.valueOf(_101_info.length()).compareTo(BigInteger.ONE) > 0, DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed resource: "), identifier));
        if (_102_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _102_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        DafnySequence _103_resourceType = (DafnySequence)_101_info.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        DafnySequence _104_value = StandardLibrary_Compile.__default.Join(TypeDescriptor.CHAR, _101_info.drop(BigInteger.ONE), DafnySequence.asString((String)"/"));
        AwsResource _105_resource = AwsResource.create((DafnySequence<? extends Character>)_103_resourceType, _104_value);
        Outcome<DafnySequence> _106_valueOrError1 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.ValidAwsKmsResource(_105_resource), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed resource: "), identifier));
        if (_106_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _106_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        return Result.create_Success(_105_resource);
    }

    public static boolean ValidAmazonDynamodbResource(AwsResource resource) {
        return resource.Valid() && resource.dtor_resourceType().equals((Object)DafnySequence.asString((String)"table"));
    }

    public static boolean ValidAmazonDynamodbArn(AwsArn arn) {
        return arn.Valid() && arn.dtor_service().equals((Object)DafnySequence.asString((String)"dynamodb")) && __default.ValidAmazonDynamodbResource(arn.dtor_resource());
    }

    public static Result<AwsResource, DafnySequence<? extends Character>> ParseAmazonDynamodbResources(DafnySequence<? extends Character> identifier) {
        Option<Tuple2<DafnySequence<Character>, DafnySequence<Character>>> _107_info = StandardLibrary_Compile.__default.SplitOnce_q(TypeDescriptor.CHAR, identifier, Character.valueOf('/'));
        Outcome<DafnySequence> _108_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _107_info.is_Some(), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed resource: "), identifier));
        if (_108_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _108_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        DafnySequence _109_resourceType = (DafnySequence)_107_info.dtor_value().dtor__0();
        DafnySequence _110_value = (DafnySequence)_107_info.dtor_value().dtor__1();
        Outcome<DafnySequence> _111_valueOrError1 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__TableName((DafnySequence<? extends Character>)_110_value), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Table Name invalid: "), identifier));
        if (_111_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _111_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        AwsResource _112_resource = AwsResource.create((DafnySequence<? extends Character>)_109_resourceType, (DafnySequence<? extends Character>)_110_value);
        Outcome<DafnySequence> _113_valueOrError2 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.ValidAmazonDynamodbResource(_112_resource), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed resource: "), identifier));
        if (_113_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _113_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsResource._typeDescriptor());
        }
        return Result.create_Success(_112_resource);
    }

    public static Result<AwsArn, DafnySequence<? extends Character>> ParseAwsKmsArn(DafnySequence<? extends Character> identifier) {
        DafnySequence<DafnySequence<Character>> _114_components = StandardLibrary_Compile.__default.Split(TypeDescriptor.CHAR, identifier, Character.valueOf(':'));
        Outcome<DafnySequence> _115_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Objects.equals(BigInteger.valueOf(6L), BigInteger.valueOf(_114_components.length())), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed arn: "), identifier));
        if (_115_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _115_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        Result<AwsResource, DafnySequence<? extends Character>> _116_valueOrError1 = __default.ParseAwsKmsResources((DafnySequence<? extends Character>)((DafnySequence)_114_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(5L)))));
        if (_116_valueOrError1.IsFailure(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _116_valueOrError1.PropagateFailure(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        AwsResource _117_resource = _116_valueOrError1.Extract(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        AwsArn _118_arn = AwsArn.create((DafnySequence<? extends Character>)((DafnySequence)_114_components.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), (DafnySequence<? extends Character>)((DafnySequence)_114_components.select(Helpers.toInt((BigInteger)BigInteger.ONE))), (DafnySequence<? extends Character>)((DafnySequence)_114_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))), (DafnySequence<? extends Character>)((DafnySequence)_114_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L)))), (DafnySequence<? extends Character>)((DafnySequence)_114_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(4L)))), _117_resource);
        Outcome<DafnySequence> _119_valueOrError2 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.ValidAwsKmsArn(_118_arn), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed Arn:"), identifier));
        if (_119_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _119_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        return Result.create_Success(_118_arn);
    }

    public static Result<AwsArn, DafnySequence<? extends Character>> ParseAmazonDynamodbTableArn(DafnySequence<? extends Character> identifier) {
        DafnySequence<DafnySequence<Character>> _120_components = StandardLibrary_Compile.__default.Split(TypeDescriptor.CHAR, identifier, Character.valueOf(':'));
        Outcome<DafnySequence> _121_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Objects.equals(BigInteger.valueOf(6L), BigInteger.valueOf(_120_components.length())), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed arn: "), identifier));
        if (_121_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _121_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        Result<AwsResource, DafnySequence<? extends Character>> _122_valueOrError1 = __default.ParseAmazonDynamodbResources((DafnySequence<? extends Character>)((DafnySequence)_120_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(5L)))));
        if (_122_valueOrError1.IsFailure(AmazonDynamodbResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _122_valueOrError1.PropagateFailure(AmazonDynamodbResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        AwsResource _123_resource = _122_valueOrError1.Extract(AmazonDynamodbResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        AwsArn _124_arn = AwsArn.create((DafnySequence<? extends Character>)((DafnySequence)_120_components.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), (DafnySequence<? extends Character>)((DafnySequence)_120_components.select(Helpers.toInt((BigInteger)BigInteger.ONE))), (DafnySequence<? extends Character>)((DafnySequence)_120_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))), (DafnySequence<? extends Character>)((DafnySequence)_120_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L)))), (DafnySequence<? extends Character>)((DafnySequence)_120_components.select(Helpers.toInt((BigInteger)BigInteger.valueOf(4L)))), _123_resource);
        Outcome<DafnySequence> _125_valueOrError2 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.ValidAmazonDynamodbArn(_124_arn), DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Malformed Arn:"), identifier));
        if (_125_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _125_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsArn._typeDescriptor());
        }
        return Result.create_Success(_124_arn);
    }

    public static Result<AwsKmsIdentifier, DafnySequence<? extends Character>> ParseAwsKmsIdentifier(DafnySequence<? extends Character> identifier) {
        if (DafnySequence.asString((String)"arn:").isPrefixOf(identifier)) {
            Result<AwsArn, DafnySequence<? extends Character>> _126_valueOrError0 = __default.ParseAwsKmsArn(identifier);
            if (_126_valueOrError0.IsFailure(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                return _126_valueOrError0.PropagateFailure(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
            }
            AwsArn _127_arn = _126_valueOrError0.Extract(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            return Result.create_Success(AwsKmsIdentifier.create_AwsKmsArnIdentifier(_127_arn));
        }
        Result<AwsResource, DafnySequence<? extends Character>> _128_valueOrError1 = __default.ParseAwsKmsRawResources(identifier);
        if (_128_valueOrError1.IsFailure(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _128_valueOrError1.PropagateFailure(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
        }
        AwsResource _129_r = _128_valueOrError1.Extract(AwsKmsResource._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        return Result.create_Success(AwsKmsIdentifier.create_AwsKmsRawResourceIdentifier(_129_r));
    }

    public static Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> ParseAmazonDynamodbTableName(DafnySequence<? extends Character> identifier) {
        Result<AwsArn, DafnySequence<? extends Character>> _130_valueOrError0 = __default.ParseAmazonDynamodbTableArn(identifier);
        if (_130_valueOrError0.IsFailure(AmazonDynamodbTableArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _130_valueOrError0.PropagateFailure(AmazonDynamodbTableArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        AwsArn _131_arn = _130_valueOrError0.Extract(AmazonDynamodbTableArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        AmazonDynamodbTableName _132_tableArn = AmazonDynamodbTableName.create(_131_arn);
        DafnySequence<? extends Character> _133_tableName = _132_tableArn.GetTableName();
        return Result.create_Success(_133_tableName);
    }

    public static boolean IsMultiRegionAwsKmsArn(AwsArn arn) {
        return __default.IsMultiRegionAwsKmsResource(arn.dtor_resource());
    }

    public static boolean IsMultiRegionAwsKmsIdentifier(AwsKmsIdentifier identifier) {
        AwsResource _136___mcc_h1;
        AwsKmsIdentifier _source11 = identifier;
        if (_source11.is_AwsKmsArnIdentifier()) {
            AwsArn _134___mcc_h0;
            AwsArn _135_arn = _134___mcc_h0 = ((AwsKmsIdentifier_AwsKmsArnIdentifier)_source11)._a;
            return __default.IsMultiRegionAwsKmsArn(_135_arn);
        }
        AwsResource _137_r = _136___mcc_h1 = ((AwsKmsIdentifier_AwsKmsRawResourceIdentifier)_source11)._r;
        return __default.IsMultiRegionAwsKmsResource(_137_r);
    }

    public static boolean IsMultiRegionAwsKmsResource(AwsResource resource) {
        return resource.dtor_resourceType().equals((Object)DafnySequence.asString((String)"key")) && DafnySequence.asString((String)"mrk-").isPrefixOf(resource.dtor_value());
    }

    public static Option<DafnySequence<? extends Character>> GetRegion(AwsKmsIdentifier identifier) {
        AwsKmsIdentifier _source12 = identifier;
        if (_source12.is_AwsKmsArnIdentifier()) {
            AwsArn _138___mcc_h0;
            AwsArn _139_a = _138___mcc_h0 = ((AwsKmsIdentifier_AwsKmsArnIdentifier)_source12)._a;
            return Option.create_Some(_139_a.dtor_region());
        }
        AwsResource _140___mcc_h1 = ((AwsKmsIdentifier_AwsKmsRawResourceIdentifier)_source12)._r;
        return Option.create_None();
    }

    public static Result<AwsKmsIdentifier, DafnySequence<? extends Character>> IsAwsKmsIdentifierString(DafnySequence<? extends Character> s) {
        Outcome<DafnySequence> _141_valueOrError0 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), UTF8.__default.IsASCIIString(s), DafnySequence.asString((String)"Not a valid ASCII string."));
        if (_141_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _141_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
        }
        Outcome<DafnySequence> _142_valueOrError1 = Wrappers_Compile.__default.Need(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), BigInteger.valueOf(s.length()).signum() == 1 && BigInteger.valueOf(s.length()).compareTo(__default.MAX__AWS__KMS__IDENTIFIER__LENGTH()) <= 0, DafnySequence.asString((String)"Identifier exceeds maximum length."));
        if (_142_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _142_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), AwsKmsIdentifier._typeDescriptor());
        }
        return __default.ParseAwsKmsIdentifier(s);
    }

    public static Error Error(DafnySequence<? extends Character> s) {
        return Error.create_AwsCryptographicMaterialProvidersException(s);
    }

    public static Result<Tuple0, Error> ValidateDdbTableArn(DafnySequence<? extends Character> tableArn) {
        Result<DafnySequence<? extends Character>, Error> _143_valueOrError0 = __default.ParseAmazonDynamodbTableName(tableArn).MapFailure(TableName._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::Error);
        if (_143_valueOrError0.IsFailure(TableName._typeDescriptor(), Error._typeDescriptor())) {
            return _143_valueOrError0.PropagateFailure(TableName._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        DafnySequence<? extends Character> _144___v1 = _143_valueOrError0.Extract(TableName._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _145_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), UTF8.__default.IsASCIIString(tableArn), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Table Arn is not ASCII")));
        if (_145_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _145_valueOrError1.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        Outcome<Error> _146_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__TableName(__default.ParseAmazonDynamodbTableName(tableArn).dtor_value()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Table Name is too long")));
        if (_146_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _146_valueOrError2.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        return Result.create_Success(Tuple0.create());
    }

    public static BigInteger MAX__AWS__KMS__IDENTIFIER__LENGTH() {
        return BigInteger.valueOf(2048L);
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsArnParsing_Compile._default";
    }
}

