/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives;

import Wrappers_Compile.Result;
import dafny.DafnySequence;
import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.ToNative;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.__default;
import software.amazon.cryptography.primitives.internaldafny.types.AESDecryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.AESEncryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.CryptoConfig;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSAVerifyInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateRSAKeyPairInput;
import software.amazon.cryptography.primitives.internaldafny.types.HMacInput;
import software.amazon.cryptography.primitives.internaldafny.types.HkdfExtractInput;
import software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.RSADecryptInput;
import software.amazon.cryptography.primitives.model.AESEncryptOutput;
import software.amazon.cryptography.primitives.model.AesKdfCtrInput;
import software.amazon.cryptography.primitives.model.ECDSASignInput;
import software.amazon.cryptography.primitives.model.GenerateECDSASignatureKeyInput;
import software.amazon.cryptography.primitives.model.GenerateRSAKeyPairOutput;
import software.amazon.cryptography.primitives.model.GenerateRandomBytesInput;
import software.amazon.cryptography.primitives.model.GetRSAKeyModulusLengthInput;
import software.amazon.cryptography.primitives.model.GetRSAKeyModulusLengthOutput;
import software.amazon.cryptography.primitives.model.HkdfExpandInput;
import software.amazon.cryptography.primitives.model.HkdfInput;
import software.amazon.cryptography.primitives.model.KdfCtrInput;
import software.amazon.cryptography.primitives.model.RSAEncryptInput;
import software.amazon.smithy.dafny.conversion.ToNative;

public class AtomicPrimitives {
    private final IAwsCryptographicPrimitivesClient _impl;

    protected AtomicPrimitives(BuilderImpl builder) {
        software.amazon.cryptography.primitives.model.CryptoConfig nativeValue = builder.CryptoConfig();
        CryptoConfig dafnyValue = ToDafny.CryptoConfig(nativeValue);
        Result<AtomicPrimitivesClient, Error> result = __default.AtomicPrimitives(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        this._impl = result.dtor_value();
    }

    AtomicPrimitives(IAwsCryptographicPrimitivesClient impl) {
        this._impl = impl;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public ByteBuffer AESDecrypt(software.amazon.cryptography.primitives.model.AESDecryptInput nativeValue) {
        AESDecryptInput dafnyValue = ToDafny.AESDecryptInput(nativeValue);
        Result<DafnySequence<? extends Byte>, Error> result = this._impl.AESDecrypt(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.Simple.ByteBuffer(result.dtor_value());
    }

    public AESEncryptOutput AESEncrypt(software.amazon.cryptography.primitives.model.AESEncryptInput nativeValue) {
        AESEncryptInput dafnyValue = ToDafny.AESEncryptInput(nativeValue);
        Result<software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput, Error> result = this._impl.AESEncrypt(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.AESEncryptOutput(result.dtor_value());
    }

    public ByteBuffer AesKdfCounterMode(AesKdfCtrInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.AesKdfCtrInput dafnyValue = ToDafny.AesKdfCtrInput(nativeValue);
        Result<DafnySequence<? extends Byte>, Error> result = this._impl.AesKdfCounterMode(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.Simple.ByteBuffer(result.dtor_value());
    }

    public ByteBuffer Digest(software.amazon.cryptography.primitives.model.DigestInput nativeValue) {
        DigestInput dafnyValue = ToDafny.DigestInput(nativeValue);
        Result<DafnySequence<? extends Byte>, Error> result = this._impl.Digest(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.Simple.ByteBuffer(result.dtor_value());
    }

    public ByteBuffer ECDSASign(ECDSASignInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.ECDSASignInput dafnyValue = ToDafny.ECDSASignInput(nativeValue);
        Result<DafnySequence<? extends Byte>, Error> result = this._impl.ECDSASign(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.Simple.ByteBuffer(result.dtor_value());
    }

    public Boolean ECDSAVerify(software.amazon.cryptography.primitives.model.ECDSAVerifyInput nativeValue) {
        ECDSAVerifyInput dafnyValue = ToDafny.ECDSAVerifyInput(nativeValue);
        Result<Boolean, Error> result = this._impl.ECDSAVerify(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return result.dtor_value();
    }

    public software.amazon.cryptography.primitives.model.GenerateECDSASignatureKeyOutput GenerateECDSASignatureKey(GenerateECDSASignatureKeyInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyInput dafnyValue = ToDafny.GenerateECDSASignatureKeyInput(nativeValue);
        Result<GenerateECDSASignatureKeyOutput, Error> result = this._impl.GenerateECDSASignatureKey(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.GenerateECDSASignatureKeyOutput(result.dtor_value());
    }

    public ByteBuffer GenerateRandomBytes(GenerateRandomBytesInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.GenerateRandomBytesInput dafnyValue = ToDafny.GenerateRandomBytesInput(nativeValue);
        Result<DafnySequence<? extends Byte>, Error> result = this._impl.GenerateRandomBytes(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.Simple.ByteBuffer(result.dtor_value());
    }

    public GenerateRSAKeyPairOutput GenerateRSAKeyPair(software.amazon.cryptography.primitives.model.GenerateRSAKeyPairInput nativeValue) {
        GenerateRSAKeyPairInput dafnyValue = ToDafny.GenerateRSAKeyPairInput(nativeValue);
        Result<software.amazon.cryptography.primitives.internaldafny.types.GenerateRSAKeyPairOutput, Error> result = this._impl.GenerateRSAKeyPair(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.GenerateRSAKeyPairOutput(result.dtor_value());
    }

    public GetRSAKeyModulusLengthOutput GetRSAKeyModulusLength(GetRSAKeyModulusLengthInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.GetRSAKeyModulusLengthInput dafnyValue = ToDafny.GetRSAKeyModulusLengthInput(nativeValue);
        Result<software.amazon.cryptography.primitives.internaldafny.types.GetRSAKeyModulusLengthOutput, Error> result = this._impl.GetRSAKeyModulusLength(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.GetRSAKeyModulusLengthOutput(result.dtor_value());
    }

    public ByteBuffer Hkdf(HkdfInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.HkdfInput dafnyValue = ToDafny.HkdfInput(nativeValue);
        Result<DafnySequence<? extends Byte>, Error> result = this._impl.Hkdf(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.Simple.ByteBuffer(result.dtor_value());
    }

    public ByteBuffer HkdfExpand(HkdfExpandInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.HkdfExpandInput dafnyValue = ToDafny.HkdfExpandInput(nativeValue);
        Result<DafnySequence<? extends Byte>, Error> result = this._impl.HkdfExpand(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.Simple.ByteBuffer(result.dtor_value());
    }

    public ByteBuffer HkdfExtract(software.amazon.cryptography.primitives.model.HkdfExtractInput nativeValue) {
        HkdfExtractInput dafnyValue = ToDafny.HkdfExtractInput(nativeValue);
        Result<DafnySequence<? extends Byte>, Error> result = this._impl.HkdfExtract(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.Simple.ByteBuffer(result.dtor_value());
    }

    public ByteBuffer HMac(software.amazon.cryptography.primitives.model.HMacInput nativeValue) {
        HMacInput dafnyValue = ToDafny.HMacInput(nativeValue);
        Result<DafnySequence<? extends Byte>, Error> result = this._impl.HMac(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.Simple.ByteBuffer(result.dtor_value());
    }

    public ByteBuffer KdfCounterMode(KdfCtrInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.KdfCtrInput dafnyValue = ToDafny.KdfCtrInput(nativeValue);
        Result<DafnySequence<? extends Byte>, Error> result = this._impl.KdfCounterMode(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.Simple.ByteBuffer(result.dtor_value());
    }

    public ByteBuffer RSADecrypt(software.amazon.cryptography.primitives.model.RSADecryptInput nativeValue) {
        RSADecryptInput dafnyValue = ToDafny.RSADecryptInput(nativeValue);
        Result<DafnySequence<? extends Byte>, Error> result = this._impl.RSADecrypt(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.Simple.ByteBuffer(result.dtor_value());
    }

    public ByteBuffer RSAEncrypt(RSAEncryptInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.RSAEncryptInput dafnyValue = ToDafny.RSAEncryptInput(nativeValue);
        Result<DafnySequence<? extends Byte>, Error> result = this._impl.RSAEncrypt(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.Simple.ByteBuffer(result.dtor_value());
    }

    protected IAwsCryptographicPrimitivesClient impl() {
        return this._impl;
    }

    static class BuilderImpl
    implements Builder {
        protected software.amazon.cryptography.primitives.model.CryptoConfig CryptoConfig;

        protected BuilderImpl() {
        }

        @Override
        public Builder CryptoConfig(software.amazon.cryptography.primitives.model.CryptoConfig CryptoConfig2) {
            this.CryptoConfig = CryptoConfig2;
            return this;
        }

        @Override
        public software.amazon.cryptography.primitives.model.CryptoConfig CryptoConfig() {
            return this.CryptoConfig;
        }

        @Override
        public AtomicPrimitives build() {
            if (Objects.isNull(this.CryptoConfig())) {
                throw new IllegalArgumentException("Missing value for required field `CryptoConfig`");
            }
            return new AtomicPrimitives(this);
        }
    }

    public static interface Builder {
        public Builder CryptoConfig(software.amazon.cryptography.primitives.model.CryptoConfig var1);

        public software.amazon.cryptography.primitives.model.CryptoConfig CryptoConfig();

        public AtomicPrimitives build();
    }
}

