/*
 * Decompiled with CFR 0.152.
 */
package UUID;

import Wrappers_Compile.Result;
import dafny.Array;
import dafny.DafnySequence;
import java.nio.ByteBuffer;
import java.util.UUID;
import software.amazon.smithy.dafny.conversion.ToDafny;
import software.amazon.smithy.dafny.conversion.ToNative;

public class __default {
    public static Result<DafnySequence<? extends Byte>, DafnySequence<? extends Character>> ToByteArray(DafnySequence<? extends Character> s) {
        try {
            UUID fromString = UUID.fromString(ToNative.Simple.String(s));
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
            byteBuffer.putLong(fromString.getMostSignificantBits());
            byteBuffer.putLong(fromString.getLeastSignificantBits());
            return Result.create_Success(ToDafny.Simple.ByteSequence((ByteBuffer)byteBuffer));
        }
        catch (Exception e) {
            return Result.create_Failure(ToDafny.Simple.CharacterSequence((String)"Could not convert UUID to byte array."));
        }
    }

    public static Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> FromByteArray(DafnySequence<? extends Byte> b) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])Array.unwrap((Array)b.toArray()));
            long high = byteBuffer.getLong();
            long low = byteBuffer.getLong();
            UUID fromByte = new UUID(high, low);
            return Result.create_Success(ToDafny.Simple.CharacterSequence((String)fromByte.toString()));
        }
        catch (Exception e) {
            return Result.create_Failure(ToDafny.Simple.CharacterSequence((String)"Could not convert byte array to UUID."));
        }
    }

    public static Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> GenerateUUID() {
        try {
            UUID uuid = UUID.randomUUID();
            return Result.create_Success(ToDafny.Simple.CharacterSequence((String)uuid.toString()));
        }
        catch (Exception e) {
            return Result.create_Failure(ToDafny.Simple.CharacterSequence((String)"Could not generate a UUID."));
        }
    }
}

