/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import software.amazon.cloudwatchlogs.emf.model.StorageResolution;
import software.amazon.cloudwatchlogs.emf.model.Unit;
import software.amazon.cloudwatchlogs.emf.serializers.StorageResolutionFilter;
import software.amazon.cloudwatchlogs.emf.serializers.StorageResolutionSerializer;
import software.amazon.cloudwatchlogs.emf.serializers.UnitDeserializer;
import software.amazon.cloudwatchlogs.emf.serializers.UnitSerializer;

class MetricDefinition {
    @JsonProperty(value="Name")
    @NonNull
    private String name;
    @JsonProperty(value="Unit")
    @JsonSerialize(using=UnitSerializer.class)
    @JsonDeserialize(using=UnitDeserializer.class)
    private Unit unit;
    @JsonProperty(value="StorageResolution")
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=StorageResolutionFilter.class)
    @JsonSerialize(using=StorageResolutionSerializer.class)
    public StorageResolution storageResolution;
    @JsonIgnore
    @NonNull
    private List<Double> values;

    MetricDefinition(String name) {
        this(name, Unit.NONE, StorageResolution.STANDARD, new ArrayList<Double>());
    }

    MetricDefinition(String name, double value) {
        this(name, Unit.NONE, StorageResolution.STANDARD, value);
    }

    MetricDefinition(String name, Unit unit, double value) {
        this(name, unit, StorageResolution.STANDARD, new ArrayList<Double>(Arrays.asList(value)));
    }

    MetricDefinition(String name, StorageResolution storageResolution, double value) {
        this(name, Unit.NONE, storageResolution, new ArrayList<Double>(Arrays.asList(value)));
    }

    MetricDefinition(String name, Unit unit, StorageResolution storageResolution, double value) {
        this(name, unit, storageResolution, new ArrayList<Double>(Arrays.asList(value)));
    }

    void addValue(double value) {
        this.values.add(value);
    }

    public MetricDefinition(@NonNull String name, Unit unit, StorageResolution storageResolution, @NonNull List<Double> values) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        this.name = name;
        this.unit = unit;
        this.storageResolution = storageResolution;
        this.values = values;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public StorageResolution getStorageResolution() {
        return this.storageResolution;
    }

    @JsonProperty(value="StorageResolution")
    public void setStorageResolution(StorageResolution storageResolution) {
        this.storageResolution = storageResolution;
    }

    @NonNull
    public List<Double> getValues() {
        return this.values;
    }
}

