/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import software.amazon.cloudwatchlogs.emf.exception.DimensionSetExceededException;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.MetricDefinition;
import software.amazon.cloudwatchlogs.emf.model.StorageResolution;
import software.amazon.cloudwatchlogs.emf.model.Unit;

class MetricDirective {
    @JsonProperty(value="Namespace")
    private String namespace;
    @JsonIgnore
    private Map<String, MetricDefinition> metrics;
    @JsonIgnore
    private List<DimensionSet> dimensions;
    @JsonIgnore
    private DimensionSet defaultDimensions;
    private boolean shouldUseDefaultDimension;

    MetricDirective() {
        this.namespace = "aws-embedded-metrics";
        this.metrics = new ConcurrentHashMap<String, MetricDefinition>();
        this.dimensions = Collections.synchronizedList(new ArrayList());
        this.defaultDimensions = new DimensionSet();
        this.shouldUseDefaultDimension = true;
    }

    void putDimensionSet(DimensionSet dimensionSet) {
        this.dimensions.removeIf(dim -> dim.getDimensionKeys().equals(dimensionSet.getDimensionKeys()));
        this.dimensions.add(dimensionSet);
    }

    void putMetric(String key, double value) {
        this.putMetric(key, value, Unit.NONE, StorageResolution.STANDARD);
    }

    void putMetric(String key, double value, Unit unit) {
        this.putMetric(key, value, unit, StorageResolution.STANDARD);
    }

    void putMetric(String key, double value, StorageResolution storageResolution) {
        this.putMetric(key, value, Unit.NONE, storageResolution);
    }

    void putMetric(String key, double value, Unit unit, StorageResolution storageResolution) {
        this.metrics.compute(key, (k, v) -> {
            if (v == null) {
                return new MetricDefinition(key, unit, storageResolution, value);
            }
            v.addValue(value);
            return v;
        });
    }

    @JsonProperty(value="Metrics")
    Collection<MetricDefinition> getAllMetrics() {
        return this.metrics.values();
    }

    @JsonProperty(value="Dimensions")
    List<Set<String>> getAllDimensionKeys() throws DimensionSetExceededException {
        return this.getAllDimensions().stream().map(DimensionSet::getDimensionKeys).collect(Collectors.toList());
    }

    void setDimensions(List<DimensionSet> dimensionSets) {
        this.shouldUseDefaultDimension = false;
        this.dimensions = Collections.synchronizedList(new ArrayList<DimensionSet>(dimensionSets));
    }

    void setDimensions(boolean useDefault, List<DimensionSet> dimensionSets) {
        this.shouldUseDefaultDimension = useDefault;
        this.dimensions = Collections.synchronizedList(new ArrayList<DimensionSet>(dimensionSets));
    }

    void resetDimensions(boolean useDefault) {
        this.shouldUseDefaultDimension = useDefault;
        this.dimensions = Collections.synchronizedList(new ArrayList());
    }

    List<DimensionSet> getAllDimensions() throws DimensionSetExceededException {
        if (!this.shouldUseDefaultDimension) {
            return this.dimensions;
        }
        if (this.dimensions.isEmpty()) {
            return Arrays.asList(this.defaultDimensions);
        }
        ArrayList<DimensionSet> allDimensions = new ArrayList<DimensionSet>();
        for (DimensionSet dim : this.dimensions) {
            allDimensions.add(this.defaultDimensions.add(dim));
        }
        return allDimensions;
    }

    boolean hasNoMetrics() {
        return this.getMetrics().isEmpty();
    }

    MetricDirective copyWithoutMetrics(boolean preserveDimensions) {
        MetricDirective metricDirective = new MetricDirective();
        metricDirective.setDefaultDimensions(this.defaultDimensions);
        metricDirective.setNamespace(this.namespace);
        metricDirective.shouldUseDefaultDimension = this.shouldUseDefaultDimension;
        if (preserveDimensions) {
            this.dimensions.forEach(metricDirective::putDimensionSet);
        }
        return metricDirective;
    }

    public MetricDirective(String namespace, Map<String, MetricDefinition> metrics, List<DimensionSet> dimensions, DimensionSet defaultDimensions, boolean shouldUseDefaultDimension) {
        this.namespace = namespace;
        this.metrics = metrics;
        this.dimensions = dimensions;
        this.defaultDimensions = defaultDimensions;
        this.shouldUseDefaultDimension = shouldUseDefaultDimension;
    }

    @JsonProperty(value="Namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @JsonIgnore
    public void setMetrics(Map<String, MetricDefinition> metrics) {
        this.metrics = metrics;
    }

    public Map<String, MetricDefinition> getMetrics() {
        return this.metrics;
    }

    public MetricDirective withMetrics(Map<String, MetricDefinition> metrics) {
        return this.metrics == metrics ? this : new MetricDirective(this.namespace, metrics, this.dimensions, this.defaultDimensions, this.shouldUseDefaultDimension);
    }

    protected List<DimensionSet> getDimensions() {
        return this.dimensions;
    }

    @JsonIgnore
    public void setDefaultDimensions(DimensionSet defaultDimensions) {
        this.defaultDimensions = defaultDimensions;
    }

    protected DimensionSet getDefaultDimensions() {
        return this.defaultDimensions;
    }
}

