/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.environment;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import software.amazon.cloudwatchlogs.emf.config.Configuration;
import software.amazon.cloudwatchlogs.emf.config.EnvironmentConfigurationProvider;
import software.amazon.cloudwatchlogs.emf.environment.DefaultEnvironment;
import software.amazon.cloudwatchlogs.emf.environment.EC2Environment;
import software.amazon.cloudwatchlogs.emf.environment.ECSEnvironment;
import software.amazon.cloudwatchlogs.emf.environment.Environment;
import software.amazon.cloudwatchlogs.emf.environment.LambdaEnvironment;
import software.amazon.cloudwatchlogs.emf.environment.LocalEnvironment;
import software.amazon.cloudwatchlogs.emf.environment.ResourceFetcher;

public class EnvironmentProvider {
    private static Environment cachedEnvironment;
    private final Configuration config = EnvironmentConfigurationProvider.getConfig();
    private final Environment lambdaEnvironment = new LambdaEnvironment();
    private final Environment defaultEnvironment = new DefaultEnvironment(this.config);
    private final Environment ec2Environment = new EC2Environment(this.config, new ResourceFetcher());
    private final Environment ecsEnvironment = new ECSEnvironment(this.config, new ResourceFetcher());
    private final Environment[] environments = new Environment[]{this.lambdaEnvironment, this.ecsEnvironment, this.ec2Environment, this.defaultEnvironment};

    public CompletableFuture<Environment> resolveEnvironment() {
        if (cachedEnvironment != null) {
            return CompletableFuture.completedFuture(cachedEnvironment);
        }
        Optional<Environment> env = this.getEnvironmentFromOverride();
        if (env.isPresent()) {
            cachedEnvironment = env.get();
            return CompletableFuture.completedFuture(cachedEnvironment);
        }
        CompletableFuture<Optional<Environment>> resolvedEnv = this.discoverEnvironmentAsync();
        return resolvedEnv.thenApply(optionalEnv -> {
            cachedEnvironment = optionalEnv.orElse(this.defaultEnvironment);
            return cachedEnvironment;
        });
    }

    public Environment getDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    void cleanResolvedEnvironment() {
        cachedEnvironment = null;
    }

    private CompletableFuture<Optional<Environment>> discoverEnvironmentAsync() {
        CompletableFuture<Optional<Environment>> ans = new CompletableFuture<Optional<Environment>>();
        ArrayList<CompletableFuture<EnvironmentResolveResult>> futures = new ArrayList<CompletableFuture<EnvironmentResolveResult>>();
        for (Environment env : this.environments) {
            CompletableFuture<EnvironmentResolveResult> future = CompletableFuture.supplyAsync(() -> new EnvironmentResolveResult(env.probe(), env));
            futures.add(future);
        }
        CompletableFuture.runAsync(() -> {
            for (CompletableFuture future : futures) {
                EnvironmentResolveResult result = (EnvironmentResolveResult)future.join();
                if (!result.isCandidate) continue;
                ans.complete(Optional.of(result.environment));
                return;
            }
            ans.complete(Optional.empty());
        });
        return ans;
    }

    private Optional<Environment> getEnvironmentFromOverride() {
        Optional<Environment> environment;
        Configuration config = EnvironmentConfigurationProvider.getConfig();
        switch (config.getEnvironmentOverride()) {
            case Lambda: {
                environment = Optional.of(this.lambdaEnvironment);
                break;
            }
            case Agent: {
                environment = Optional.of(this.defaultEnvironment);
                break;
            }
            case EC2: {
                environment = Optional.of(this.ec2Environment);
                break;
            }
            case ECS: {
                environment = Optional.of(this.ecsEnvironment);
                break;
            }
            case Local: {
                environment = Optional.of(new LocalEnvironment(config));
                break;
            }
            default: {
                environment = Optional.empty();
            }
        }
        return environment;
    }

    static class EnvironmentResolveResult {
        private boolean isCandidate;
        private Environment environment;

        public EnvironmentResolveResult(boolean isCandidate, Environment environment) {
            this.isCandidate = isCandidate;
            this.environment = environment;
        }

        public boolean isCandidate() {
            return this.isCandidate;
        }

        public Environment getEnvironment() {
            return this.environment;
        }

        public void setCandidate(boolean isCandidate) {
            this.isCandidate = isCandidate;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnvironmentResolveResult)) {
                return false;
            }
            EnvironmentResolveResult other = (EnvironmentResolveResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCandidate() != other.isCandidate()) {
                return false;
            }
            Environment this$environment = this.getEnvironment();
            Environment other$environment = other.getEnvironment();
            return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnvironmentResolveResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCandidate() ? 79 : 97);
            Environment $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            return result;
        }

        public String toString() {
            return "EnvironmentProvider.EnvironmentResolveResult(isCandidate=" + this.isCandidate() + ", environment=" + this.getEnvironment() + ")";
        }
    }
}

