/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.MetricDefinition;

class MetricDirective {
    @JsonProperty(value="Namespace")
    private String namespace = "aws-embedded-metrics";
    @JsonProperty(value="Metrics")
    private List<MetricDefinition> metrics = new ArrayList<MetricDefinition>();
    private List<DimensionSet> dimensions = new ArrayList<DimensionSet>();
    private DimensionSet defaultDimensions = new DimensionSet();
    private boolean shouldUseDefaultDimension = true;

    MetricDirective() {
    }

    void putDimensionSet(DimensionSet dimensionSet) {
        this.dimensions.add(dimensionSet);
    }

    void putMetric(MetricDefinition metric) {
        this.metrics.add(metric);
    }

    @JsonProperty(value="Dimensions")
    List<Set<String>> getAllDimensionKeys() {
        return this.getAllDimensions().stream().map(DimensionSet::getDimensionKeys).collect(Collectors.toList());
    }

    void setDimensions(List<DimensionSet> dimensionSets) {
        this.shouldUseDefaultDimension = false;
        this.dimensions = dimensionSets;
    }

    List<DimensionSet> getAllDimensions() {
        if (!this.shouldUseDefaultDimension) {
            return this.dimensions;
        }
        if (this.dimensions.isEmpty()) {
            return Arrays.asList(this.defaultDimensions);
        }
        return this.dimensions.stream().map(dim -> this.defaultDimensions.add((DimensionSet)dim)).collect(Collectors.toList());
    }

    boolean hasNoMetrics() {
        return this.getMetrics().isEmpty();
    }

    @JsonProperty(value="Namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="Metrics")
    public void setMetrics(List<MetricDefinition> metrics) {
        this.metrics = metrics;
    }

    public List<MetricDefinition> getMetrics() {
        return this.metrics;
    }

    protected List<DimensionSet> getDimensions() {
        return this.dimensions;
    }

    public void setDefaultDimensions(DimensionSet defaultDimensions) {
        this.defaultDimensions = defaultDimensions;
    }

    protected DimensionSet getDefaultDimensions() {
        return this.defaultDimensions;
    }
}

