/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.JSONPointer;
import org.everit.json.schema.JSONPointerException;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.PublicJSONPointer;
import org.everit.json.schema.Schema;
import org.json.JSONObject;
import software.amazon.cloudformation.resource.Handler;
import software.amazon.cloudformation.resource.Validator;
import software.amazon.cloudformation.resource.exceptions.ValidationException;

public class ResourceTypeSchema {
    private static final Validator VALIDATOR = new Validator();
    private static final Integer DEFAULT_TIMEOUT_IN_MINUTES = 120;
    private final Map<String, Object> unprocessedProperties = new HashMap<String, Object>();
    private final String sourceUrl;
    private final String documentationUrl;
    private final String typeName;
    private final String schemaUrl;
    private final String replacementStrategy;
    private final boolean taggable;
    private final List<JSONPointer> createOnlyProperties = new ArrayList<JSONPointer>();
    private final List<JSONPointer> deprecatedProperties = new ArrayList<JSONPointer>();
    private final List<JSONPointer> primaryIdentifier = new ArrayList<JSONPointer>();
    private final List<List<JSONPointer>> additionalIdentifiers = new ArrayList<List<JSONPointer>>();
    private final List<JSONPointer> readOnlyProperties = new ArrayList<JSONPointer>();
    private final List<JSONPointer> writeOnlyProperties = new ArrayList<JSONPointer>();
    private final Map<String, String> propertyTransform = new HashMap<String, String>();
    private final Map<String, Handler> handlers = new HashMap<String, Handler>();
    private final Schema schema;

    public ResourceTypeSchema(Schema schema) {
        this.schema = schema;
        schema.getUnprocessedProperties().forEach(this.unprocessedProperties::put);
        this.sourceUrl = this.unprocessedProperties.containsKey("sourceUrl") ? this.unprocessedProperties.get("sourceUrl").toString() : null;
        this.unprocessedProperties.remove("sourceUrl");
        this.documentationUrl = this.unprocessedProperties.containsKey("documentationUrl") ? this.unprocessedProperties.get("documentationUrl").toString() : null;
        this.unprocessedProperties.remove("documentationUrl");
        this.typeName = this.unprocessedProperties.get("typeName").toString();
        this.unprocessedProperties.remove("typeName");
        this.schemaUrl = this.unprocessedProperties.containsKey("$schema") ? this.unprocessedProperties.get("$schema").toString() : null;
        this.unprocessedProperties.remove("$schema");
        this.replacementStrategy = this.unprocessedProperties.containsKey("replacementStrategy") ? this.unprocessedProperties.get("replacementStrategy").toString() : "create_then_delete";
        this.unprocessedProperties.remove("replacementStrategy");
        this.taggable = this.unprocessedProperties.containsKey("taggable") ? Boolean.valueOf(this.unprocessedProperties.get("taggable").toString()) : true;
        this.unprocessedProperties.remove("taggable");
        this.unprocessedProperties.computeIfPresent("createOnlyProperties", (k, v) -> {
            ((ArrayList)v).forEach(p -> this.createOnlyProperties.add(new JSONPointer(p.toString())));
            return null;
        });
        this.unprocessedProperties.computeIfPresent("deprecatedProperties", (k, v) -> {
            ((ArrayList)v).forEach(p -> this.deprecatedProperties.add(new JSONPointer(p.toString())));
            return null;
        });
        this.unprocessedProperties.computeIfPresent("primaryIdentifier", (k, v) -> {
            ((ArrayList)v).forEach(p -> this.primaryIdentifier.add(new JSONPointer(p.toString())));
            return null;
        });
        this.unprocessedProperties.computeIfPresent("additionalIdentifiers", (k, v) -> {
            ((ArrayList)v).forEach(p -> {
                ArrayList identifiers = new ArrayList();
                ((ArrayList)p).forEach(pi -> identifiers.add(new JSONPointer(pi.toString())));
                this.additionalIdentifiers.add(identifiers);
            });
            return null;
        });
        this.unprocessedProperties.computeIfPresent("readOnlyProperties", (k, v) -> {
            ((ArrayList)v).forEach(p -> this.readOnlyProperties.add(new JSONPointer(p.toString())));
            return null;
        });
        this.unprocessedProperties.computeIfPresent("writeOnlyProperties", (k, v) -> {
            ((ArrayList)v).forEach(p -> this.writeOnlyProperties.add(new JSONPointer(p.toString())));
            return null;
        });
        this.unprocessedProperties.computeIfPresent("propertyTransform", (k, v) -> {
            ((Map)v).forEach((key, value) -> this.propertyTransform.put(key.toString(), value.toString()));
            return null;
        });
        this.unprocessedProperties.computeIfPresent("handlers", (k, v) -> {
            ((HashMap)v).keySet().forEach(handlerKey -> {
                HashMap handlerInfo = (HashMap)((HashMap)v).get(handlerKey);
                HashSet<String> handlerPermissions = new HashSet<String>();
                ((List)handlerInfo.get("permissions")).forEach(permission -> handlerPermissions.add(permission.toString()));
                Integer timeoutInMinutes = handlerInfo.containsKey("timeoutInMinutes") ? (Integer)handlerInfo.get("timeoutInMinutes") : DEFAULT_TIMEOUT_IN_MINUTES;
                this.handlers.put(handlerKey.toString(), new Handler(handlerPermissions, timeoutInMinutes));
            });
            return null;
        });
    }

    public static ResourceTypeSchema load(JSONObject resourceDefinition) {
        Schema schema = VALIDATOR.loadResourceDefinitionSchema(resourceDefinition);
        return new ResourceTypeSchema(schema);
    }

    public String getDescription() {
        return this.schema.getDescription();
    }

    public List<String> getCreateOnlyPropertiesAsStrings() throws ValidationException {
        return this.createOnlyProperties.stream().map(JSONPointer::toString).collect(Collectors.toList());
    }

    public List<String> getDeprecatedPropertiesAsStrings() throws ValidationException {
        return this.deprecatedProperties.stream().map(JSONPointer::toString).collect(Collectors.toList());
    }

    public List<String> getPrimaryIdentifierAsStrings() throws ValidationException {
        return this.primaryIdentifier.stream().map(JSONPointer::toString).collect(Collectors.toList());
    }

    public List<List<String>> getAdditionalIdentifiersAsStrings() throws ValidationException {
        ArrayList<List<String>> identifiers = new ArrayList<List<String>>();
        this.additionalIdentifiers.forEach(i -> identifiers.add(i.stream().map(Object::toString).collect(Collectors.toList())));
        return identifiers;
    }

    public List<String> getReadOnlyPropertiesAsStrings() throws ValidationException {
        return this.readOnlyProperties.stream().map(JSONPointer::toString).collect(Collectors.toList());
    }

    public List<String> getWriteOnlyPropertiesAsStrings() throws ValidationException {
        return this.writeOnlyProperties.stream().map(JSONPointer::toString).collect(Collectors.toList());
    }

    public Set<String> getHandlerPermissions(String action) {
        return this.handlers.containsKey(action) ? this.handlers.get(action).getPermissions() : null;
    }

    public Integer getHandlerTimeoutInMinutes(String action) {
        return this.handlers.containsKey(action) ? this.handlers.get(action).getTimeoutInMinutes() : null;
    }

    public Boolean hasHandler(String action) {
        return this.handlers.containsKey(action);
    }

    public Map<String, Object> getUnprocessedProperties() {
        return Collections.unmodifiableMap(this.unprocessedProperties);
    }

    public void removeWriteOnlyProperties(JSONObject resourceModel) {
        this.getWriteOnlyPropertiesAsStrings().stream().forEach(writeOnlyProperty -> ResourceTypeSchema.removeProperty(new PublicJSONPointer(writeOnlyProperty.replaceFirst("^/properties", "")), resourceModel));
    }

    public String getReplacementStrategy() {
        return this.replacementStrategy;
    }

    public static void removeProperty(PublicJSONPointer property, JSONObject resourceModel) {
        List<String> refTokens = property.getRefTokens();
        String key = refTokens.get(refTokens.size() - 1);
        try {
            if (refTokens.size() > 1) {
                JSONPointer parentObjectPointer = new JSONPointer(refTokens.subList(0, refTokens.size() - 1));
                JSONObject parentObject = (JSONObject)parentObjectPointer.queryFrom((Object)resourceModel);
                parentObject.remove(key);
            } else {
                resourceModel.remove(key);
            }
        }
        catch (NumberFormatException | JSONPointerException throwable) {
            // empty catch block
        }
    }

    public boolean definesProperty(String field) {
        Schema schemaToCheck = this.schema instanceof CombinedSchema ? ((CombinedSchema)this.schema).getSubschemas().stream().filter(subschema -> subschema instanceof ObjectSchema).findFirst().get() : this.schema;
        return schemaToCheck.definesProperty(field);
    }

    public void validate(JSONObject json) {
        this.getSchema().validate((Object)json);
    }

    @Generated
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @Generated
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getSchemaUrl() {
        return this.schemaUrl;
    }

    @Generated
    public boolean isTaggable() {
        return this.taggable;
    }

    @Generated
    public List<JSONPointer> getCreateOnlyProperties() {
        return this.createOnlyProperties;
    }

    @Generated
    public List<JSONPointer> getDeprecatedProperties() {
        return this.deprecatedProperties;
    }

    @Generated
    public List<JSONPointer> getPrimaryIdentifier() {
        return this.primaryIdentifier;
    }

    @Generated
    public List<List<JSONPointer>> getAdditionalIdentifiers() {
        return this.additionalIdentifiers;
    }

    @Generated
    public List<JSONPointer> getReadOnlyProperties() {
        return this.readOnlyProperties;
    }

    @Generated
    public List<JSONPointer> getWriteOnlyProperties() {
        return this.writeOnlyProperties;
    }

    @Generated
    public Map<String, String> getPropertyTransform() {
        return this.propertyTransform;
    }

    @Generated
    public Schema getSchema() {
        return this.schema;
    }
}

