/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.resource;

import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.json.JSONObject;
import org.json.JSONTokener;
import software.amazon.cloudformation.resource.SchemaValidator;
import software.amazon.cloudformation.resource.exceptions.ValidationException;

public class Validator
implements SchemaValidator {
    private static final URI JSON_SCHEMA_URI_HTTPS = Validator.newURI("https://json-schema.org/draft-07/schema");
    private static final URI JSON_SCHEMA_URI_HTTP = Validator.newURI("http://json-schema.org/draft-07/schema");
    private static final URI RESOURCE_DEFINITION_SCHEMA_URI = Validator.newURI("https://schema.cloudformation.us-east-1.amazonaws.com/provider.definition.schema.v1.json");
    private static final String JSON_SCHEMA_PATH = "/schema/schema";
    private static final String RESOURCE_DEFINITION_SCHEMA_PATH = "/schema/provider.definition.schema.v1.json";
    private final JSONObject definitionSchemaJsonObject;
    private final JSONObject jsonSchemaObject;
    private final SchemaClient downloader;

    Validator(SchemaClient downloader) {
        this(Validator.loadResourceAsJSON(JSON_SCHEMA_PATH), Validator.loadResourceAsJSON(RESOURCE_DEFINITION_SCHEMA_PATH), downloader);
    }

    private Validator(JSONObject jsonSchema, JSONObject definitionSchema, SchemaClient downloader) {
        this.jsonSchemaObject = jsonSchema;
        this.definitionSchemaJsonObject = definitionSchema;
        this.downloader = downloader;
    }

    public Validator() {
        this((SchemaClient)new DefaultSchemaClient());
    }

    @Override
    public void validateObject(JSONObject modelObject, JSONObject definitionSchemaObject) throws ValidationException {
        SchemaLoader.SchemaLoaderBuilder loader = this.getSchemaLoader(definitionSchemaObject);
        try {
            Schema schema = loader.build().load().build();
            schema.validate((Object)modelObject);
        }
        catch (org.everit.json.schema.ValidationException e) {
            throw ValidationException.newScrubbedException(e);
        }
    }

    public void validateResourceDefinition(JSONObject definition) throws ValidationException {
        definition.put("$schema", (Object)RESOURCE_DEFINITION_SCHEMA_URI.toString());
        this.validateObject(definition, this.definitionSchemaJsonObject);
        this.loadResourceSchema(definition);
    }

    public Schema loadResourceSchema(JSONObject resourceDefinition) {
        return this.getResourceSchemaBuilder(resourceDefinition).build();
    }

    public Schema.Builder<?> getResourceSchemaBuilder(JSONObject resourceDefinition) {
        SchemaLoader.SchemaLoaderBuilder loaderBuilder = this.getSchemaLoader(resourceDefinition);
        loaderBuilder.registerSchemaByURI(RESOURCE_DEFINITION_SCHEMA_URI, (Object)this.definitionSchemaJsonObject);
        SchemaLoader loader = loaderBuilder.build();
        try {
            return loader.load();
        }
        catch (SchemaException e) {
            throw new ValidationException(e.getMessage(), e.getSchemaLocation(), (Exception)((Object)e));
        }
    }

    private SchemaLoader.SchemaLoaderBuilder getSchemaLoader(JSONObject schemaObject) {
        SchemaLoader.SchemaLoaderBuilder builder = SchemaLoader.builder().schemaJson(schemaObject).draftV7Support().schemaClient(this.downloader);
        builder.registerSchemaByURI(JSON_SCHEMA_URI_HTTP, (Object)this.jsonSchemaObject);
        builder.registerSchemaByURI(JSON_SCHEMA_URI_HTTPS, (Object)this.jsonSchemaObject);
        return builder;
    }

    private static JSONObject loadResourceAsJSON(String path) {
        return new JSONObject(new JSONTokener(Validator.class.getResourceAsStream(path)));
    }

    static URI newURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(uri);
        }
    }

    @Generated
    public static ValidatorBuilder builder() {
        return new ValidatorBuilder();
    }

    @Generated
    public static class ValidatorBuilder {
        @Generated
        ValidatorBuilder() {
        }

        @Generated
        public Validator build() {
            return new Validator();
        }

        @Generated
        public String toString() {
            return "Validator.ValidatorBuilder()";
        }
    }
}

