/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackendConnectionErrors
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackendConnectionErrors> {
    private static final SdkField<Integer> TIMEOUT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BackendConnectionErrors.getter(BackendConnectionErrors::timeoutCount)).setter(BackendConnectionErrors.setter(Builder::timeoutCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutCount").build()}).build();
    private static final SdkField<Integer> CONNECTION_REFUSED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BackendConnectionErrors.getter(BackendConnectionErrors::connectionRefusedCount)).setter(BackendConnectionErrors.setter(Builder::connectionRefusedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionRefusedCount").build()}).build();
    private static final SdkField<Integer> HTTP_CODE4_XX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BackendConnectionErrors.getter(BackendConnectionErrors::httpCode4XXCount)).setter(BackendConnectionErrors.setter(Builder::httpCode4XXCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPCode4XXCount").build()}).build();
    private static final SdkField<Integer> HTTP_CODE5_XX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BackendConnectionErrors.getter(BackendConnectionErrors::httpCode5XXCount)).setter(BackendConnectionErrors.setter(Builder::httpCode5XXCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPCode5XXCount").build()}).build();
    private static final SdkField<Integer> UNKNOWN_HOST_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BackendConnectionErrors.getter(BackendConnectionErrors::unknownHostCount)).setter(BackendConnectionErrors.setter(Builder::unknownHostCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnknownHostCount").build()}).build();
    private static final SdkField<Integer> OTHER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BackendConnectionErrors.getter(BackendConnectionErrors::otherCount)).setter(BackendConnectionErrors.setter(Builder::otherCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_COUNT_FIELD, CONNECTION_REFUSED_COUNT_FIELD, HTTP_CODE4_XX_COUNT_FIELD, HTTP_CODE5_XX_COUNT_FIELD, UNKNOWN_HOST_COUNT_FIELD, OTHER_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer timeoutCount;
    private final Integer connectionRefusedCount;
    private final Integer httpCode4XXCount;
    private final Integer httpCode5XXCount;
    private final Integer unknownHostCount;
    private final Integer otherCount;

    private BackendConnectionErrors(BuilderImpl builder) {
        this.timeoutCount = builder.timeoutCount;
        this.connectionRefusedCount = builder.connectionRefusedCount;
        this.httpCode4XXCount = builder.httpCode4XXCount;
        this.httpCode5XXCount = builder.httpCode5XXCount;
        this.unknownHostCount = builder.unknownHostCount;
        this.otherCount = builder.otherCount;
    }

    public Integer timeoutCount() {
        return this.timeoutCount;
    }

    public Integer connectionRefusedCount() {
        return this.connectionRefusedCount;
    }

    public Integer httpCode4XXCount() {
        return this.httpCode4XXCount;
    }

    public Integer httpCode5XXCount() {
        return this.httpCode5XXCount;
    }

    public Integer unknownHostCount() {
        return this.unknownHostCount;
    }

    public Integer otherCount() {
        return this.otherCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionRefusedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpCode4XXCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpCode5XXCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unknownHostCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendConnectionErrors)) {
            return false;
        }
        BackendConnectionErrors other = (BackendConnectionErrors)obj;
        return Objects.equals(this.timeoutCount(), other.timeoutCount()) && Objects.equals(this.connectionRefusedCount(), other.connectionRefusedCount()) && Objects.equals(this.httpCode4XXCount(), other.httpCode4XXCount()) && Objects.equals(this.httpCode5XXCount(), other.httpCode5XXCount()) && Objects.equals(this.unknownHostCount(), other.unknownHostCount()) && Objects.equals(this.otherCount(), other.otherCount());
    }

    public String toString() {
        return ToString.builder((String)"BackendConnectionErrors").add("TimeoutCount", (Object)this.timeoutCount()).add("ConnectionRefusedCount", (Object)this.connectionRefusedCount()).add("HTTPCode4XXCount", (Object)this.httpCode4XXCount()).add("HTTPCode5XXCount", (Object)this.httpCode5XXCount()).add("UnknownHostCount", (Object)this.unknownHostCount()).add("OtherCount", (Object)this.otherCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeoutCount": {
                return Optional.ofNullable(clazz.cast(this.timeoutCount()));
            }
            case "ConnectionRefusedCount": {
                return Optional.ofNullable(clazz.cast(this.connectionRefusedCount()));
            }
            case "HTTPCode4XXCount": {
                return Optional.ofNullable(clazz.cast(this.httpCode4XXCount()));
            }
            case "HTTPCode5XXCount": {
                return Optional.ofNullable(clazz.cast(this.httpCode5XXCount()));
            }
            case "UnknownHostCount": {
                return Optional.ofNullable(clazz.cast(this.unknownHostCount()));
            }
            case "OtherCount": {
                return Optional.ofNullable(clazz.cast(this.otherCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackendConnectionErrors, T> g) {
        return obj -> g.apply((BackendConnectionErrors)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer timeoutCount;
        private Integer connectionRefusedCount;
        private Integer httpCode4XXCount;
        private Integer httpCode5XXCount;
        private Integer unknownHostCount;
        private Integer otherCount;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendConnectionErrors model) {
            this.timeoutCount(model.timeoutCount);
            this.connectionRefusedCount(model.connectionRefusedCount);
            this.httpCode4XXCount(model.httpCode4XXCount);
            this.httpCode5XXCount(model.httpCode5XXCount);
            this.unknownHostCount(model.unknownHostCount);
            this.otherCount(model.otherCount);
        }

        public final Integer getTimeoutCount() {
            return this.timeoutCount;
        }

        @Override
        public final Builder timeoutCount(Integer timeoutCount) {
            this.timeoutCount = timeoutCount;
            return this;
        }

        public final void setTimeoutCount(Integer timeoutCount) {
            this.timeoutCount = timeoutCount;
        }

        public final Integer getConnectionRefusedCount() {
            return this.connectionRefusedCount;
        }

        @Override
        public final Builder connectionRefusedCount(Integer connectionRefusedCount) {
            this.connectionRefusedCount = connectionRefusedCount;
            return this;
        }

        public final void setConnectionRefusedCount(Integer connectionRefusedCount) {
            this.connectionRefusedCount = connectionRefusedCount;
        }

        public final Integer getHttpCode4XXCount() {
            return this.httpCode4XXCount;
        }

        @Override
        public final Builder httpCode4XXCount(Integer httpCode4XXCount) {
            this.httpCode4XXCount = httpCode4XXCount;
            return this;
        }

        public final void setHttpCode4XXCount(Integer httpCode4XXCount) {
            this.httpCode4XXCount = httpCode4XXCount;
        }

        public final Integer getHttpCode5XXCount() {
            return this.httpCode5XXCount;
        }

        @Override
        public final Builder httpCode5XXCount(Integer httpCode5XXCount) {
            this.httpCode5XXCount = httpCode5XXCount;
            return this;
        }

        public final void setHttpCode5XXCount(Integer httpCode5XXCount) {
            this.httpCode5XXCount = httpCode5XXCount;
        }

        public final Integer getUnknownHostCount() {
            return this.unknownHostCount;
        }

        @Override
        public final Builder unknownHostCount(Integer unknownHostCount) {
            this.unknownHostCount = unknownHostCount;
            return this;
        }

        public final void setUnknownHostCount(Integer unknownHostCount) {
            this.unknownHostCount = unknownHostCount;
        }

        public final Integer getOtherCount() {
            return this.otherCount;
        }

        @Override
        public final Builder otherCount(Integer otherCount) {
            this.otherCount = otherCount;
            return this;
        }

        public final void setOtherCount(Integer otherCount) {
            this.otherCount = otherCount;
        }

        public BackendConnectionErrors build() {
            return new BackendConnectionErrors(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackendConnectionErrors> {
        public Builder timeoutCount(Integer var1);

        public Builder connectionRefusedCount(Integer var1);

        public Builder httpCode4XXCount(Integer var1);

        public Builder httpCode5XXCount(Integer var1);

        public Builder unknownHostCount(Integer var1);

        public Builder otherCount(Integer var1);
    }
}

