/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Temporary boost sampling rate. X-Ray calculates sampling boost for each service based on the recent sampling boost
 * stats of all services that called <a
 * href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html">GetSamplingTargets</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamplingBoost implements SdkPojo, Serializable, ToCopyableBuilder<SamplingBoost.Builder, SamplingBoost> {
    private static final SdkField<Double> BOOST_RATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("BoostRate").getter(getter(SamplingBoost::boostRate)).setter(setter(Builder::boostRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoostRate").build()).build();

    private static final SdkField<Instant> BOOST_RATE_TTL_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("BoostRateTTL").getter(getter(SamplingBoost::boostRateTTL)).setter(setter(Builder::boostRateTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoostRateTTL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOST_RATE_FIELD,
            BOOST_RATE_TTL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double boostRate;

    private final Instant boostRateTTL;

    private SamplingBoost(BuilderImpl builder) {
        this.boostRate = builder.boostRate;
        this.boostRateTTL = builder.boostRateTTL;
    }

    /**
     * <p>
     * The calculated sampling boost rate for this service
     * </p>
     * 
     * @return The calculated sampling boost rate for this service
     */
    public final Double boostRate() {
        return boostRate;
    }

    /**
     * <p>
     * When the sampling boost expires.
     * </p>
     * 
     * @return When the sampling boost expires.
     */
    public final Instant boostRateTTL() {
        return boostRateTTL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(boostRate());
        hashCode = 31 * hashCode + Objects.hashCode(boostRateTTL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingBoost)) {
            return false;
        }
        SamplingBoost other = (SamplingBoost) obj;
        return Objects.equals(boostRate(), other.boostRate()) && Objects.equals(boostRateTTL(), other.boostRateTTL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SamplingBoost").add("BoostRate", boostRate()).add("BoostRateTTL", boostRateTTL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BoostRate":
            return Optional.ofNullable(clazz.cast(boostRate()));
        case "BoostRateTTL":
            return Optional.ofNullable(clazz.cast(boostRateTTL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BoostRate", BOOST_RATE_FIELD);
        map.put("BoostRateTTL", BOOST_RATE_TTL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamplingBoost, T> g) {
        return obj -> g.apply((SamplingBoost) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamplingBoost> {
        /**
         * <p>
         * The calculated sampling boost rate for this service
         * </p>
         * 
         * @param boostRate
         *        The calculated sampling boost rate for this service
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boostRate(Double boostRate);

        /**
         * <p>
         * When the sampling boost expires.
         * </p>
         * 
         * @param boostRateTTL
         *        When the sampling boost expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boostRateTTL(Instant boostRateTTL);
    }

    static final class BuilderImpl implements Builder {
        private Double boostRate;

        private Instant boostRateTTL;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingBoost model) {
            boostRate(model.boostRate);
            boostRateTTL(model.boostRateTTL);
        }

        public final Double getBoostRate() {
            return boostRate;
        }

        public final void setBoostRate(Double boostRate) {
            this.boostRate = boostRate;
        }

        @Override
        public final Builder boostRate(Double boostRate) {
            this.boostRate = boostRate;
            return this;
        }

        public final Instant getBoostRateTTL() {
            return boostRateTTL;
        }

        public final void setBoostRateTTL(Instant boostRateTTL) {
            this.boostRateTTL = boostRateTTL;
        }

        @Override
        public final Builder boostRateTTL(Instant boostRateTTL) {
            this.boostRateTTL = boostRateTTL;
            return this;
        }

        @Override
        public SamplingBoost build() {
            return new SamplingBoost(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
