/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGroupResponse extends XRayResponse implements
        ToCopyableBuilder<CreateGroupResponse.Builder, CreateGroupResponse> {
    private static final SdkField<Group> GROUP_FIELD = SdkField.<Group> builder(MarshallingType.SDK_POJO).memberName("Group")
            .getter(getter(CreateGroupResponse::group)).setter(setter(Builder::group)).constructor(Group::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Group group;

    private CreateGroupResponse(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
    }

    /**
     * <p>
     * The group that was created. Contains the name of the group that was created, the Amazon Resource Name (ARN) of
     * the group that was generated based on the group name, the filter expression, and the insight configuration that
     * was assigned to the group.
     * </p>
     * 
     * @return The group that was created. Contains the name of the group that was created, the Amazon Resource Name
     *         (ARN) of the group that was generated based on the group name, the filter expression, and the insight
     *         configuration that was assigned to the group.
     */
    public final Group group() {
        return group;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(group());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupResponse)) {
            return false;
        }
        CreateGroupResponse other = (CreateGroupResponse) obj;
        return Objects.equals(group(), other.group());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGroupResponse").add("Group", group()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Group", GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupResponse, T> g) {
        return obj -> g.apply((CreateGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGroupResponse> {
        /**
         * <p>
         * The group that was created. Contains the name of the group that was created, the Amazon Resource Name (ARN)
         * of the group that was generated based on the group name, the filter expression, and the insight configuration
         * that was assigned to the group.
         * </p>
         * 
         * @param group
         *        The group that was created. Contains the name of the group that was created, the Amazon Resource Name
         *        (ARN) of the group that was generated based on the group name, the filter expression, and the insight
         *        configuration that was assigned to the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(Group group);

        /**
         * <p>
         * The group that was created. Contains the name of the group that was created, the Amazon Resource Name (ARN)
         * of the group that was generated based on the group name, the filter expression, and the insight configuration
         * that was assigned to the group.
         * </p>
         * This is a convenience method that creates an instance of the {@link Group.Builder} avoiding the need to
         * create one manually via {@link Group#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Group.Builder#build()} is called immediately and its result is
         * passed to {@link #group(Group)}.
         * 
         * @param group
         *        a consumer that will call methods on {@link Group.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #group(Group)
         */
        default Builder group(Consumer<Group.Builder> group) {
            return group(Group.builder().applyMutation(group).build());
        }
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private Group group;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupResponse model) {
            super(model);
            group(model.group);
        }

        public final Group.Builder getGroup() {
            return group != null ? group.toBuilder() : null;
        }

        public final void setGroup(Group.BuilderImpl group) {
            this.group = group != null ? group.build() : null;
        }

        @Override
        public final Builder group(Group group) {
            this.group = group;
            return this;
        }

        @Override
        public CreateGroupResponse build() {
            return new CreateGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
